/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.voice.api;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.log.RecordService;
import com.dtf.voice.api.IVoiceCallBack;
import com.dtf.voice.api.IVoiceControl;
import com.dtf.voice.api.VoiceMetaInfo;
import com.dtf.voice.api.VoiceResponse;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import wishverify.a;
import wishverify.f;
import wishverify.g;
import wishverify.h;
import wishverify.i;

public class VoiceFacade
implements IVoiceControl {
    public static final String ZIM_EXT_PARAMS_KEY_CHANNEL_COUNT = "ext_params_channel_count";
    public static final String ZIM_EXT_PARAMS_KEY_SAMPLE_RATE = "ext_params_sample_rate";
    public static final String ZIM_EXT_PARAMS_KEY_BIT = "ext_params_bit_rate";
    public static final String ZIM_EXT_PARAMS_KEY_MIN_DB = "ext_params_mini_db";
    public static final String ZIM_EXT_PARAMS_KEY_RECORD_MAX_TIME = "ext_params_max_time";
    public static final String ZIM_EXT_PARAMS_KEY_RECORD_MIN_TIME = "ext_params_min_time";
    public static final String ZIM_EXT_PARAMS_KEY_FILE_PATH = "ext_params_file_path";
    public Context context;
    public IVoiceCallBack callBack;
    public String zimID;
    public long maxTime = -1L;
    public long miniTime = -1L;
    public int miniDB = -1;
    public String audioPath = null;
    public f recorder = null;

    public VoiceFacade(Context context) {
        if (context != null) {
            context = context.getApplicationContext();
        }
        this.context = context;
    }

    public static void install(Context context) {
    }

    public static String getMetaInfo(Context object) {
        VoiceMetaInfo voiceMetaInfo;
        VoiceMetaInfo voiceMetaInfo2;
        VoiceMetaInfo voiceMetaInfo3 = voiceMetaInfo2 = voiceMetaInfo;
        voiceMetaInfo3();
        voiceMetaInfo3.setVoiceSdkVersion("1.0.0");
        voiceMetaInfo3.setDeviceType("android");
        try {
            voiceMetaInfo2.setAppName(object.getPackageName());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        voiceMetaInfo.setAppVersion(object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).versionName);
        VoiceMetaInfo voiceMetaInfo4 = voiceMetaInfo2;
        voiceMetaInfo4.setOsVersion(Build.VERSION.RELEASE);
        object = "";
        try {
            object = JSON.toJSONString((Object)voiceMetaInfo4);
        }
        catch (Throwable throwable) {}
        return object;
    }

    private int covertParamVal(Map<String, String> map, String string, int n2) {
        if (map != null && !TextUtils.isEmpty((CharSequence)string)) {
            String string2 = map.get(string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return n2;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (Throwable throwable) {
                return n2;
            }
        }
        return n2;
    }

    private void sendResponse(VoiceResponse voiceResponse, String string) {
        if (voiceResponse == null) {
            VoiceResponse voiceResponse2;
            voiceResponse = voiceResponse2;
            new VoiceResponse().code = 1001;
        }
        if (TextUtils.isEmpty((CharSequence)voiceResponse.reason)) {
            voiceResponse.reason = string;
        }
        String[] stringArray = object;
        voiceResponse.msg = ((VoiceFacade)object).zimID;
        String[] stringArray2 = new String[4];
        Object object = stringArray2;
        String[] stringArray3 = object;
        stringArray3[0] = "type";
        stringArray3[1] = "voiceResponse";
        object[2] = "response";
        stringArray2[3] = voiceResponse.toString();
        VoiceFacade.recordEvent("VoiceFacade", (String[])object);
        object = stringArray.callBack;
        if (object != null) {
            object.onVoiceResponse(voiceResponse);
        }
    }

    public static void recordEvent(String string, String ... stringArray) {
        try {
            RecordService.getInstance().recordEvent(RecordLevel.LOG_INFO, string, stringArray);
        }
        catch (Throwable throwable) {}
    }

    public IVoiceControl startRecord(String string, Map<String, String> map, IVoiceCallBack iVoiceCallBack) {
        ((VoiceFacade)object).callBack = iVoiceCallBack;
        ((VoiceFacade)object).zimID = string;
        int n2 = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_CHANNEL_COUNT, 1);
        int n3 = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_SAMPLE_RATE, 16000);
        int n4 = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_BIT, 16);
        ((VoiceFacade)object).miniDB = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_MIN_DB, 0);
        ((VoiceFacade)object).maxTime = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_RECORD_MAX_TIME, -1) * 1000;
        ((VoiceFacade)object).miniTime = ((VoiceFacade)object).covertParamVal(map, ZIM_EXT_PARAMS_KEY_RECORD_MIN_TIME, -1) * 1000;
        if (map != null) {
            ((VoiceFacade)object).audioPath = map.get(ZIM_EXT_PARAMS_KEY_FILE_PATH);
        }
        if (((VoiceFacade)object).audioPath == null) {
            ((VoiceFacade)object).audioPath = ((VoiceFacade)object).context.getCacheDir().getAbsolutePath() + "/" + System.currentTimeMillis() + ".wav";
        }
        VoiceFacade voiceFacade = object;
        try {
            new File(((VoiceFacade)object).audioPath).createNewFile();
        }
        catch (IOException iOException) {
            ((VoiceFacade)object).sendResponse(null, "Z7002");
            return null;
        }
        voiceFacade.recorder = voiceFacade.provideAudioRecorder("wav");
        Object object = voiceFacade.recorder;
        ((h)object).q = voiceFacade.getCallBack();
        object = voiceFacade.recorder;
        ((h)object).a(voiceFacade.audioPath, n2, n3, n4);
        return voiceFacade;
    }

    @Override
    public void stopRecord() {
        String[] stringArray = object;
        String[] stringArray2 = new String[2];
        Object object = stringArray2;
        stringArray2[0] = "type";
        stringArray2[1] = "stopRecord";
        VoiceFacade.recordEvent("VoiceFacade", object);
        object = stringArray.recorder;
        if (object != null) {
            ((h)object).b();
        }
    }

    @Override
    public void cancelRecord() {
        String[] stringArray = object;
        String[] stringArray2 = new String[2];
        Object object = stringArray2;
        stringArray2[0] = "type";
        stringArray2[1] = "cancelRecord";
        VoiceFacade.recordEvent("VoiceFacade", (String[])object);
        object = stringArray.recorder;
        if (object != null) {
            object = (h)object;
            if (((h)object).a != null) {
                Object object2 = object;
                ((h)object2).k.set(true);
                ((h)object2).i.set(false);
                ((h)object2).j.set(false);
                ((h)object2).c();
                if (((h)object2).a.getState() == 1) {
                    try {
                        ((h)object).a.stop();
                    }
                    catch (IllegalStateException illegalStateException) {
                        String[] stringArray3;
                        String[] stringArray4 = new String[4];
                        String[] stringArray5 = stringArray3 = stringArray4;
                        stringArray5[0] = "type";
                        stringArray5[1] = "onError";
                        stringArray3[2] = "exception";
                        stringArray4[3] = Log.getStackTraceString((Throwable)illegalStateException);
                        VoiceFacade.recordEvent("VoiceFacade", stringArray3);
                    }
                }
                Object object3 = object;
                ((h)object3).a.release();
                ((h)object3).h.interrupt();
                object = ((h)object3).q;
                if (object != null) {
                    object.onStopRecord();
                }
            }
        }
    }

    public f provideAudioRecorder(String string) {
        int n2 = -1;
        if (string.hashCode() == 117484 && string.equals("wav")) {
            n2 = 0;
        }
        if (n2 != 0) {
            return null;
        }
        return new h();
    }

    public g getCallBack() {
        return new g(){
            public int maxDb = 0;
            public long dbLevelMatchDuration = -1L;
            public long durationMills = 0L;
            public volatile boolean innerExit = false;

            private VoiceResponse getVoiceResponse(String string, File object, long l2) {
                VoiceResponse voiceResponse;
                String string2 = null;
                if (VoiceFacade.this.maxTime >= 0L && VoiceFacade.this.maxTime < l2) {
                    string2 = "Z7007";
                    i.a((File)object);
                }
                if (VoiceFacade.this.miniDB > 0 && string2 == null && this.maxDb < VoiceFacade.this.miniDB) {
                    string2 = "Z7008";
                    i.a((File)object);
                }
                if (VoiceFacade.this.miniTime >= 0L && string2 == null && VoiceFacade.this.miniTime > l2 - this.dbLevelMatchDuration) {
                    string2 = "Z7006";
                    i.a((File)object);
                }
                if (string2 == null) {
                    string2 = string;
                }
                VoiceResponse voiceResponse2 = voiceResponse;
                voiceResponse = new VoiceResponse();
                object = object != null ? ((File)object).getAbsolutePath() : null;
                VoiceResponse voiceResponse3 = voiceResponse2;
                voiceResponse3.voiceContent = object;
                voiceResponse3.voiceMD5 = null;
                voiceResponse2.durationMills = l2;
                voiceResponse2.maxDbLevel = this.maxDb;
                voiceResponse2.dbLevelMatchDurationMills = this.dbLevelMatchDuration;
                int n2 = "Z7000".equals(string2) ? 1000 : 1001;
                voiceResponse2.code = n2;
                if (string2 != null && !string2.equals(string)) {
                    voiceResponse2.reason = string2;
                }
                return voiceResponse2;
            }

            @Override
            public void onStartRecord() {
            }

            public void onPauseRecord() {
            }

            public void onResumeRecord() {
            }

            @Override
            public void onRecordProgress(long l2, int n2) {
                this.maxDb = n2;
                this.durationMills = l2;
                if (this.dbLevelMatchDuration <= 0L && n2 >= VoiceFacade.this.miniDB) {
                    this.dbLevelMatchDuration = l2;
                }
            }

            @Override
            public void onStopRecord() {
            }

            @Override
            public void onError(a a2) {
                String[] stringArray = this;
                String[] stringArray2 = this;
                String[] stringArray3 = new String[4];
                String[] stringArray4 = this = stringArray3;
                stringArray4[0] = "type";
                stringArray4[1] = "onError";
                this[2] = "exception";
                stringArray3[3] = Log.getStackTraceString((Throwable)a2);
                VoiceFacade.recordEvent("VoiceFacade", this);
                stringArray.VoiceFacade.this.sendResponse(null, a2.a());
                stringArray2.innerExit = true;
                stringArray.VoiceFacade.this.stopRecord();
                stringArray2.VoiceFacade.this.destroy();
            }

            @Override
            public void onFinishRecord(String string, File file, long l2) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "type";
                stringArray[1] = "onFinishRecord";
                VoiceFacade.recordEvent("VoiceFacade", stringArray2);
                if (voiceResponse.VoiceFacade.this.context != null && voiceResponse.VoiceFacade.this.callBack != null && voiceResponse.VoiceFacade.this.recorder != null && !voiceResponse.innerExit) {
                    1 v1 = voiceResponse;
                    VoiceResponse voiceResponse = v1.getVoiceResponse(string, file, l2);
                    v1.VoiceFacade.this.sendResponse(voiceResponse, string);
                    return;
                }
                i.a(file);
            }

            public boolean canBeginRecord() {
                return true;
            }
        };
    }

    public void destroy() {
        VoiceFacade voiceFacade = this;
        voiceFacade.context = null;
        voiceFacade.callBack = null;
        voiceFacade.recorder = null;
    }
}

