/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.camera;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import baseverify.a;
import com.dtf.face.camera.ICameraCallback;
import com.dtf.face.camera.ICameraInterface;
import com.dtf.face.camera.utils.DisplayUtil;
import com.dtf.face.config.DeviceSetting;

public class CameraSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    public static ICameraInterface mCameraInterface;
    public Context mContext;
    public SurfaceHolder mSurfaceHolder;
    public float mPreviewRate;
    public ICameraCallback mCameraCallback;
    public DeviceSetting mDeviceSetting;

    public CameraSurfaceView(Context context, AttributeSet attributeSet) {
        CameraSurfaceView cameraSurfaceView = this;
        super(context, attributeSet);
        cameraSurfaceView.mContext = context.getApplicationContext();
        cameraSurfaceView.mPreviewRate = DisplayUtil.getScreenRate(cameraSurfaceView.mContext);
        cameraSurfaceView.mSurfaceHolder = cameraSurfaceView.getHolder();
        cameraSurfaceView.mSurfaceHolder.setFormat(-2);
        cameraSurfaceView.mSurfaceHolder.setType(3);
        cameraSurfaceView.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        cameraSurfaceView.setTag(CameraSurfaceView.class.getSimpleName() + ":" + CameraSurfaceView.class);
    }

    public static synchronized ICameraInterface getCameraImpl() {
        if (mCameraInterface == null) {
            mCameraInterface = a.b();
        }
        return mCameraInterface;
    }

    public static String getCameraName() {
        return "Android";
    }

    public void init(Context context, boolean bl, boolean bl2, DeviceSetting[] object) {
        DeviceSetting deviceSetting3;
        DeviceSetting deviceSetting2 = null;
        if (object != null) {
            int n = Integer.parseInt(Build.VERSION.SDK);
            for (DeviceSetting deviceSetting3 : object) {
                if (n < deviceSetting3.getMinApiLevel() || n > deviceSetting3.getMaxApiLevel()) {
                    continue;
                }
                break;
            }
        } else {
            deviceSetting3 = deviceSetting2;
        }
        if (deviceSetting3 == null) {
            DeviceSetting deviceSetting4;
            deviceSetting3 = deviceSetting4;
            deviceSetting4 = new DeviceSetting();
        }
        this.mDeviceSetting = deviceSetting3;
        mCameraInterface = CameraSurfaceView.getCameraImpl();
        object = mCameraInterface;
        if (object != null) {
            object.initCamera(context, bl, bl2, this.mDeviceSetting);
        }
    }

    public void enableTakePhotoFlash(boolean bl) {
        if (bl) {
            mCameraInterface.turnOnTakePhotoFlash();
        } else {
            mCameraInterface.turnOffTakePhotoFlash();
        }
    }

    public void surfaceCreated(SurfaceHolder object) {
        object = mCameraInterface;
        if (object != null) {
            object.setCallback(((CameraSurfaceView)((Object)this)).mCameraCallback);
        }
        if ((object = mCameraInterface) != null) {
            object.startCamera();
        }
        if ((this = ((CameraSurfaceView)((Object)this)).mCameraCallback) != null) {
            this.onSurfaceCreated();
        }
    }

    public void surfaceChanged(SurfaceHolder object, int n, int n2, int n3) {
        object = mCameraInterface;
        if (object != null) {
            object.startPreview(this.mSurfaceHolder, this.mPreviewRate, n2, n3);
            if (this.mCameraCallback != null) {
                int n4 = mCameraInterface.getCameraViewRotation();
                if (n4 != 90 && n4 != 270) {
                    if (n4 == 0 || n4 == 180) {
                        n2 = mCameraInterface.getPreviewWidth();
                        n3 = mCameraInterface.getPreviewHeight();
                    }
                } else {
                    n2 = mCameraInterface.getPreviewHeight();
                    n3 = mCameraInterface.getPreviewWidth();
                }
                this.mCameraCallback.onSurfaceChanged(n2, n3);
            }
        }
    }

    public void surfaceDestroyed(SurfaceHolder object) {
        object = mCameraInterface;
        if (object != null) {
            object.stopCamera();
            mCameraInterface.setCallback(null);
        }
        if ((this = ((CameraSurfaceView)((Object)this)).mCameraCallback) != null) {
            this.onSurfaceDestroyed();
        }
    }

    public SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceHolder;
    }

    public void setCameraCallback(ICameraCallback iCameraCallback) {
        this.mCameraCallback = iCameraCallback;
    }

    public ICameraInterface getCameraInterface() {
        return mCameraInterface;
    }
}

