/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1InputStream;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1OctetString;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.DEROctetString;
import org.eid_bc.bouncycastle.asn1.cms.ContentInfo;
import org.eid_bc.bouncycastle.asn1.cms.SignedData;
import org.eid_bc.bouncycastle.asn1.icao.DataGroupHash;
import org.eid_bc.bouncycastle.asn1.icao.LDSSecurityObject;
import org.eid_bc.bouncycastle.asn1.icao.LDSVersionInfo;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jmrtd.lds.AbstractTaggedLDSFile;
import org.jmrtd.lds.SignedDataUtil;

public class SODFile
extends AbstractTaggedLDSFile {
    public static final long serialVersionUID = -1081347374739311111L;
    public static final String ICAO_LDS_SOD_OID = "2.23.136.1.1.1";
    public static final String ICAO_LDS_SOD_ALT_OID = "1.3.27.1.1.1";
    public static final String SDU_LDS_SOD_OID = "1.2.528.1.1006.1.20.1";
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public transient SignedData signedData;

    public SODFile(String string, String string2, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate) {
        this(string, string2, map, privateKey, x509Certificate, null);
    }

    public SODFile(String string, String string2, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string3) {
        this(string, string2, map, privateKey, x509Certificate, string3, null, null);
    }

    public SODFile(String object, String string, Map<Integer, byte[]> map, PrivateKey privateKey, X509Certificate x509Certificate, String string2, String string3, String string4) {
        SODFile sODFile = sODFile2;
        String string5 = object;
        super(119);
        try {
            SODFile sODFile2 = SODFile.toContentInfo(ICAO_LDS_SOD_OID, (String)object, map, string3, string4);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error creating signedData", iOException);
        }
        object = SignedDataUtil.signData((String)object, string, ICAO_LDS_SOD_OID, (ContentInfo)sODFile2, privateKey, string2);
        sODFile.signedData = SignedDataUtil.createSignedData(string5, string, ICAO_LDS_SOD_OID, (ContentInfo)sODFile2, (byte[])object, x509Certificate);
    }

    public SODFile(String string, String string2, Map<Integer, byte[]> map, byte[] byArray, X509Certificate x509Certificate) {
        super(119);
        try {
            this.signedData = SignedDataUtil.createSignedData(string, string2, ICAO_LDS_SOD_OID, SODFile.toContentInfo(ICAO_LDS_SOD_OID, string, map, null, null), byArray, x509Certificate);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error creating signedData", iOException);
        }
    }

    public SODFile(InputStream inputStream) {
        super(119, inputStream);
    }

    public static String getDigestAlgorithm(LDSSecurityObject lDSSecurityObject) {
        try {
            return SignedDataUtil.lookupMnemonicByOID(lDSSecurityObject.getDigestAlgorithmIdentifier().getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "Exception", noSuchAlgorithmException);
            return null;
        }
    }

    public static ContentInfo toContentInfo(String string, String string2, Map<Integer, byte[]> algorithmIdentifier, String string3, String string4) {
        AlgorithmIdentifier algorithmIdentifier2;
        AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
        DataGroupHash[] dataGroupHashArray = new DataGroupHash[algorithmIdentifier3.size()];
        int n2 = 0;
        Iterator<Map.Entry<Integer, byte[]>> iterator = algorithmIdentifier3.entrySet().iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.next().getKey();
            byte[] byArray = (byte[])algorithmIdentifier.get(n3);
            dataGroupHashArray[n2++] = new DataGroupHash(n3, (ASN1OctetString)new DEROctetString(byArray));
        }
        algorithmIdentifier = algorithmIdentifier2;
        algorithmIdentifier2 = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(string2)));
        if (string3 == null) {
            LDSSecurityObject lDSSecurityObject;
            string2 = lDSSecurityObject;
            lDSSecurityObject = new LDSSecurityObject(algorithmIdentifier, dataGroupHashArray);
        } else {
            LDSSecurityObject lDSSecurityObject;
            string2 = lDSSecurityObject;
            lDSSecurityObject = new LDSSecurityObject(algorithmIdentifier, dataGroupHashArray, new LDSVersionInfo(string3, string4));
        }
        return new ContentInfo(new ASN1ObjectIdentifier(string), (ASN1Encodable)new DEROctetString((ASN1Encodable)string2));
    }

    /*
     * Loose catch block
     */
    public static LDSSecurityObject getLDSSecurityObject(SignedData object) {
        DEROctetString dEROctetString;
        block18: {
            block19: {
                ASN1InputStream aSN1InputStream;
                block17: {
                    ContentInfo contentInfo = object.getEncapContentInfo();
                    ContentInfo contentInfo2 = contentInfo;
                    object = contentInfo.getContentType().getId();
                    {
                        catch (IOException iOException) {
                            throw new IllegalStateException("Could not read security object in signedData", iOException);
                        }
                    }
                    dEROctetString = (DEROctetString)contentInfo2.getContent();
                    if (ICAO_LDS_SOD_OID.equals(object)) break block17;
                    if (SDU_LDS_SOD_OID.equals(object)) break block17;
                    ICAO_LDS_SOD_ALT_OID.equals(object);
                }
                object = aSN1InputStream;
                aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(dEROctetString.getOctets()));
                dEROctetString = aSN1InputStream.readObject();
                if (!(dEROctetString instanceof ASN1Sequence)) break block18;
                Object object2 = object;
                dEROctetString = LDSSecurityObject.getInstance((Object)dEROctetString);
                if (object2.readObject() == null) break block19;
                LOGGER.warning("Ignoring extra object found after LDSSecurityObject...");
            }
            object.close();
            return dEROctetString;
        }
        try {
            throw new IllegalStateException("Expected ASN1Sequence, found " + dEROctetString.getClass().getSimpleName());
        }
        catch (Throwable throwable) {
            object.close();
            throw throwable;
        }
    }

    @Override
    public void readContent(InputStream inputStream) {
        this.signedData = SignedDataUtil.readSignedData(inputStream);
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        SignedDataUtil.writeData(this.signedData, outputStream);
    }

    public Map<Integer, byte[]> getDataGroupHashes() {
        TreeMap<Integer, byte[]> treeMap;
        DataGroupHash[] dataGroupHashArray = SODFile.getLDSSecurityObject(dataGroupHashArray.signedData).getDatagroupHash();
        TreeMap<Integer, byte[]> treeMap2 = treeMap;
        treeMap = new TreeMap<Integer, byte[]>();
        for (DataGroupHash dataGroupHash : dataGroupHashArray) {
            Object object = dataGroupHash;
            object = object.getDataGroupHashValue().getOctets();
            treeMap2.put(dataGroupHash.getDataGroupNumber(), (byte[])object);
        }
        return treeMap2;
    }

    public byte[] getEncryptedDigest() {
        return SignedDataUtil.getEncryptedDigest(this.signedData);
    }

    public AlgorithmParameterSpec getDigestEncryptionAlgorithmParams() {
        return SignedDataUtil.getDigestEncryptionAlgorithmParams(this.signedData);
    }

    public byte[] getEContent() {
        return SignedDataUtil.getEContent(this.signedData);
    }

    public String getDigestAlgorithm() {
        return SODFile.getDigestAlgorithm(SODFile.getLDSSecurityObject(this.signedData));
    }

    public String getSignerInfoDigestAlgorithm() {
        return SignedDataUtil.getSignerInfoDigestAlgorithm(this.signedData);
    }

    public String getDigestEncryptionAlgorithm() {
        return SignedDataUtil.getDigestEncryptionAlgorithm(this.signedData);
    }

    public String getLDSVersion() {
        SODFile sODFile = SODFile.getLDSSecurityObject(sODFile.signedData).getVersionInfo();
        return sODFile == null ? null : sODFile.getLdsVersion();
    }

    public String getUnicodeVersion() {
        SODFile sODFile = SODFile.getLDSSecurityObject(sODFile.signedData).getVersionInfo();
        return sODFile == null ? null : sODFile.getUnicodeVersion();
    }

    public X509Certificate getDocSigningCertificate() {
        return SignedDataUtil.getDocSigningCertificate(this.signedData);
    }

    public X500Principal getIssuerX500Principal() {
        try {
            SODFile sODFile = SignedDataUtil.getIssuerAndSerialNumber(sODFile.signedData).getName();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Could not get issuer", iOException);
            return null;
        }
        return new X500Principal(sODFile.getEncoded("DER"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == sODFile2) {
            return true;
        }
        if (!object.getClass().equals(SODFile.class)) {
            return false;
        }
        SODFile sODFile = sODFile2;
        SODFile sODFile2 = (SODFile)object;
        return Arrays.equals(sODFile.getEncoded(), sODFile2.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded()) * 11 + 111;
    }
}

