/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.AbstractListInfo;
import org.jmrtd.lds.iso19794.IrisBiometricSubtypeInfo;

public class IrisInfo
extends AbstractListInfo<IrisBiometricSubtypeInfo>
implements BiometricDataBlock {
    public static final long serialVersionUID = -3415309711643815511L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int FORMAT_IDENTIFIER = 1229541888;
    public static final int VERSION_NUMBER = 0x30313000;
    public static final int FORMAT_OWNER_VALUE = 257;
    public static final int FORMAT_TYPE_VALUE = 9;
    public static final int IMAGEFORMAT_MONO_RAW = 2;
    public static final int IMAGEFORMAT_RGB_RAW = 4;
    public static final int IMAGEFORMAT_MONO_JPEG = 6;
    public static final int IMAGEFORMAT_RGB_JPEG = 8;
    public static final int IMAGEFORMAT_MONO_JPEG_LS = 10;
    public static final int IMAGEFORMAT_RGB_JPEG_LS = 12;
    public static final int IMAGEFORMAT_MONO_JPEG2000 = 14;
    public static final int IMAGEFORMAT_RGB_JPEG2000 = 16;
    public static final int CAPTURE_DEVICE_UNDEF = 0;
    public static final int ORIENTATION_UNDEF = 0;
    public static final int ORIENTATION_BASE = 1;
    public static final int ORIENTATION_FLIPPED = 2;
    public static final int SCAN_TYPE_UNDEF = 0;
    public static final int SCAN_TYPE_PROGRESSIVE = 1;
    public static final int SCAN_TYPE_INTERLACE_FRAME = 2;
    public static final int SCAN_TYPE_INTERLACE_FIELD = 3;
    public static final int SCAN_TYPE_CORRECTED = 4;
    public static final int IROCC_UNDEF = 0;
    public static final int IROCC_PROCESSED = 1;
    public static final int IROCC_ZEROFILL = 0;
    public static final int IROC_UNITFILL = 1;
    public static final int INTENSITY_DEPTH_UNDEF = 0;
    public static final int TRANS_UNDEF = 0;
    public static final int TRANS_STD = 1;
    public static final int IRBNDY_UNDEF = 0;
    public static final int IRBNDY_PROCESSED = 1;
    public long recordLength;
    public int captureDeviceId;
    public int horizontalOrientation;
    public int verticalOrientation;
    public int scanType;
    public int irisOcclusion;
    public int occlusionFilling;
    public int boundaryExtraction;
    public int irisDiameter;
    public int imageFormat;
    public int rawImageWidth;
    public int rawImageHeight;
    public int intensityDepth;
    public int imageTransformation;
    public byte[] deviceUniqueId;
    public StandardBiometricHeader sbh;

    public IrisInfo(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, byte[] byArray, List<IrisBiometricSubtypeInfo> list) {
        this(null, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, byArray, list);
    }

    public IrisInfo(StandardBiometricHeader standardBiometricHeader, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, byte[] byArray, List<IrisBiometricSubtypeInfo> list) {
        ((IrisInfo)object).sbh = standardBiometricHeader;
        if (list != null) {
            ((IrisInfo)object).captureDeviceId = n2;
            ((IrisInfo)object).horizontalOrientation = n3;
            ((IrisInfo)object).verticalOrientation = n4;
            ((IrisInfo)object).scanType = n5;
            ((IrisInfo)object).irisOcclusion = n6;
            ((IrisInfo)object).occlusionFilling = n7;
            ((IrisInfo)object).boundaryExtraction = n8;
            ((IrisInfo)object).irisDiameter = n9;
            ((IrisInfo)object).imageFormat = n10;
            ((IrisInfo)object).rawImageWidth = n11;
            ((IrisInfo)object).rawImageHeight = n12;
            ((IrisInfo)object).intensityDepth = n13;
            ((IrisInfo)object).imageTransformation = n14;
            long l2 = 45L;
            long l3 = 0L;
            for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : list) {
                l3 += irisBiometricSubtypeInfo.getRecordLength();
                ((AbstractListInfo)object).add(irisBiometricSubtypeInfo);
            }
            if (byArray != null && byArray.length == 16) {
                IrisInfo irisInfo = object;
                ((IrisInfo)object).deviceUniqueId = new byte[16];
                Object object = ((IrisInfo)object).deviceUniqueId;
                int n15 = byArray.length;
                System.arraycopy(byArray, 0, object, 0, n15);
                irisInfo.recordLength = l3 + l2;
                return;
            }
            throw new IllegalArgumentException("deviceUniqueId invalid");
        }
        throw new IllegalArgumentException("Null irisBiometricSubtypeInfos");
    }

    public IrisInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public IrisInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        this.sbh = standardBiometricHeader;
        this.readObject(inputStream);
    }

    private int getBiometricSubtype() {
        int n2 = 0;
        Iterator iterator = this.getSubRecords().iterator();
        while (iterator.hasNext()) {
            n2 &= ((IrisBiometricSubtypeInfo)iterator.next()).getBiometricSubtype();
        }
        return n2;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n2 = dataInputStream.readInt();
        if (n2 == 1229541888) {
            n2 = dataInputStream.readInt();
            if (n2 == 0x30313000) {
                DataInputStream dataInputStream3 = dataInputStream;
                this.recordLength = dataInputStream.readInt();
                long l2 = 45L;
                long l3 = this.recordLength - l2;
                this.captureDeviceId = dataInputStream.readUnsignedShort();
                int n3 = dataInputStream3.readUnsignedByte();
                int n4 = dataInputStream3.readUnsignedShort();
                if ((long)n4 == l2) {
                    int n5 = dataInputStream.readUnsignedShort();
                    this.horizontalOrientation = n5 & 3;
                    this.verticalOrientation = (n5 & 0xC) >> 2;
                    this.scanType = (n5 & 0x70) >> 4;
                    this.irisOcclusion = (n5 & 0x80) >> 7;
                    this.occlusionFilling = (n5 & 0x100) >> 8;
                    this.boundaryExtraction = (n5 & 0x200) >> 9;
                    this.irisDiameter = dataInputStream.readUnsignedShort();
                    this.imageFormat = dataInputStream.readUnsignedShort();
                    this.rawImageWidth = dataInputStream.readUnsignedShort();
                    this.rawImageHeight = dataInputStream.readUnsignedShort();
                    this.intensityDepth = dataInputStream.readUnsignedByte();
                    this.imageTransformation = dataInputStream.readUnsignedByte();
                    this.deviceUniqueId = new byte[16];
                    dataInputStream.readFully(this.deviceUniqueId);
                    long l4 = 0L;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo;
                        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo2;
                        IrisBiometricSubtypeInfo irisBiometricSubtypeInfo3 = irisBiometricSubtypeInfo2 = irisBiometricSubtypeInfo;
                        irisBiometricSubtypeInfo3(inputStream, this.imageFormat);
                        l4 += irisBiometricSubtypeInfo3.getRecordLength();
                        this.add(irisBiometricSubtypeInfo);
                    }
                    if (l3 != l4) {
                        LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l3 + ", constructedDataLength = " + l4);
                    }
                    return;
                }
                throw new IllegalArgumentException("Expected header length " + l2 + ", found " + n4);
            }
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(n2));
        }
        throw new IllegalArgumentException("'IIR' marker expected! Found " + Integer.toHexString(n2));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        Object object;
        int n2 = 45;
        int n3 = 0;
        List list = ((AbstractListInfo)((Object)iterator)).getSubRecords();
        for (IrisBiometricSubtypeInfo irisBiometricSubtypeInfo : list) {
            n3 = (int)((long)n3 + irisBiometricSubtypeInfo.getRecordLength());
        }
        n3 = n2 + n3;
        if (outputStream instanceof DataOutputStream) {
            object = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            object = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
        }
        Object object2 = object;
        ((DataOutputStream)object2).writeInt(1229541888);
        ((DataOutputStream)object2).writeInt(0x30313000);
        ((DataOutputStream)object).writeInt(n3);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).captureDeviceId);
        ((DataOutputStream)object).writeByte(list.size());
        ((DataOutputStream)object).writeShort(n2);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).horizontalOrientation & 3 | 0 | ((IrisInfo)((Object)iterator)).verticalOrientation << 2 & 0xC | ((IrisInfo)((Object)iterator)).scanType << 4 & 0x70 | ((IrisInfo)((Object)iterator)).irisOcclusion << 7 & 0x80 | ((IrisInfo)((Object)iterator)).occlusionFilling << 8 & 0x100 | ((IrisInfo)((Object)iterator)).boundaryExtraction << 9 & 0x200);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).irisDiameter);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).imageFormat);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).rawImageWidth);
        ((DataOutputStream)object).writeShort(((IrisInfo)((Object)iterator)).rawImageHeight);
        ((DataOutputStream)object).writeByte(((IrisInfo)((Object)iterator)).intensityDepth);
        ((DataOutputStream)object).writeByte(((IrisInfo)((Object)iterator)).imageTransformation);
        ((FilterOutputStream)object).write(((IrisInfo)((Object)iterator)).deviceUniqueId);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IrisBiometricSubtypeInfo)iterator.next()).writeObject(outputStream);
        }
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getHorizontalOrientation() {
        return this.horizontalOrientation;
    }

    public int getVerticalOrientation() {
        return this.verticalOrientation;
    }

    public int getScanType() {
        return this.scanType;
    }

    public int getIrisOcclusion() {
        return this.irisOcclusion;
    }

    public int getOcclusionFilling() {
        return this.occlusionFilling;
    }

    public int getBoundaryExtraction() {
        return this.boundaryExtraction;
    }

    public int getIrisDiameter() {
        return this.irisDiameter;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public int getRawImageWidth() {
        return this.rawImageWidth;
    }

    public int getRawImageHeight() {
        return this.rawImageHeight;
    }

    public int getIntensityDepth() {
        return this.intensityDepth;
    }

    public int getImageTransformation() {
        return this.imageTransformation;
    }

    public byte[] getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 8;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = (byte)this.getBiometricSubtype();
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 9;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    @Override
    public int hashCode() {
        IrisInfo irisInfo = this;
        long l2 = this.recordLength;
        int n2 = (((((((((((((super.hashCode() * 31 + this.boundaryExtraction) * 31 + this.captureDeviceId) * 31 + Arrays.hashCode(this.deviceUniqueId)) * 31 + this.horizontalOrientation) * 31 + this.imageFormat) * 31 + this.imageTransformation) * 31 + this.intensityDepth) * 31 + this.irisDiameter) * 31 + this.irisOcclusion) * 31 + this.occlusionFilling) * 31 + this.rawImageHeight) * 31 + this.rawImageWidth) * 31 + (int)(l2 ^ l2 >>> 32)) * 31;
        StandardBiometricHeader standardBiometricHeader = irisInfo.sbh;
        int n3 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return ((n2 + n3) * 31 + this.scanType) * 31 + this.verticalOrientation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (IrisInfo.class != object.getClass()) {
            return false;
        }
        object = (IrisInfo)object;
        StandardBiometricHeader standardBiometricHeader = this.sbh;
        if (standardBiometricHeader == null ? ((IrisInfo)object).sbh != null : !standardBiometricHeader.equals(((IrisInfo)object).sbh)) {
            return false;
        }
        if (this.boundaryExtraction != ((IrisInfo)object).boundaryExtraction) return false;
        if (this.captureDeviceId == ((IrisInfo)object).captureDeviceId && Arrays.equals(this.deviceUniqueId, ((IrisInfo)object).deviceUniqueId) && this.horizontalOrientation == ((IrisInfo)object).horizontalOrientation && this.imageFormat == ((IrisInfo)object).imageFormat && this.imageTransformation == ((IrisInfo)object).imageTransformation && this.intensityDepth == ((IrisInfo)object).intensityDepth && this.irisDiameter == ((IrisInfo)object).irisDiameter && this.irisOcclusion == ((IrisInfo)object).irisOcclusion && this.occlusionFilling == ((IrisInfo)object).occlusionFilling && this.rawImageHeight == ((IrisInfo)object).rawImageHeight && this.rawImageWidth == ((IrisInfo)object).rawImageWidth && this.recordLength == ((IrisInfo)object).recordLength && this.scanType == ((IrisInfo)object).scanType) {
            if (this.verticalOrientation == ((IrisInfo)object).verticalOrientation) return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("IrisInfo [");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public List<IrisBiometricSubtypeInfo> getIrisBiometricSubtypeInfos() {
        return this.getSubRecords();
    }

    public void addIrisBiometricSubtypeInfo(IrisBiometricSubtypeInfo irisBiometricSubtypeInfo) {
        this.add(irisBiometricSubtypeInfo);
    }

    public void removeIrisBiometricSubtypeInfo(int n2) {
        this.remove(n2);
    }
}

