/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import org.jmrtd.Util;

public class PACEGMWithECDHAgreement {
    public ECPrivateKey privateKey;

    public void init(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            this.privateKey = (ECPrivateKey)privateKey;
            return;
        }
        throw new InvalidKeyException("Not an ECPrivateKey");
    }

    public ECPoint doPhase(PublicKey publicKey) {
        if (pACEGMWithECDHAgreement.privateKey != null) {
            if (publicKey instanceof ECPublicKey) {
                PACEGMWithECDHAgreement pACEGMWithECDHAgreement = Util.toBouncyECPublicKeyParameters((ECPublicKey)publicKey).getQ().multiply(Util.toBouncyECPrivateKeyParameters(pACEGMWithECDHAgreement.privateKey).getD()).normalize();
                if (!pACEGMWithECDHAgreement.isInfinity()) {
                    return Util.fromBouncyCastleECPoint((org.eid_bc.bouncycastle.math.ec.ECPoint)pACEGMWithECDHAgreement);
                }
                throw new IllegalStateException("Infinity");
            }
            throw new InvalidKeyException("Not an ECPublicKey");
        }
        throw new IllegalStateException("Not initialized!");
    }
}

