/*
 * Decompiled with CFR 0.152.
 */
package net.sf.scuba.smartcards;

import java.util.EventObject;
import net.sf.scuba.smartcards.CardService;

public class CardEvent
extends EventObject {
    private static final long serialVersionUID = -5645277246646615351L;
    public static final int REMOVED = 0;
    public static final int INSERTED = 1;
    private int type;
    private transient CardService service;

    public CardEvent(int type, CardService service) {
        super(service);
        this.type = type;
        this.service = service;
    }

    public int getType() {
        return this.type;
    }

    public CardService getService() {
        return this.service;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 0: {
                return "Card removed from " + this.service;
            }
            case 1: {
                return "Card inserted in " + this.service;
            }
        }
        throw new IllegalStateException("Unknown event type " + this.type);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        CardEvent otherCardEvent = (CardEvent)other;
        return this.type == otherCardEvent.type && this.service.equals(otherCardEvent.service);
    }

    public int hashCode() {
        return 5 * this.service.hashCode() + 7 * this.type;
    }
}

