/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import net.sf.scuba.smartcards.CardServiceException;
import net.sf.scuba.tlv.TLVUtil;
import org.eid_bc.bouncycastle.jce.interfaces.ECPublicKey;
import org.jmrtd.APDULevelEACCACapable;
import org.jmrtd.Util;
import org.jmrtd.lds.ChipAuthenticationInfo;
import org.jmrtd.lds.SecurityInfo;
import org.jmrtd.protocol.AESSecureMessagingWrapper;
import org.jmrtd.protocol.DESedeSecureMessagingWrapper;
import org.jmrtd.protocol.EACCAResult;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class EACCAProtocol {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final Provider BC_PROVIDER = Util.getBouncyCastleProvider();
    public APDULevelEACCACapable service;
    public SecureMessagingWrapper wrapper;
    public int maxTranceiveLength;
    public boolean shouldCheckMAC;

    public EACCAProtocol(APDULevelEACCACapable aPDULevelEACCACapable, SecureMessagingWrapper secureMessagingWrapper, int n2, boolean bl) {
        this.service = aPDULevelEACCACapable;
        this.wrapper = secureMessagingWrapper;
        this.maxTranceiveLength = n2;
        this.shouldCheckMAC = bl;
    }

    public static void sendPublicKey(APDULevelEACCACapable aPDULevelEACCACapable, SecureMessagingWrapper secureMessagingWrapper, String object, BigInteger bigInteger, PublicKey object2) {
        String string;
        block6: {
            block5: {
                block4: {
                    String string2 = object;
                    String string3 = ChipAuthenticationInfo.toKeyAgreementAlgorithm(string2);
                    string = ChipAuthenticationInfo.toCipherAlgorithm(string2);
                    object2 = EACCAProtocol.getKeyData(string3, (PublicKey)object2);
                    if (!string.startsWith("DESede")) break block4;
                    object = null;
                    if (bigInteger != null) {
                        object = TLVUtil.wrapDO((int)132, (byte[])bigInteger.toByteArray());
                    }
                    aPDULevelEACCACapable.sendMSEKAT(secureMessagingWrapper, TLVUtil.wrapDO((int)145, (byte[])object2), (byte[])object);
                    break block5;
                }
                if (!string.startsWith("AES")) break block6;
                aPDULevelEACCACapable.sendMSESetATIntAuth(secureMessagingWrapper, (String)object, bigInteger);
                aPDULevelEACCACapable.sendGeneralAuthenticate(secureMessagingWrapper, TLVUtil.wrapDO((int)128, (byte[])object2), true);
            }
            return;
        }
        throw new IllegalStateException("Cannot set up secure channel with cipher " + string);
    }

    public static byte[] computeSharedSecret(String string, PublicKey publicKey, PrivateKey privateKey) {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(string, BC_PROVIDER);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    public static SecureMessagingWrapper restartSecureMessaging(String string, byte[] object, int n2, boolean bl) {
        String string2 = ChipAuthenticationInfo.toCipherAlgorithm(string);
        int n3 = ChipAuthenticationInfo.toKeyLength(string);
        SecretKey secretKey = Util.deriveKey(object, string2, n3, 1);
        object = Util.deriveKey(object, string2, n3, 2);
        if (string2.startsWith("DESede")) {
            return new DESedeSecureMessagingWrapper(secretKey, (SecretKey)object, n2, bl, 0L);
        }
        if (string2.startsWith("AES")) {
            return new AESSecureMessagingWrapper(secretKey, (SecretKey)object, n2, bl, 0L);
        }
        throw new IllegalStateException("Unsupported cipher algorithm " + string2);
    }

    public static byte[] getKeyHash(String string, PublicKey publicKey) {
        if ("DH".equals(string)) {
            return MessageDigest.getInstance("SHA-1").digest(EACCAProtocol.getKeyData(string, publicKey));
        }
        if ("ECDH".equals(string)) {
            string = (ECPublicKey)publicKey;
            return Util.alignKeyDataToSize(Util.i2os(string.getQ().getAffineXCoord().toBigInteger()), (int)Math.ceil((double)string.getParameters().getCurve().getFieldSize() / 8.0));
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + string);
    }

    public static byte[] getKeyData(String string, PublicKey publicKey) {
        if ("DH".equals(string)) {
            return ((DHPublicKey)publicKey).getY().toByteArray();
        }
        if ("ECDH".equals(string)) {
            return ((ECPublicKey)publicKey).getQ().getEncoded(false);
        }
        throw new IllegalArgumentException("Unsupported agreement algorithm " + string);
    }

    public static String inferChipAuthenticationOIDfromPublicKeyOID(String string) {
        if (SecurityInfo.ID_PK_ECDH.equals(string)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-ECDH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_ECDH_3DES_CBC_CBC;
        }
        if (SecurityInfo.ID_PK_DH.equals(string)) {
            LOGGER.warning("Could not determine ChipAuthentication algorithm, defaulting to id-CA-DH-3DES-CBC-CBC");
            return SecurityInfo.ID_CA_DH_3DES_CBC_CBC;
        }
        LOGGER.warning("No ChipAuthenticationInfo and unsupported ChipAuthenticationPublicKeyInfo public key OID " + string);
        return null;
    }

    public EACCAResult doCA(BigInteger bigInteger, String object, String object2, PublicKey publicKey) {
        if (publicKey != null) {
            String string = ChipAuthenticationInfo.toKeyAgreementAlgorithm((String)object);
            if (string != null) {
                block14: {
                    block13: {
                        if (!"ECDH".equals(string) && !"DH".equals(string)) {
                            throw new IllegalArgumentException("Unsupported agreement algorithm, expected ECDH or DH, found " + string);
                        }
                        if (object == null) {
                            object = EACCAProtocol.inferChipAuthenticationOIDfromPublicKeyOID((String)object2);
                        }
                        object2 = null;
                        try {
                            if (!"DH".equals(string)) break block13;
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CardServiceException("Security exception during Chip Authentication", (Throwable)generalSecurityException);
                        }
                        object2 = ((DHPublicKey)publicKey).getParams();
                    }
                    if (!"ECDH".equals(string)) break block14;
                    object2 = ((java.security.interfaces.ECPublicKey)publicKey).getParams();
                }
                EACCAProtocol eACCAProtocol = this;
                String string2 = object;
                String string3 = string;
                PublicKey publicKey2 = publicKey;
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string, BC_PROVIDER);
                keyPairGenerator.initialize((AlgorithmParameterSpec)object2);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyPair keyPair2 = keyPair;
                object2 = keyPair.getPublic();
                PrivateKey privateKey = keyPair2.getPrivate();
                EACCAProtocol.sendPublicKey(this.service, this.wrapper, (String)object, bigInteger, (PublicKey)object2);
                object = EACCAProtocol.getKeyHash(string, (PublicKey)object2);
                eACCAProtocol.wrapper = EACCAProtocol.restartSecureMessaging(string2, EACCAProtocol.computeSharedSecret(string3, publicKey2, privateKey), this.maxTranceiveLength, this.shouldCheckMAC);
                return new EACCAResult(bigInteger, publicKey, (byte[])object, (PublicKey)object2, privateKey, this.wrapper);
            }
            throw new IllegalArgumentException("Unknown agreement algorithm");
        }
        throw new IllegalArgumentException("PICC public key is null");
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }
}

