/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.gaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IGAID;
import net.security.device.api.id.IGAIDGetter;

public class GAIDImpl
implements IGAID {
    private final Context context;

    public GAIDImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportGAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.google.android.gms", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IGAIDGetter getter) {
        if (this.context == null) {
            getter.onGAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("com.google.android.gms Service connected");
                    try {
                        Parcel data = Parcel.obtain();
                        Parcel reply = Parcel.obtain();
                        try {
                            String gaid = null;
                            data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                            if (service.transact(1, data, reply, 0)) {
                                reply.readException();
                                gaid = reply.readString();
                            }
                            if (gaid == null || gaid.length() == 0) {
                                throw new RuntimeException("Get gaid failed");
                            }
                            getter.onGAIDGetComplete(gaid);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            data.recycle();
                            reply.recycle();
                            GAIDImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onGAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.d("com.google.android.gms Service disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("com.google.android.gms Service bind failed");
            }
        }
        catch (Exception e) {
            getter.onGAIDGetError(e);
        }
    }
}

