/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import java.util.Objects;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;
import net.security.device.api.id.SystemUtils;

public class VivoImpl
implements IOAID {
    private final Context context;

    public VivoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        return SystemUtils.sysProperty("persist.sys.identifierid.supported", "0").equals("1");
    }

    @Override
    public void doGet(IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            getter.onOAIDGetError(new RuntimeException("OAID unsupported system"));
            return;
        }
        try {
            Cursor cursor;
            ContentResolver cr;
            String oaid = null;
            Uri uri = Uri.parse((String)"content://com.vivo.vms.IdProvider/IdentifierId/OAID");
            if (uri != null && (cr = this.context.getContentResolver()) != null && (cursor = cr.query(uri, null, null, null, null)) != null) {
                Objects.requireNonNull(cursor).moveToFirst();
                oaid = cursor.getString(cursor.getColumnIndex("value"));
            }
            if (oaid == null || oaid.length() <= 0) {
                throw new RuntimeException("OAID query failed");
            }
            LogUtil.d("oaid from provider: " + uri);
            getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
            getter.onOAIDGetError(e);
        }
    }
}

