/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cert;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CertificateGenerator;
import org.ejbca.cvc.HolderReferenceField;
import org.jmrtd.cert.CVCAuthorizationTemplate;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;

public class CVCertificateBuilder {
    public static CardVerifiableCertificate createCertificate(PublicKey publicKey, PrivateKey privateKey, String string, CVCPrincipal cVCPrincipal, CVCPrincipal cVCPrincipal2, CVCAuthorizationTemplate cVCAuthorizationTemplate, Date date, Date date2, String string2) {
        return new CardVerifiableCertificate(CertificateGenerator.createCertificate(publicKey, privateKey, string, new CAReferenceField(cVCPrincipal.getCountry().toAlpha2Code(), cVCPrincipal.getMnemonic(), cVCPrincipal.getSeqNumber()), new HolderReferenceField(cVCPrincipal2.getCountry().toAlpha2Code(), cVCPrincipal2.getMnemonic(), cVCPrincipal2.getSeqNumber()), CVCertificateBuilder.getRole(cVCAuthorizationTemplate.getRole()), CVCertificateBuilder.getAccessRight(cVCAuthorizationTemplate.getAccessRight()), date, date2, string2));
    }

    public static AuthorizationRoleEnum getRole(CVCAuthorizationTemplate.Role role) {
        switch (role.ordinal()) {
            default: {
                throw new NumberFormatException("Cannot decode role " + (Object)((Object)role));
            }
            case 4: {
                return AuthorizationRoleEnum.IS;
            }
            case 3: {
                return AuthorizationRoleEnum.DV_F;
            }
            case 2: {
                return AuthorizationRoleEnum.DV_D;
            }
            case 1: 
        }
        return AuthorizationRoleEnum.CVCA;
    }

    public static AccessRightEnum getAccessRight(CVCAuthorizationTemplate.Permission permission) {
        switch (permission.ordinal()) {
            default: {
                throw new NumberFormatException("Cannot decode access right " + (Object)((Object)permission));
            }
            case 4: {
                return AccessRightEnum.READ_ACCESS_DG3_AND_DG4;
            }
            case 3: {
                return AccessRightEnum.READ_ACCESS_DG4;
            }
            case 2: {
                return AccessRightEnum.READ_ACCESS_DG3;
            }
            case 1: 
        }
        return AccessRightEnum.READ_ACCESS_NONE;
    }
}

