/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jmrtd.cbeff.BiometricDataBlockDecoder;
import org.jmrtd.cbeff.BiometricDataBlockEncoder;
import org.jmrtd.cbeff.CBEFFInfo;
import org.jmrtd.cbeff.ComplexCBEFFInfo;
import org.jmrtd.cbeff.ISO781611Decoder;
import org.jmrtd.cbeff.ISO781611Encoder;
import org.jmrtd.cbeff.SimpleCBEFFInfo;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.CBEFFDataGroup;
import org.jmrtd.lds.iso19794.IrisInfo;

public class DG4File
extends CBEFFDataGroup<IrisInfo> {
    public static final long serialVersionUID = -1290365855823447586L;
    public static final ISO781611Decoder DECODER = new ISO781611Decoder(new BiometricDataBlockDecoder<IrisInfo>(){

        @Override
        public IrisInfo decode(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n2, int n3) {
            return new IrisInfo(standardBiometricHeader, inputStream);
        }
    });
    public static final ISO781611Encoder<IrisInfo> ENCODER = new ISO781611Encoder<IrisInfo>(new BiometricDataBlockEncoder<IrisInfo>(){

        @Override
        public void encode(IrisInfo irisInfo, OutputStream outputStream) {
            irisInfo.writeObject(outputStream);
        }
    });
    public boolean shouldAddRandomDataIfEmpty;

    public DG4File(List<IrisInfo> list) {
        this(list, true);
    }

    public DG4File(List<IrisInfo> list, boolean bl) {
        super(118, list);
        this.shouldAddRandomDataIfEmpty = bl;
    }

    public DG4File(InputStream inputStream) {
        super(118, inputStream);
    }

    @Override
    public void readContent(InputStream object) {
        for (CBEFFInfo cBEFFInfo : DECODER.decode((InputStream)object).getSubRecords()) {
            if (cBEFFInfo instanceof SimpleCBEFFInfo) {
                if ((cBEFFInfo = ((SimpleCBEFFInfo)cBEFFInfo).getBiometricDataBlock()) instanceof IrisInfo) {
                    this.add((IrisInfo)((Object)cBEFFInfo));
                    continue;
                }
                throw new IOException("Was expecting an IrisInfo, found " + cBEFFInfo.getClass().getSimpleName());
            }
            throw new IOException("Was expecting a SimpleCBEFFInfo, found " + cBEFFInfo.getClass().getSimpleName());
        }
    }

    @Override
    public void writeContent(OutputStream outputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        for (IrisInfo irisInfo : this.getSubRecords()) {
            complexCBEFFInfo2.add(new SimpleCBEFFInfo<IrisInfo>(irisInfo));
        }
        ENCODER.encode(complexCBEFFInfo2, outputStream);
        if (this.shouldAddRandomDataIfEmpty) {
            this.writeOptionalRandomData(outputStream);
        }
    }

    @Override
    public String toString() {
        return "DG4File [" + super.toString() + "]";
    }

    public List<IrisInfo> getIrisInfos() {
        return this.getSubRecords();
    }

    public void addIrisInfo(IrisInfo irisInfo) {
        this.add(irisInfo);
    }

    public void removeIrisInfo(int n2) {
        this.remove(n2);
    }

    @Override
    public int hashCode() {
        DG4File dG4File = this;
        int n2 = super.hashCode() * 31;
        int n3 = dG4File.shouldAddRandomDataIfEmpty ? 1231 : 1237;
        return n2 + n3;
    }

    @Override
    public boolean equals(Object object) {
        if (dG4File2 == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (DG4File.class != object.getClass()) {
            return false;
        }
        DG4File dG4File = dG4File2;
        DG4File dG4File2 = (DG4File)object;
        return dG4File.shouldAddRandomDataIfEmpty == dG4File2.shouldAddRandomDataIfEmpty;
    }
}

