/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.cbeff.StandardBiometricHeader;
import org.jmrtd.lds.AbstractListInfo;
import org.jmrtd.lds.iso19794.FingerImageInfo;

public class FingerInfo
extends AbstractListInfo<FingerImageInfo>
implements BiometricDataBlock {
    public static final long serialVersionUID = 5808625058034008176L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final int FORMAT_IDENTIFIER = 1179210240;
    public static final int VERSION_NUMBER = 0x30313000;
    public static final int FORMAT_OWNER_VALUE = 257;
    public static final int FORMAT_TYPE_VALUE = 7;
    public static final int SCALE_UNITS_PPI = 1;
    public static final int SCALE_UNITS_PPCM = 2;
    public static final int COMPRESSION_UNCOMPRESSED_NO_BIT_PACKING = 0;
    public static final int COMPRESSION_UNCOMPRESSED_BIT_PACKED = 1;
    public static final int COMPRESSION_WSQ = 2;
    public static final int COMPRESSION_JPEG = 3;
    public static final int COMPRESSION_JPEG2000 = 4;
    public static final int COMPRESSION_PNG = 5;
    public int captureDeviceId;
    public int acquisitionLevel;
    public int scaleUnits;
    public int scanResolutionHorizontal;
    public int scanResolutionVertical;
    public int imageResolutionHorizontal;
    public int imageResolutionVertical;
    public int depth;
    public int compressionAlgorithm;
    public StandardBiometricHeader sbh;

    public FingerInfo(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, List<FingerImageInfo> list) {
        this(null, n2, n3, n4, n5, n6, n7, n8, n9, n10, list);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, List<FingerImageInfo> list) {
        this.sbh = standardBiometricHeader;
        this.captureDeviceId = n2;
        this.acquisitionLevel = n3;
        this.scaleUnits = n4;
        this.scanResolutionHorizontal = n5;
        this.scanResolutionVertical = n6;
        this.imageResolutionHorizontal = n7;
        this.imageResolutionVertical = n8;
        this.depth = n9;
        this.compressionAlgorithm = n10;
        this.addAll(list);
    }

    public FingerInfo(InputStream inputStream) {
        this(null, inputStream);
    }

    public FingerInfo(StandardBiometricHeader standardBiometricHeader, InputStream inputStream) {
        this.sbh = standardBiometricHeader;
        this.readObject(inputStream);
    }

    public static long readUnsignedLong(InputStream object, int n2) {
        InputStream inputStream;
        if (object instanceof DataInputStream) {
            object = (DataInputStream)object;
            inputStream = object;
        } else {
            DataInputStream dataInputStream;
            inputStream = dataInputStream;
            dataInputStream = new DataInputStream((InputStream)object);
        }
        byte[] byArray = new byte[n2];
        object = byArray;
        ((DataInputStream)inputStream).readFully(byArray);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = (l2 << 8) + (long)(object[i2] & 0xFF);
        }
        return l2;
    }

    public static void writeLong(long l2, OutputStream outputStream, int n2) {
        if (n2 > 0) {
            int n3;
            for (n3 = 0; n3 < n2 - 8; ++n3) {
                outputStream.write(0);
            }
            if (n2 > 8) {
                n2 = 8;
            }
            --n2;
            while (n2 >= 0) {
                n3 = n2 * 8;
                outputStream.write((byte)((l2 & 255L << n3) >> n3));
                --n2;
            }
        }
    }

    public static String toMimeType(int n2) {
        switch (n2) {
            default: {
                return null;
            }
            case 5: {
                return "image/png";
            }
            case 4: {
                return "image/jpeg2000";
            }
            case 3: {
                return "image/jpeg";
            }
            case 2: {
                return "image/x-wsq";
            }
            case 1: {
                return "image/raw";
            }
            case 0: 
        }
        return "image/raw";
    }

    public static int fromMimeType(String string) {
        if ("image/x-wsq".equals(string)) {
            return 2;
        }
        if ("image/jpeg".equals(string)) {
            return 3;
        }
        if ("image/jpeg2000".equals(string)) {
            return 4;
        }
        if ("images/png".equals(string)) {
            return 5;
        }
        throw new IllegalArgumentException("Did not recognize mimeType");
    }

    private int getBiometricSubtype() {
        int n2 = 0;
        boolean bl = true;
        Iterator iterator = this.getSubRecords().iterator();
        while (iterator.hasNext()) {
            int n3 = ((FingerImageInfo)iterator.next()).getBiometricSubtype();
            if (bl) {
                bl = false;
            } else {
                n3 = n2 & n3;
            }
            n2 = n3;
        }
        return n2;
    }

    public int getCaptureDeviceId() {
        return this.captureDeviceId;
    }

    public int getAcquisitionLevel() {
        return this.acquisitionLevel;
    }

    public int getScaleUnits() {
        return this.scaleUnits;
    }

    public int getHorizontalScanningResolution() {
        return this.scanResolutionHorizontal;
    }

    public int getVerticalScanningResolution() {
        return this.scanResolutionVertical;
    }

    public int getHorizontalImageResolution() {
        return this.imageResolutionHorizontal;
    }

    public int getVerticalImageResolution() {
        return this.imageResolutionVertical;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        int n2 = dataInputStream.readInt();
        if (n2 == 1179210240) {
            n2 = dataInputStream.readInt();
            if (n2 == 0x30313000) {
                long l2 = FingerInfo.readUnsignedLong(dataInputStream, 6);
                DataInputStream dataInputStream3 = dataInputStream;
                this.captureDeviceId = dataInputStream.readUnsignedShort();
                this.acquisitionLevel = dataInputStream.readUnsignedShort();
                int n3 = dataInputStream3.readUnsignedByte();
                this.scaleUnits = dataInputStream3.readUnsignedByte();
                this.scanResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.scanResolutionVertical = dataInputStream.readUnsignedShort();
                this.imageResolutionHorizontal = dataInputStream.readUnsignedShort();
                this.imageResolutionVertical = dataInputStream.readUnsignedShort();
                this.depth = dataInputStream.readUnsignedByte();
                this.compressionAlgorithm = dataInputStream.readUnsignedByte();
                dataInputStream.readUnsignedShort();
                long l3 = l2 - 32L;
                long l4 = 0L;
                for (int i2 = 0; i2 < n3; ++i2) {
                    FingerImageInfo fingerImageInfo;
                    FingerImageInfo fingerImageInfo2;
                    FingerImageInfo fingerImageInfo3 = fingerImageInfo2 = fingerImageInfo;
                    fingerImageInfo3(inputStream, this.compressionAlgorithm);
                    l4 += fingerImageInfo3.getRecordLength();
                    this.add(fingerImageInfo);
                }
                if (l3 != l4) {
                    LOGGER.warning("ConstructedDataLength and dataLength differ: dataLength = " + l3 + ", constructedDataLength = " + l4);
                }
                return;
            }
            throw new IllegalArgumentException("'010' version number expected! Found " + Integer.toHexString(n2));
        }
        throw new IllegalArgumentException("'FIR' marker expected! Found " + Integer.toHexString(n2));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        OutputStream outputStream2;
        long l2 = 32L;
        long l3 = 0L;
        List list = ((AbstractListInfo)((Object)iterator2)).getSubRecords();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            l3 += ((FingerImageInfo)iterator.next()).getRecordLength();
        }
        l2 += l3;
        if (outputStream instanceof DataOutputStream) {
            outputStream2 = outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            outputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
        }
        OutputStream outputStream3 = outputStream2;
        OutputStream outputStream4 = outputStream2;
        ((DataOutputStream)outputStream4).writeInt(1179210240);
        ((DataOutputStream)outputStream4).writeInt(0x30313000);
        FingerInfo.writeLong(l2, outputStream4, 6);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).captureDeviceId);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).acquisitionLevel);
        ((DataOutputStream)outputStream2).writeByte(list.size());
        ((DataOutputStream)outputStream2).writeByte(((FingerInfo)((Object)iterator2)).scaleUnits);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionHorizontal);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).scanResolutionVertical);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionHorizontal);
        ((DataOutputStream)outputStream2).writeShort(((FingerInfo)((Object)iterator2)).imageResolutionVertical);
        ((DataOutputStream)outputStream2).writeByte(((FingerInfo)((Object)iterator2)).depth);
        ((DataOutputStream)outputStream3).writeByte(((FingerInfo)((Object)iterator2)).compressionAlgorithm);
        ((DataOutputStream)outputStream3).writeShort(0);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            ((FingerImageInfo)iterator2.next()).writeObject(outputStream2);
        }
    }

    @Override
    public int hashCode() {
        FingerInfo fingerInfo = this;
        int n2 = ((((((super.hashCode() * 31 + this.acquisitionLevel) * 31 + this.captureDeviceId) * 31 + this.compressionAlgorithm) * 31 + this.depth) * 31 + this.imageResolutionHorizontal) * 31 + this.imageResolutionVertical) * 31;
        StandardBiometricHeader standardBiometricHeader = fingerInfo.sbh;
        int n3 = standardBiometricHeader == null ? 0 : standardBiometricHeader.hashCode();
        return (((n2 + n3) * 31 + this.scaleUnits) * 31 + this.scanResolutionHorizontal) * 31 + this.scanResolutionVertical;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (FingerInfo.class != object.getClass()) {
            return false;
        }
        object = (FingerInfo)object;
        return this.acquisitionLevel == ((FingerInfo)object).acquisitionLevel && this.captureDeviceId == ((FingerInfo)object).captureDeviceId && this.compressionAlgorithm == ((FingerInfo)object).compressionAlgorithm && this.depth == ((FingerInfo)object).depth && this.imageResolutionHorizontal == ((FingerInfo)object).imageResolutionHorizontal && this.imageResolutionVertical == ((FingerInfo)object).imageResolutionVertical && this.scaleUnits == ((FingerInfo)object).scaleUnits && this.scanResolutionHorizontal == ((FingerInfo)object).scanResolutionHorizontal && this.scanResolutionVertical == ((FingerInfo)object).scanResolutionVertical;
    }

    public String toString() {
        StringBuilder stringBuilder;
        FingerInfo fingerInfo = serializable;
        Serializable serializable = stringBuilder;
        new StringBuilder().append("FingerInfo [");
        Iterator iterator = fingerInfo.getSubRecords().iterator();
        while (iterator.hasNext()) {
            ((StringBuilder)serializable).append(((FingerImageInfo)iterator.next()).toString());
        }
        Serializable serializable2 = serializable;
        ((StringBuilder)serializable2).append("]");
        return ((StringBuilder)serializable2).toString();
    }

    @Override
    public StandardBiometricHeader getStandardBiometricHeader() {
        if (this.sbh == null) {
            TreeMap<Integer, byte[]> treeMap;
            byte[] byArray = new byte[1];
            byte[] byArray2 = byArray;
            byArray[0] = 8;
            byte[] byArray3 = new byte[1];
            byte[] byArray4 = byArray3;
            byArray3[0] = (byte)this.getBiometricSubtype();
            byte[] byArray5 = new byte[2];
            byte[] byArray6 = byArray5;
            byArray5[0] = 1;
            byArray5[1] = 1;
            byte[] byArray7 = new byte[2];
            byte[] byArray8 = byArray7;
            byArray7[0] = 0;
            byArray7[1] = 7;
            TreeMap<Integer, byte[]> treeMap2 = treeMap;
            new TreeMap<Integer, byte[]>().put(129, byArray2);
            treeMap2.put(130, byArray4);
            treeMap2.put(135, byArray6);
            treeMap2.put(136, byArray8);
            this.sbh = new StandardBiometricHeader(treeMap2);
        }
        return this.sbh;
    }

    public List<FingerImageInfo> getFingerImageInfos() {
        return this.getSubRecords();
    }

    public void addFingerImageInfo(FingerImageInfo fingerImageInfo) {
        this.add(fingerImageInfo);
    }

    public void removeFingerImageInfo(int n2) {
        this.remove(n2);
    }
}

