/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id;

import android.content.Context;
import net.security.device.api.id.IGAID;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.SystemUtils;
import net.security.device.api.id.gaid.GAIDImpl;
import net.security.device.api.id.oaid.AsusImpl;
import net.security.device.api.id.oaid.HuaweiImpl;
import net.security.device.api.id.oaid.LenovoImpl;
import net.security.device.api.id.oaid.MeizuImpl;
import net.security.device.api.id.oaid.MsaImpl;
import net.security.device.api.id.oaid.NubiaImpl;
import net.security.device.api.id.oaid.OppoImpl;
import net.security.device.api.id.oaid.SamsungImpl;
import net.security.device.api.id.oaid.UnsupportedImpl;
import net.security.device.api.id.oaid.VivoImpl;
import net.security.device.api.id.oaid.XiaomiImpl;

public final class DeviceID {
    private DeviceID() {
    }

    public static IOAID withOAID(Context context) {
        IOAID deviceId = null;
        if (context == null) {
            return deviceId;
        }
        deviceId = SystemUtils.isXiaomi() || SystemUtils.isBlackShark() ? new XiaomiImpl(context) : (SystemUtils.isHuawei() ? new HuaweiImpl(context) : (SystemUtils.isLenovo() || SystemUtils.isMotolora() ? new LenovoImpl(context) : (SystemUtils.isMeizu() ? new MeizuImpl(context) : (SystemUtils.isNubia() ? new NubiaImpl(context) : (SystemUtils.isSamsung() ? new SamsungImpl(context) : (SystemUtils.isVivo() ? new VivoImpl(context) : (SystemUtils.isASUS() ? new AsusImpl(context) : (SystemUtils.isOppo() || SystemUtils.isOnePlus() ? new OppoImpl(context) : (SystemUtils.isZTE() || SystemUtils.isFreeme() || SystemUtils.isSSUI() ? new MsaImpl(context) : new UnsupportedImpl())))))))));
        return deviceId;
    }

    public static IGAID withGAID(Context context) {
        GAIDImpl deviceId = null;
        if (context == null) {
            return deviceId;
        }
        deviceId = new GAIDImpl(context);
        return deviceId;
    }
}

