/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.photinus;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.net.Uri;
import com.dtf.face.photinus.Frame;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class VideoWriter {
    public static final String TAG = "DTF";
    public static final boolean VERBOSE = true;
    public static final String MIME_TYPE = "video/avc";
    public static final int FRAME_RATE = 30;
    public static final int IFRAME_INTERVAL = 10;
    public static final int BIT_RATE = 3000000;
    public static final float BPP = 0.25f;
    public File _outputFile;
    public MediaCodec _Encoder;
    public MediaMuxer _Muxer;
    public int _TrackIndex;
    public boolean _MuxerStarted;
    public int _previewWidth;
    public int _previewHeight;
    public long _tsStart;
    public int _frameIndex;
    public boolean _running;
    public boolean _acceptsNewRequests;
    public int _angle;
    public OnVideoListener _listener;
    public Thread _runLoopThread;
    public final ArrayList<Request> _globalRequestQueue;

    public VideoWriter(OnVideoListener object) {
        Runnable runnable;
        VideoWriter videoWriter = this;
        this._outputFile = null;
        this._running = false;
        this._acceptsNewRequests = false;
        this._globalRequestQueue = new ArrayList();
        videoWriter._listener = object;
        object = runnable;
        final VideoWriter videoWriter2 = this;
        runnable = new Runnable(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (VideoWriter.this._running) {
                    Request request = VideoWriter.this.popRequest();
                    if (request == null) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    int n2 = request.type.ordinal();
                    if (n2 != 0) {
                        if (n2 != 1) {
                            block19: {
                                block18: {
                                    if (n2 != 2) continue;
                                    try {
                                        1 v1 = this;
                                        v1.VideoWriter.this.encodeNextFrame(VideoWriter.this._frameIndex, null);
                                        if (v1.VideoWriter.this._Encoder == null) break block18;
                                        1 v2 = this;
                                        v2.VideoWriter.this._Encoder.stop();
                                        v2.VideoWriter.this._Encoder.release();
                                        VideoWriter.access$1102(v2.VideoWriter.this, null);
                                    }
                                    catch (Throwable throwable) {
                                        block20: {
                                            try {
                                                if (VideoWriter.this._listener == null) break block20;
                                                VideoWriter.this._listener.onException(throwable);
                                            }
                                            catch (Throwable throwable2) {
                                                VideoWriter.access$002(VideoWriter.this, false);
                                                throw throwable2;
                                            }
                                        }
                                        VideoWriter.access$002(VideoWriter.this, false);
                                        continue;
                                    }
                                }
                                if (VideoWriter.this._Muxer == null) break block19;
                                1 v4 = this;
                                1 v5 = v4;
                                v4.VideoWriter.this._Muxer.stop();
                                v4.VideoWriter.this._Muxer.release();
                                VideoWriter.access$1202(v4.VideoWriter.this, null);
                                VideoWriter.access$1302(v5.VideoWriter.this, false);
                            }
                            if (VideoWriter.this._listener != null) {
                                VideoWriter.this._listener.onWriteComplete(videoWriter2);
                            }
                            1 v6 = this;
                            StringBuilder stringBuilder = new StringBuilder().append("rCloseMoveFile, took ");
                            long l2 = System.currentTimeMillis() - VideoWriter.this._tsStart;
                            stringBuilder.append(l2).append("ms").toString();
                            VideoWriter.access$002(v6.VideoWriter.this, false);
                            continue;
                        }
                        try {
                            1 v9 = this;
                            request.frame.data = VideoWriter.rotateYUV420Degree(request.frame.data, VideoWriter.this._previewWidth, VideoWriter.this._previewHeight, VideoWriter.this._angle);
                            v9.VideoWriter.this.encodeNextFrame(VideoWriter.this._frameIndex, request.frame);
                            v9.VideoWriter.this._frameIndex++;
                        }
                        catch (Exception exception) {
                            if (VideoWriter.this._listener == null) continue;
                            VideoWriter.this._listener.onException(exception);
                            continue;
                        }
                        String cfr_ignored_0 = "VideoWriter encoded frame " + VideoWriter.this._frameIndex;
                        continue;
                    }
                    1 v10 = this;
                    VideoWriter.access$202(v10.VideoWriter.this, System.currentTimeMillis());
                    VideoWriter.access$302(v10.VideoWriter.this, new File(request.fileUri.getPath()));
                    v10.VideoWriter.this.createEncoder();
                    VideoWriter.access$502(v10.VideoWriter.this, 0);
                }
            }
        };
        videoWriter._runLoopThread = new Thread((Runnable)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Request popRequest() {
        VideoWriter videoWriter = this;
        ArrayList<Request> arrayList = videoWriter._globalRequestQueue;
        synchronized (arrayList) {
            if (videoWriter._globalRequestQueue.isEmpty()) {
                return null;
            }
            return this._globalRequestQueue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushRequest(Request request) {
        VideoWriter videoWriter = this;
        ArrayList<Request> arrayList = videoWriter._globalRequestQueue;
        synchronized (arrayList) {
            block6: {
                if (!videoWriter._acceptsNewRequests) break block6;
                if (request.type == RequestType.rCloseMoveFile) {
                    this._acceptsNewRequests = false;
                }
                this._globalRequestQueue.add(request);
            }
            return;
        }
    }

    public static byte[] rotateYUV420Degree(byte[] byArray, int n2, int n3, int n4) {
        if (n4 == 270) {
            return VideoWriter.rotateYUV420Degree270(byArray, n2, n3);
        }
        if (n4 == 180) {
            return VideoWriter.rotateYUV420Degree180(byArray, n2, n3);
        }
        if (n4 == 90) {
            return VideoWriter.rotateYUV420Degree90(byArray, n2, n3);
        }
        return VideoWriter.rotateYUV420Degree0(byArray, n2, n3);
    }

    public static byte[] rotateYUV420Degree0(byte[] byArray, int n2, int n3) {
        int n4;
        n2 *= n3;
        n3 = n2 * 3 / 2;
        byte[] byArray2 = new byte[n3];
        for (n4 = 0; n4 < n2; ++n4) {
            byArray2[n4] = byArray[n4];
        }
        while (n2 < n3) {
            n4 = n2 + 1;
            byArray2[n2] = byArray[n4];
            byArray2[n4] = byArray[n2];
            n2 += 2;
        }
        return byArray2;
    }

    public static byte[] rotateYUV420Degree90(byte[] byArray, int n2, int n3) {
        int n4 = n2 * n3;
        int n5 = n4 * 3 / 2;
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        int n7 = n3 - 1;
        int n8 = n7 * n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n9 = n8;
            int n10 = n6;
            for (n6 = n7; n6 >= 0; --n6) {
                byArray2[n10] = byArray[n9 + i2];
                ++n10;
                n9 -= n2;
            }
            n6 = n10;
        }
        --n5;
        for (n6 = n2 - 1; n6 > 0; n6 -= 2) {
            n8 = n4;
            for (n7 = 0; n7 < n3 / 2; ++n7) {
                int n11 = n8;
                byArray2[n5] = byArray[(n8 += n6) - 1];
                byArray2[n5 += -1] = byArray[n8];
                --n5;
                n8 = n11 + n2;
            }
        }
        return byArray2;
    }

    public static byte[] rotateYUV420Degree180(byte[] byArray, int n2, int n3) {
        int n4;
        n2 *= n3;
        n3 = n2 * 3 / 2;
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        for (n4 = n2 - 1; n4 >= 0; --n4) {
            byArray2[n5] = byArray[n4];
            ++n5;
        }
        --n3;
        while (n3 >= n2) {
            n4 = n5 + 1;
            byArray2[n5] = byArray[n3];
            n5 = n4 + 1;
            byArray2[n4] = byArray[n3 - 1];
            n3 -= 2;
        }
        return byArray2;
    }

    public static byte[] rotateYUV420Degree270(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n2;
        int n8 = n7 * n3;
        byte[] byArray2 = new byte[n8 * 3 / 2];
        int n9 = 0;
        int n10 = 0;
        if (n7 != 0 || n3 != 0) {
            n10 = n3 >> 1;
            n9 = n8;
        }
        n8 = 0;
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                byArray2[n8] = byArray[n5 + n6];
                ++n8;
                n5 += n2;
            }
        }
        for (n6 = 0; n6 < n2; n6 += 2) {
            int n11;
            n4 = n8;
            n8 = n9;
            for (n5 = 0; n5 < n10 && (n11 = n8 + n6) < byArray2.length - 2; ++n5) {
                int n12 = n8;
                byArray2[n4] = byArray[n11];
                byArray2[n4 + 1] = byArray[n11 + 1];
                n8 = n4 + 2;
                n4 = n12 + n2;
                int n13 = n4;
                n4 = n8;
                n8 = n13;
            }
            n8 = n4;
        }
        return VideoWriter.rotateYUV420Degree180(byArray2, n2, n3);
    }

    private int calcBitRate(int n2) {
        int n3 = (int)((float)n2 * 0.25f * (float)this._previewHeight * (float)this._previewWidth);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Float.valueOf((float)n3 / 1024.0f / 1024.0f);
        String.format("bitrate=%5.2f[Mbps]", objectArray2);
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createEncoder() {
        MediaCodecInfo mediaCodecInfo = VideoWriter.selectCodec(MIME_TYPE);
        if (mediaCodecInfo == null) {
            return;
        }
        VideoWriter videoWriter = this;
        String cfr_ignored_0 = "found codec: " + mediaCodecInfo.getName();
        int n2 = 21;
        String cfr_ignored_1 = "found colorFormat: " + VideoWriter.colorFormatDesc(n2);
        MediaFormat mediaFormat = videoWriter._angle != 90 && this._angle != 270 ? MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this._previewWidth, (int)this._previewHeight) : MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this._previewHeight, (int)this._previewWidth);
        VideoWriter videoWriter2 = this;
        VideoWriter videoWriter3 = videoWriter2;
        VideoWriter videoWriter4 = videoWriter2;
        VideoWriter videoWriter5 = videoWriter2;
        VideoWriter videoWriter6 = videoWriter2;
        VideoWriter videoWriter7 = videoWriter2;
        MediaCodecInfo mediaCodecInfo2 = mediaCodecInfo;
        MediaFormat mediaFormat2 = mediaFormat;
        mediaFormat2.setInteger("color-format", n2);
        mediaFormat2.setInteger("bitrate", 3000000);
        mediaFormat2.setInteger("frame-rate", 30);
        mediaFormat2.setInteger("i-frame-interval", 10);
        String cfr_ignored_2 = "format: " + mediaFormat;
        try {
            videoWriter4._Encoder = MediaCodec.createByCodecName((String)mediaCodecInfo2.getName());
            videoWriter5._Encoder.configure(mediaFormat, null, null, 1);
            videoWriter6._Encoder.start();
            String string = videoWriter7._outputFile.getAbsolutePath();
            videoWriter3._Muxer = new MediaMuxer(string, 0);
            return;
        }
        catch (Throwable throwable) {
            OnVideoListener onVideoListener = this._listener;
            if (onVideoListener != null) {
                onVideoListener.onException(throwable);
            }
            this._running = false;
            this._acceptsNewRequests = false;
            this._globalRequestQueue.clear();
        }
    }

    public static MediaCodecInfo selectCodec(String string) {
        MediaCodecInfo mediaCodecInfo = VideoWriter.selectGoogleCodec(string);
        if (mediaCodecInfo != null) {
            return mediaCodecInfo;
        }
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo2 = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo2.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo2.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo2;
            }
        }
        return null;
    }

    public static MediaCodecInfo selectGoogleCodec(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String string2 = mediaCodecInfo.getName();
            if (string2 == null) {
                string2 = "";
            }
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string) || !string2.contains("google")) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    public static int selectColorFormat(MediaCodecInfo mediaCodecInfo, String string) {
        mediaCodecInfo = mediaCodecInfo.getCapabilitiesForType(string);
        int n2 = 0;
        while (true) {
            int[] nArray = mediaCodecInfo.colorFormats;
            if (n2 >= mediaCodecInfo.colorFormats.length) break;
            int n3 = nArray[n2];
            if (VideoWriter.isRecognizedFormat(n3)) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    public static String colorFormatDesc(int n2) {
        if (n2 != 39) {
            if (n2 != 2130706688) {
                switch (n2) {
                    default: {
                        return "Unknown color format";
                    }
                    case 21: {
                        return "COLOR_FormatYUV420SemiPlanar";
                    }
                    case 20: {
                        return "COLOR_FormatYUV420PackedPlanar";
                    }
                    case 19: 
                }
                return "COLOR_FormatYUV420Planar";
            }
            return "COLOR_TI_FormatYUV420PackedSemiPlanar";
        }
        return "COLOR_FormatYUV420PackedSemiPlanar";
    }

    public static boolean isRecognizedFormat(int n2) {
        if (n2 != 39 && n2 != 2130706688) {
            switch (n2) {
                default: {
                    return false;
                }
                case 19: 
                case 20: 
                case 21: 
            }
        }
        return true;
    }

    private void encodeNextFrame(int n2, Frame frame) {
        MediaCodec.BufferInfo bufferInfo;
        VideoWriter videoWriter = object;
        ByteBuffer[] byteBufferArray = videoWriter._Encoder.getInputBuffers();
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        int n3 = videoWriter._Encoder.dequeueInputBuffer(10000L);
        if (n3 >= 0) {
            long l2 = VideoWriter.computePresentationTime(n2);
            if (frame == null) {
                VideoWriter videoWriter2 = object;
                videoWriter2._Encoder.queueInputBuffer(n3, 0, 0, l2, 4);
                videoWriter2.drainEncoder(true, bufferInfo2);
            } else {
                VideoWriter videoWriter3 = object;
                Object object = frame.data;
                ByteBuffer byteBuffer = byteBufferArray[n3];
                byteBuffer.clear();
                byteBuffer.put((byte[])object);
                videoWriter3._Encoder.queueInputBuffer(n3, 0, ((Object)object).length, l2, 0);
                videoWriter3.drainEncoder(false, bufferInfo2);
            }
        }
    }

    private void drainEncoder(boolean bl, MediaCodec.BufferInfo bufferInfo) {
        int n2;
        block16: {
            if (bl) {
                try {
                    this._Encoder.signalEndOfInputStream();
                }
                catch (Exception exception) {}
            }
            ByteBuffer[] byteBufferArray = this._Encoder.getOutputBuffers();
            while (true) {
                if ((n2 = this._Encoder.dequeueOutputBuffer(bufferInfo, 10000L)) == -1) {
                    if (bl) continue;
                    break;
                }
                if (n2 == -3) {
                    byteBufferArray = this._Encoder.getOutputBuffers();
                    continue;
                }
                if (n2 == -2) {
                    if (!this._MuxerStarted) {
                        VideoWriter videoWriter = this;
                        MediaFormat mediaFormat = videoWriter._Encoder.getOutputFormat();
                        String cfr_ignored_0 = "encoder output format changed: " + mediaFormat;
                        videoWriter._TrackIndex = videoWriter._Muxer.addTrack(mediaFormat);
                        videoWriter._Muxer.start();
                        videoWriter._MuxerStarted = true;
                        continue;
                    }
                    throw new RuntimeException("format changed twice");
                }
                if (n2 < 0) {
                    String cfr_ignored_1 = "unexpected result from encoder.dequeueOutputBuffer: " + n2;
                    continue;
                }
                ByteBuffer byteBuffer = byteBufferArray[n2];
                if (byteBuffer != null) {
                    if ((bufferInfo.flags & 2) != 0) {
                        bufferInfo.size = 0;
                    }
                    if (bufferInfo.size != 0) {
                        if (this._MuxerStarted) {
                            byteBuffer.position(bufferInfo.offset);
                            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                            String cfr_ignored_2 = "BufferInfo: " + bufferInfo.offset + "," + bufferInfo.size + "," + bufferInfo.presentationTimeUs;
                            try {
                                this._Muxer.writeSampleData(this._TrackIndex, byteBuffer, bufferInfo);
                            }
                            catch (Exception exception) {}
                        } else {
                            throw new RuntimeException("muxer hasn't started");
                        }
                    }
                    this._Encoder.releaseOutputBuffer(n2, false);
                    if ((bufferInfo.flags & 4) != 0) break;
                    continue;
                }
                break block16;
                break;
            }
            return;
        }
        throw new RuntimeException("encoderOutputBuffer " + n2 + " was null");
    }

    public static long computePresentationTime(int n2) {
        return n2 * 1000000 / 30 + 132;
    }

    public static /* synthetic */ long access$202(VideoWriter videoWriter, long l2) {
        videoWriter._tsStart = l2;
        return l2;
    }

    public static /* synthetic */ File access$302(VideoWriter videoWriter, File file) {
        videoWriter._outputFile = file;
        return file;
    }

    public static /* synthetic */ int access$502(VideoWriter videoWriter, int n2) {
        videoWriter._frameIndex = n2;
        return n2;
    }

    public static /* synthetic */ MediaCodec access$1102(VideoWriter videoWriter, MediaCodec mediaCodec) {
        videoWriter._Encoder = mediaCodec;
        return mediaCodec;
    }

    public static /* synthetic */ MediaMuxer access$1202(VideoWriter videoWriter, MediaMuxer mediaMuxer) {
        videoWriter._Muxer = mediaMuxer;
        return mediaMuxer;
    }

    public static /* synthetic */ boolean access$1302(VideoWriter videoWriter, boolean bl) {
        videoWriter._MuxerStarted = bl;
        return bl;
    }

    public static /* synthetic */ boolean access$002(VideoWriter videoWriter, boolean bl) {
        videoWriter._running = bl;
        return bl;
    }

    public boolean isRunning() {
        return this._running;
    }

    public void openNewFile(Uri uri, int n2, int n3, int n4) {
        if (!this._running) {
            VideoWriter videoWriter = this;
            VideoWriter videoWriter2 = this;
            videoWriter2._running = true;
            videoWriter2._acceptsNewRequests = true;
            this._previewWidth = n2;
            this._previewHeight = n3;
            videoWriter._angle = n4;
            videoWriter.pushRequest(new Request(uri));
            videoWriter._runLoopThread.start();
        }
    }

    public void closeFile() {
        this.pushRequest(new Request());
    }

    public void addFrame(Frame frame) {
        this.pushRequest(new Request(frame));
    }

    public static class Request {
        public RequestType type;
        public Uri fileUri;
        public Frame frame;

        public Request(Uri uri) {
            Request request = this;
            request.fileUri = uri;
            request.type = RequestType.rStartNewMovie;
        }

        public Request(Frame frame) {
            Request request = this;
            request.frame = frame;
            request.type = RequestType.rAddMovieFrame;
        }

        public Request() {
            this.type = RequestType.rCloseMoveFile;
        }
    }

    public static enum RequestType {
        rStartNewMovie,
        rAddMovieFrame,
        rCloseMoveFile;

    }

    public static interface OnVideoListener {
        public void onWriteComplete(VideoWriter var1);

        public void onException(Throwable var1);
    }
}

