/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1OctetString;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.DEROctetString;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x9.X962NamedCurves;
import org.eid_bc.bouncycastle.asn1.x9.X962Parameters;
import org.eid_bc.bouncycastle.asn1.x9.X9ECParameters;
import org.eid_bc.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.jmrtd.Util;
import org.jmrtd.lds.SecurityInfo;

public class PACEDomainParameterInfo
extends SecurityInfo {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final long serialVersionUID = -5851251908152594728L;
    public static final String ID_PRIME_FIELD = "1.2.840.10045.1.1";
    public static final String ID_EC_PUBLIC_KEY = "1.2.840.10045.2.1";
    public static final String ID_DH_PUBLIC_NUMBER = "1.2.840.10046.2.1";
    public String oid;
    public transient AlgorithmIdentifier domainParameter;
    public BigInteger parameterId;

    public PACEDomainParameterInfo(String string, AlgorithmIdentifier algorithmIdentifier) {
        this(string, algorithmIdentifier, null);
    }

    public PACEDomainParameterInfo(String string, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger) {
        if (PACEDomainParameterInfo.checkRequiredIdentifier(string)) {
            this.oid = string;
            this.domainParameter = algorithmIdentifier;
            this.parameterId = bigInteger;
            return;
        }
        throw new IllegalArgumentException("Invalid protocol id: " + string);
    }

    public static boolean checkRequiredIdentifier(String string) {
        return "0.4.0.127.0.7.2.2.4.1".equals(string) || "0.4.0.127.0.7.2.2.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.3".equals(string) || "0.4.0.127.0.7.2.2.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6".equals(string);
    }

    @Deprecated
    public static AlgorithmIdentifier toAlgorithmIdentifier(ECParameterSpec aSN1EncodableArray) {
        DLSequence dLSequence;
        DEROctetString dEROctetString;
        DEROctetString dEROctetString2;
        ASN1Integer aSN1Integer;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ASN1Integer(BigInteger.ONE));
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(ID_PRIME_FIELD);
        EllipticCurve ellipticCurve = aSN1EncodableArray.getCurve();
        ECFieldFp eCFieldFp = (ECFieldFp)ellipticCurve.getField();
        ASN1Integer aSN1Integer2 = aSN1Integer;
        aSN1Integer = new ASN1Integer(eCFieldFp.getP());
        arrayList.add(new DLSequence(new ASN1Encodable[]{aSN1ObjectIdentifier2, aSN1Integer2}));
        aSN1ObjectIdentifier2 = dEROctetString2;
        dEROctetString2 = new DEROctetString(Util.i2os(ellipticCurve.getA()));
        eCFieldFp = dEROctetString;
        dEROctetString = new DEROctetString(Util.i2os(ellipticCurve.getB()));
        arrayList.add(new DLSequence(new ASN1Encodable[]{aSN1ObjectIdentifier2, eCFieldFp}));
        arrayList.add(new DEROctetString(Util.ecPoint2OS(aSN1EncodableArray.getGenerator())));
        arrayList.add(new ASN1Integer(aSN1EncodableArray.getOrder()));
        arrayList.add(new ASN1Integer((long)aSN1EncodableArray.getCofactor()));
        aSN1EncodableArray = new ASN1Encodable[arrayList.size()];
        arrayList.toArray(aSN1EncodableArray);
        aSN1ObjectIdentifier2 = dLSequence;
        dLSequence = new DLSequence(aSN1EncodableArray);
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY), (ASN1Encodable)aSN1ObjectIdentifier2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static ECParameterSpec toECParameterSpec(AlgorithmIdentifier object) {
        ECFieldFp eCFieldFp;
        EllipticCurve ellipticCurve;
        Object object2;
        ECPoint eCPoint;
        BigInteger bigInteger;
        Object object3;
        BigInteger bigInteger2;
        ASN1Sequence aSN1Sequence;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        block17: {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            X962Parameters x962Parameters;
            if (!((object = object.getParameters()) instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("Was expecting an ASN.1 sequence");
            }
            try {
                x962Parameters = X962Parameters.getInstance((Object)object);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
                break block17;
            }
            {
                if (!x962Parameters.isNamedCurve()) break block17;
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)x962Parameters.getParameters();
            }
            {
                X9ECParameters x9ECParameters = X962NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                return Util.toECNamedCurveSpec(new ECNamedCurveParameterSpec(X962NamedCurves.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed()));
            }
        }
        if ((object = (ASN1Sequence)object).size() < 5) {
            throw new IllegalArgumentException("Was expecting an ASN.1 sequence of length 5 or longer");
        }
        try {
            Object object9 = object;
            object8 = object9;
            object7 = object9;
            object6 = object9;
            object5 = object9;
            object4 = object9;
            ((ASN1Integer)object9.getObjectAt(0)).getValue();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Exception", exception);
            throw new IllegalArgumentException("Could not get EC parameters from explicit parameters");
        }
        {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)object6.getObjectAt(1);
            aSN1Sequence = aSN1Sequence2;
            ((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId();
        }
        {
            bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getPositiveValue();
            ASN1Sequence aSN1Sequence3 = (ASN1Sequence)object5.getObjectAt(2);
            object3 = (ASN1OctetString)aSN1Sequence3.getObjectAt(0);
            object3 = Util.os2i(object3.getOctets());
            bigInteger = Util.os2i(((ASN1OctetString)aSN1Sequence3.getObjectAt(1)).getOctets());
            eCPoint = Util.os2ECPoint(((ASN1OctetString)object4.getObjectAt(3)).getOctets());
        }
        {
            object2 = eCPoint.getAffineX();
        }
        {
            eCPoint.getAffineY().pow(2).mod(bigInteger2);
        }
        {
            ((BigInteger)object2).pow(3).add(((BigInteger)object3).multiply((BigInteger)object2)).add(bigInteger).mod(bigInteger2);
        }
        object2 = ellipticCurve;
        ECFieldFp eCFieldFp2 = eCFieldFp;
        {
            eCFieldFp2(bigInteger2);
            ellipticCurve = new EllipticCurve(eCFieldFp, (BigInteger)object3, bigInteger);
            BigInteger bigInteger3 = ((ASN1Integer)object8.getObjectAt(4)).getPositiveValue();
            if (object7.size() <= 5) {
                return new ECParameterSpec((EllipticCurve)object2, eCPoint, bigInteger3, 1);
            }
            object = ((ASN1Integer)object.getObjectAt(5)).getValue();
            return new ECParameterSpec((EllipticCurve)object2, eCPoint, bigInteger3, ((BigInteger)object).intValue());
        }
    }

    public static AlgorithmIdentifier toAlgorithmIdentifier(String string, ASN1Encodable aSN1Encodable) {
        if (!"0.4.0.127.0.7.2.2.4.1".equals(string) && !"0.4.0.127.0.7.2.2.4.3".equals(string)) {
            if (!("0.4.0.127.0.7.2.2.4.2".equals(string) || "0.4.0.127.0.7.2.2.4.4".equals(string) || "0.4.0.127.0.7.2.2.4.6".equals(string))) {
                throw new IllegalArgumentException("Cannot infer algorithm OID from protocol OID: " + string);
            }
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_EC_PUBLIC_KEY), aSN1Encodable);
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(ID_DH_PUBLIC_NUMBER), aSN1Encodable);
    }

    public static String toProtocolOIDString(String string) {
        if ("0.4.0.127.0.7.2.2.4.1".equals(string)) {
            string = "id-PACE-DH-GM";
        } else if ("0.4.0.127.0.7.2.2.4.2".equals(string)) {
            string = "id-PACE-ECDH-GM";
        } else if ("0.4.0.127.0.7.2.2.4.3".equals(string)) {
            string = "id-PACE-DH-IM";
        } else if ("0.4.0.127.0.7.2.2.4.4".equals(string)) {
            string = "id-PACE-ECDH-IM";
        } else if ("0.4.0.127.0.7.2.2.4.6".equals(string)) {
            string = "id-PACE-ECDH-CAM";
        }
        return string;
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return PACEDomainParameterInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getParameterId() {
        return this.parameterId;
    }

    public AlgorithmParameterSpec getParameters() {
        if (!ID_DH_PUBLIC_NUMBER.equals(this.oid)) {
            if (ID_EC_PUBLIC_KEY.equals(this.oid)) {
                return PACEDomainParameterInfo.toECParameterSpec(this.domainParameter);
            }
            throw new IllegalStateException("Unsupported PACEDomainParameterInfo type " + this.oid);
        }
        throw new IllegalStateException("DH PACEDomainParameterInfo not yet implemented");
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3();
        aSN1EncodableVector3.add((ASN1Encodable)new ASN1ObjectIdentifier(serializable.oid));
        aSN1EncodableVector.add((ASN1Encodable)serializable.domainParameter);
        Serializable serializable = serializable.parameterId;
        if (serializable != null) {
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((BigInteger)serializable));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("PACEDomainParameterInfo[protocol: ").append(PACEDomainParameterInfo.toProtocolOIDString(((PACEDomainParameterInfo)((Object)string)).oid)).append(", domainParameter: [algorithm: ").append(((PACEDomainParameterInfo)((Object)string)).domainParameter.getAlgorithm().getId()).append(", parameters: ").append(((PACEDomainParameterInfo)((Object)string)).domainParameter.getParameters());
        String string = ((PACEDomainParameterInfo)((Object)string)).parameterId == null ? "" : ", parameterId: " + ((PACEDomainParameterInfo)((Object)string)).parameterId;
        return stringBuilder.append(string).append("]").toString();
    }

    public int hashCode() {
        PACEDomainParameterInfo pACEDomainParameterInfo = this;
        int n2 = pACEDomainParameterInfo.oid.hashCode() * 7 + 111111111 + this.domainParameter.hashCode() * 5;
        int n3 = 3;
        BigInteger bigInteger = pACEDomainParameterInfo.parameterId;
        return n2 + (bigInteger == null ? 333 : bigInteger.hashCode()) * n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == pACEDomainParameterInfo2) {
            return true;
        }
        if (!PACEDomainParameterInfo.class.equals(object.getClass())) {
            return false;
        }
        PACEDomainParameterInfo pACEDomainParameterInfo = pACEDomainParameterInfo2;
        PACEDomainParameterInfo pACEDomainParameterInfo2 = (PACEDomainParameterInfo)object;
        return pACEDomainParameterInfo.getDERObject().equals((Object)pACEDomainParameterInfo2.getDERObject());
    }
}

