/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import net.sf.scuba.data.Gender;
import org.jmrtd.lds.AbstractLDSInfo;

public class MRZInfo
extends AbstractLDSInfo {
    public static final long serialVersionUID = 7054965914471297804L;
    public static final int DOC_TYPE_UNSPECIFIED = 0;
    public static final int DOC_TYPE_ID1 = 1;
    public static final int DOC_TYPE_ID2 = 2;
    public static final int DOC_TYPE_ID3 = 3;
    public static final String MRZ_CHARS = "<0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @Deprecated
    public int documentType;
    public String documentCode;
    public String issuingState;
    public String primaryIdentifier;
    public String secondaryIdentifier;
    public String nationality;
    public String documentNumber;
    public String dateOfBirth;
    public Gender gender;
    public String dateOfExpiry;
    public char documentNumberCheckDigit;
    public char dateOfBirthCheckDigit;
    public char dateOfExpiryCheckDigit;
    public char compositeCheckDigit;
    public String optionalData1;
    public String optionalData2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MRZInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, Gender gender, String string8, String string9) {
        if (string == null || string.length() < 1 || string.length() > 2 || !string.startsWith("P") && !string.startsWith("V")) throw new IllegalArgumentException("Wrong document code: " + string);
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(string);
        this.documentCode = MRZInfo.trimFillerChars(string);
        this.issuingState = string2;
        this.primaryIdentifier = string3;
        this.secondaryIdentifier = string4;
        this.documentNumber = MRZInfo.trimFillerChars(string5);
        this.nationality = string6;
        this.dateOfBirth = string7;
        this.gender = gender;
        this.dateOfExpiry = string8;
        if (string9 != null && !MRZInfo.equalsModuloFillerChars(string9, "")) {
            if (string9.length() == 15) {
                this.optionalData1 = string9;
            } else {
                if (string9.length() > 14) throw new IllegalArgumentException("Wrong personal number: " + string9);
                this.optionalData1 = MRZInfo.mrzFormat(string9, 14) + MRZInfo.checkDigit(string9, true);
            }
        } else {
            this.optionalData1 = "";
        }
        this.checkDigit();
    }

    public MRZInfo(String charSequence, String string, String string2, String string3, String string4, Gender gender, String string5, String string6, String string7, String string8, String string9) {
        if (charSequence != null && ((String)charSequence).length() >= 1 && ((String)charSequence).length() <= 2 && (((String)charSequence).startsWith("C") || ((String)charSequence).startsWith("I") || ((String)charSequence).startsWith("A"))) {
            ((MRZInfo)this).documentType = MRZInfo.getDocumentTypeFromDocumentCode((String)charSequence);
            ((MRZInfo)this).documentCode = MRZInfo.trimFillerChars((String)charSequence);
            ((MRZInfo)this).issuingState = string;
            ((MRZInfo)this).primaryIdentifier = string8;
            ((MRZInfo)this).secondaryIdentifier = string9;
            ((MRZInfo)this).documentNumber = MRZInfo.trimFillerChars(string2);
            ((MRZInfo)this).nationality = string6;
            ((MRZInfo)this).dateOfBirth = string4;
            ((MRZInfo)this).gender = gender;
            ((MRZInfo)this).dateOfExpiry = string5;
            if (string3 != null && string3.length() <= 15) {
                ((MRZInfo)this).optionalData1 = string3;
                ((MRZInfo)this).optionalData2 = string7;
                ((MRZInfo)this).checkDigit();
                return;
            }
            charSequence = new StringBuilder().append("Wrong optional data 1: ");
            string = string3 == null ? "null" : "\"" + string3 + "\"";
            Serializable serializable = this;
            super(((StringBuilder)charSequence).append(string).toString());
            throw serializable;
        }
        throw new IllegalArgumentException("Wrong document code: " + (String)charSequence);
    }

    public MRZInfo(InputStream inputStream, int n2) {
        try {
            this.readObject(inputStream, n2);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public MRZInfo(String string) {
        if (string != null) {
            MRZInfo mRZInfo = string2;
            String string2 = string.trim().replace("\n", "");
            try {
                mRZInfo.readObject(new ByteArrayInputStream(string2.getBytes("UTF-8")), string2.length());
                return;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Exception", iOException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("Exception", unsupportedEncodingException);
            }
        }
        throw new IllegalArgumentException("Null string");
    }

    private void readObject(InputStream inputStream, int n2) {
        DataInputStream dataInputStream;
        MRZInfo mRZInfo = string;
        DataInputStream dataInputStream2 = dataInputStream;
        mRZInfo.documentCode = mRZInfo.readStringWithFillers(new DataInputStream(inputStream), 2);
        mRZInfo.documentType = MRZInfo.getDocumentTypeFromDocumentCode(mRZInfo.documentCode);
        ((MRZInfo)((Object)string)).documentType = n2 != 88 ? (n2 != 90 ? MRZInfo.getDocumentTypeFromDocumentCode(((MRZInfo)((Object)string)).documentCode) : 1) : 3;
        if (((MRZInfo)((Object)string)).documentType == 1) {
            MRZInfo mRZInfo2 = string;
            ((MRZInfo)((Object)string)).issuingState = ((MRZInfo)((Object)string)).readCountry(dataInputStream2);
            ((MRZInfo)((Object)string)).documentNumber = ((MRZInfo)((Object)string)).readString(dataInputStream2, 9);
            ((MRZInfo)((Object)string)).documentNumberCheckDigit = (char)dataInputStream2.readUnsignedByte();
            mRZInfo2.optionalData1 = mRZInfo2.readStringWithFillers(dataInputStream2, 15);
            if (mRZInfo2.documentNumberCheckDigit == '<') {
                String string = ((MRZInfo)((Object)string)).optionalData1;
                ((MRZInfo)((Object)string)).documentNumber = ((MRZInfo)((Object)string)).documentNumber + string.substring(0, string.length() - 1);
                String string2 = ((MRZInfo)((Object)string)).optionalData1;
                ((MRZInfo)((Object)string)).documentNumberCheckDigit = string2.charAt(string2.length() - 1);
                ((MRZInfo)((Object)string)).optionalData1 = null;
            }
            MRZInfo mRZInfo3 = string;
            ((MRZInfo)((Object)string)).documentNumber = MRZInfo.trimFillerChars(((MRZInfo)((Object)string)).documentNumber);
            ((MRZInfo)((Object)string)).dateOfBirth = ((MRZInfo)((Object)string)).readDateOfBirth(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfBirthCheckDigit = (char)dataInputStream2.readUnsignedByte();
            ((MRZInfo)((Object)string)).gender = ((MRZInfo)((Object)string)).readGender(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfExpiry = ((MRZInfo)((Object)string)).readDateOfExpiry(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfExpiryCheckDigit = (char)dataInputStream2.readUnsignedByte();
            ((MRZInfo)((Object)string)).nationality = ((MRZInfo)((Object)string)).readCountry(dataInputStream2);
            ((MRZInfo)((Object)string)).optionalData2 = ((MRZInfo)((Object)string)).readString(dataInputStream2, 11);
            ((MRZInfo)((Object)string)).compositeCheckDigit = (char)dataInputStream2.readUnsignedByte();
            mRZInfo3.readNameIdentifiers(mRZInfo3.readString(dataInputStream2, 30));
        } else {
            MRZInfo mRZInfo4 = string;
            MRZInfo mRZInfo5 = string;
            MRZInfo mRZInfo6 = string;
            ((MRZInfo)((Object)string)).issuingState = ((MRZInfo)((Object)string)).readCountry(dataInputStream2);
            mRZInfo6.readNameIdentifiers(mRZInfo6.readString(dataInputStream2, 39));
            ((MRZInfo)((Object)string)).documentNumber = MRZInfo.trimFillerChars(((MRZInfo)((Object)string)).readString(dataInputStream2, 9));
            ((MRZInfo)((Object)string)).documentNumberCheckDigit = (char)dataInputStream2.readUnsignedByte();
            ((MRZInfo)((Object)string)).nationality = ((MRZInfo)((Object)string)).readCountry(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfBirth = ((MRZInfo)((Object)string)).readDateOfBirth(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfBirthCheckDigit = (char)dataInputStream2.readUnsignedByte();
            ((MRZInfo)((Object)string)).gender = ((MRZInfo)((Object)string)).readGender(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfExpiry = ((MRZInfo)((Object)string)).readDateOfExpiry(dataInputStream2);
            ((MRZInfo)((Object)string)).dateOfExpiryCheckDigit = (char)dataInputStream2.readUnsignedByte();
            String string = ((MRZInfo)((Object)string)).readStringWithFillers(dataInputStream2, 14);
            mRZInfo5.optionalData1 = MRZInfo.mrzFormat(string, 14) + (char)dataInputStream2.readUnsignedByte();
            mRZInfo4.compositeCheckDigit = (char)dataInputStream2.readUnsignedByte();
        }
    }

    public static char checkDigit(String string) {
        return MRZInfo.checkDigit(string, false);
    }

    private void readNameIdentifiers(String string) {
        int n2 = string.indexOf("<<");
        if (n2 < 0) {
            MRZInfo mRZInfo = this;
            mRZInfo.primaryIdentifier = MRZInfo.trimFillerChars(string);
            mRZInfo.secondaryIdentifier = "";
        } else {
            String string2 = string;
            this.primaryIdentifier = MRZInfo.trimFillerChars(string.substring(0, n2));
            this.readSecondaryIdentifiers(string2.substring(string2.indexOf("<<") + 2));
        }
    }

    private void readSecondaryIdentifiers(String string) {
        this.secondaryIdentifier = string;
    }

    private void writeString(String string, DataOutputStream dataOutputStream, int n2) {
        dataOutputStream.write(MRZInfo.mrzFormat(string, n2).getBytes("UTF-8"));
    }

    private void writeIssuingState(DataOutputStream dataOutputStream) {
        dataOutputStream.write(this.issuingState.getBytes("UTF-8"));
    }

    private void writeDateOfExpiry(DataOutputStream dataOutputStream) {
        dataOutputStream.write(this.dateOfExpiry.getBytes("UTF-8"));
    }

    private void writeGender(DataOutputStream dataOutputStream) {
        dataOutputStream.write(MRZInfo.genderToString(this.gender).getBytes("UTF-8"));
    }

    private void writeDateOfBirth(DataOutputStream dataOutputStream) {
        dataOutputStream.write(this.dateOfBirth.getBytes("UTF-8"));
    }

    private void writeNationality(DataOutputStream dataOutputStream) {
        dataOutputStream.write(this.nationality.getBytes("UTF-8"));
    }

    private void writeName(DataOutputStream dataOutputStream, int n2) {
        dataOutputStream.write(MRZInfo.nameToString(this.primaryIdentifier, this.secondaryIdentifier, n2).getBytes("UTF-8"));
    }

    private void writeDocumentType(DataOutputStream dataOutputStream) {
        MRZInfo mRZInfo = this;
        mRZInfo.writeString(mRZInfo.documentCode, dataOutputStream, 2);
    }

    public static String genderToString(Gender gender) {
        int n2 = gender.ordinal();
        if (n2 != 1) {
            if (n2 != 2) {
                return "<";
            }
            return "F";
        }
        return "M";
    }

    public static String nameToString(String stringArray, String string, int n2) {
        StringBuilder stringBuilder;
        stringArray = stringArray.split(" |<");
        String[] stringArray2 = string != null && !string.trim().isEmpty() ? string.split(" |<") : new String[]{};
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n3 = 1;
        for (String string2 : stringArray) {
            if (n3 != 0) {
                n3 = 0;
            } else {
                stringBuilder2.append('<');
            }
            stringBuilder2.append(string2);
        }
        if (string != null && !string.trim().isEmpty()) {
            stringBuilder2.append("<<");
            boolean bl = true;
            for (String string3 : stringArray2) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder2.append('<');
                }
                stringBuilder2.append(string3);
            }
        }
        return MRZInfo.mrzFormat(stringBuilder2.toString(), n2);
    }

    private String readStringWithFillers(DataInputStream dataInputStream, int n2) {
        return MRZInfo.trimFillerChars(this.readString(dataInputStream, n2));
    }

    private String readCountry(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 3);
    }

    private Gender readGender(DataInputStream dataInputStream) {
        return "M".equalsIgnoreCase((String)(this = ((MRZInfo)this).readString(dataInputStream, 1))) ? Gender.MALE : ("F".equalsIgnoreCase((String)this) ? Gender.FEMALE : Gender.UNKNOWN);
    }

    private String readDateOfBirth(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 6);
    }

    private String readDateOfExpiry(DataInputStream dataInputStream) {
        return this.readString(dataInputStream, 6);
    }

    private String readString(DataInputStream dataInputStream, int n2) {
        byte[] byArray = new byte[n2];
        Object object = byArray;
        dataInputStream.readFully(byArray);
        return new String((byte[])object).trim();
    }

    public static String mrzFormat(String string, int n2) {
        if (string != null) {
            if (string.length() <= n2) {
                StringBuilder stringBuilder;
                string = string.toUpperCase().trim();
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (MRZ_CHARS.indexOf(c2) == -1) {
                        stringBuilder2.append('<');
                        continue;
                    }
                    stringBuilder2.append(c2);
                }
                while (stringBuilder2.length() < n2) {
                    stringBuilder2.append("<");
                }
                return stringBuilder2.toString();
            }
            throw new IllegalArgumentException("Argument too wide (" + string.length() + " > " + n2 + ")");
        }
        throw new IllegalArgumentException("Attempting to MRZ format null");
    }

    public static boolean equalsModuloFillerChars(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string;
        int n2 = Math.max(string3.length(), string2.length());
        return MRZInfo.mrzFormat(string3, n2).equals(MRZInfo.mrzFormat(string2, n2));
    }

    public static int getDocumentTypeFromDocumentCode(String string) {
        if (string != null && string.length() >= 1 && string.length() <= 2) {
            return !(string.startsWith("A") || string.startsWith("C") || string.startsWith("I") || string.startsWith("V")) ? (string.startsWith("P") ? 3 : 0) : 1;
        }
        throw new IllegalArgumentException("Was expecting 1 or 2 digit document code, got " + string);
    }

    public static String trimFillerChars(String object) {
        object = ((String)object).trim().getBytes();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (object[i2] != 60) continue;
            object[i2] = 32;
        }
        return new String((byte[])object).trim();
    }

    private void checkDigit() {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        MRZInfo mRZInfo = this;
        mRZInfo.documentNumberCheckDigit = MRZInfo.checkDigit(mRZInfo.documentNumber);
        mRZInfo.dateOfBirthCheckDigit = MRZInfo.checkDigit(mRZInfo.dateOfBirth);
        mRZInfo.dateOfExpiryCheckDigit = MRZInfo.checkDigit(mRZInfo.dateOfExpiry);
        if (mRZInfo.optionalData1.length() < 15) {
            MRZInfo mRZInfo2 = this;
            charSequence = MRZInfo.mrzFormat(mRZInfo2.optionalData1, 14);
            mRZInfo2.optionalData1 = (String)charSequence + MRZInfo.checkDigit(MRZInfo.mrzFormat(mRZInfo2.optionalData1, 14), true);
        }
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        if (this.documentType == 1) {
            ((StringBuilder)charSequence).append(this.documentNumber);
            ((StringBuilder)charSequence).append(this.documentNumberCheckDigit);
            ((StringBuilder)charSequence).append(MRZInfo.mrzFormat(this.optionalData1, 15));
            ((StringBuilder)charSequence).append(this.dateOfBirth);
            ((StringBuilder)charSequence).append(this.dateOfBirthCheckDigit);
            ((StringBuilder)charSequence).append(this.dateOfExpiry);
            ((StringBuilder)charSequence).append(this.dateOfExpiryCheckDigit);
            ((StringBuilder)charSequence).append(MRZInfo.mrzFormat(this.optionalData2, 11));
        } else {
            ((StringBuilder)charSequence).append(this.documentNumber);
            ((StringBuilder)charSequence).append(this.documentNumberCheckDigit);
            ((StringBuilder)charSequence).append(this.dateOfBirth);
            ((StringBuilder)charSequence).append(this.dateOfBirthCheckDigit);
            ((StringBuilder)charSequence).append(this.dateOfExpiry);
            ((StringBuilder)charSequence).append(this.dateOfExpiryCheckDigit);
            ((StringBuilder)charSequence).append(MRZInfo.mrzFormat(this.optionalData1, 15));
        }
        this.compositeCheckDigit = MRZInfo.checkDigit(((StringBuilder)charSequence).toString());
    }

    /*
     * Unable to fully structure code
     */
    public static char checkDigit(String var0, boolean var1_5) {
        block16: {
            block17: {
                if (var0 != null) break block17;
                v0 = new byte[]{};
lbl4:
                // 2 sources

                while (true) {
                    var0 = v0;
                    ** GOTO lbl11
                    break;
                }
            }
            v0 = var0.getBytes("UTF-8");
            ** continue;
lbl11:
            // 1 sources

            v1 = new int[3];
            var2_6 = v1;
            v1[0] = 7;
            v1[1] = 3;
            v1[2] = 1;
            var3_7 = 0;
            var4_8 = 0;
            while (true) {
                if (var4_8 >= ((Object)var0).length) break;
                v2 = var3_7 + var2_6[var4_8 % 3] * MRZInfo.decodeMRZDigit((byte)var0[var4_8]);
                var3_7 = v2 % 10;
                ++var4_8;
                continue;
                break;
            }
            var0 = Integer.toString(var3_7);
            if (var0.length() != 1) break block16;
            var0_1 = var0.getBytes("UTF-8")[0];
            if (var1_5 && var0_1 == 48) {
                var0_1 = 60;
            }
            return (char)var0_1;
        }
        try {
            throw new IllegalStateException("Error in computing check digit.");
        }
        catch (Exception var0_2) {
            throw new IllegalArgumentException("Error in computing check digit", var0_2);
        }
        catch (UnsupportedEncodingException var0_3) {
            throw new IllegalStateException("Error in computing check digit", var0_3);
        }
        catch (NumberFormatException var0_4) {
            throw new IllegalStateException("Error in computing check digit", var0_4);
        }
    }

    /*
     * Exception decompiling
     */
    public static int decodeMRZDigit(byte var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CASE]], but top level block is 40[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        DataOutputStream dataOutputStream;
        MRZInfo mRZInfo = this;
        DataOutputStream dataOutputStream2 = dataOutputStream;
        mRZInfo.writeDocumentType(new DataOutputStream(outputStream));
        if (mRZInfo.documentType == 1) {
            MRZInfo mRZInfo2 = this;
            mRZInfo2.writeIssuingState(dataOutputStream2);
            if (mRZInfo2.documentNumber.length() > 9 && MRZInfo.equalsModuloFillerChars(this.optionalData1, "")) {
                MRZInfo mRZInfo3 = this;
                mRZInfo3.writeString(mRZInfo3.documentNumber.substring(0, 9), dataOutputStream2, 9);
                dataOutputStream2.write(60);
                String string = this.documentNumber;
                this.writeString(string.substring(9, string.length()) + this.documentNumberCheckDigit + "<", dataOutputStream2, 15);
            } else {
                MRZInfo mRZInfo4 = this;
                MRZInfo mRZInfo5 = this;
                mRZInfo5.writeString(mRZInfo5.documentNumber, dataOutputStream2, 9);
                dataOutputStream2.write(mRZInfo5.documentNumberCheckDigit);
                mRZInfo4.writeString(mRZInfo4.optionalData1, dataOutputStream2, 15);
            }
            DataOutputStream dataOutputStream3 = dataOutputStream2;
            MRZInfo mRZInfo6 = this;
            DataOutputStream dataOutputStream4 = dataOutputStream2;
            MRZInfo mRZInfo7 = this;
            DataOutputStream dataOutputStream5 = dataOutputStream2;
            MRZInfo mRZInfo8 = this;
            mRZInfo8.writeDateOfBirth(dataOutputStream2);
            dataOutputStream5.write(mRZInfo8.dateOfBirthCheckDigit);
            this.writeGender(dataOutputStream5);
            mRZInfo7.writeDateOfExpiry(dataOutputStream2);
            dataOutputStream4.write(mRZInfo7.dateOfExpiryCheckDigit);
            mRZInfo6.writeNationality(dataOutputStream4);
            mRZInfo6.writeString(mRZInfo6.optionalData2, dataOutputStream2, 11);
            dataOutputStream3.write(mRZInfo6.compositeCheckDigit);
            this.writeName(dataOutputStream3, 30);
        } else {
            MRZInfo mRZInfo9 = this;
            MRZInfo mRZInfo10 = this;
            DataOutputStream dataOutputStream6 = dataOutputStream2;
            MRZInfo mRZInfo11 = this;
            DataOutputStream dataOutputStream7 = dataOutputStream2;
            MRZInfo mRZInfo12 = this;
            this.writeIssuingState(dataOutputStream2);
            mRZInfo12.writeName(dataOutputStream2, 39);
            mRZInfo12.writeString(mRZInfo12.documentNumber, dataOutputStream2, 9);
            dataOutputStream7.write(mRZInfo12.documentNumberCheckDigit);
            this.writeNationality(dataOutputStream7);
            mRZInfo11.writeDateOfBirth(dataOutputStream2);
            dataOutputStream6.write(mRZInfo11.dateOfBirthCheckDigit);
            this.writeGender(dataOutputStream6);
            mRZInfo10.writeDateOfExpiry(dataOutputStream2);
            dataOutputStream2.write(mRZInfo10.dateOfExpiryCheckDigit);
            mRZInfo9.writeString(mRZInfo9.optionalData1, dataOutputStream2, 15);
            dataOutputStream2.write(mRZInfo9.compositeCheckDigit);
        }
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String string) {
        this.dateOfBirth = string;
        this.checkDigit();
    }

    public String getDateOfExpiry() {
        return this.dateOfExpiry;
    }

    public void setDateOfExpiry(String string) {
        this.dateOfExpiry = string;
        this.checkDigit();
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String string) {
        this.documentNumber = string.trim();
        this.checkDigit();
    }

    public int getDocumentType() {
        return this.documentType;
    }

    public String getDocumentCode() {
        return this.documentCode;
    }

    public void setDocumentCode(String string) {
        this.documentCode = string;
        this.documentType = MRZInfo.getDocumentTypeFromDocumentCode(string);
        if (this.documentType == 1 && this.optionalData2 == null) {
            this.optionalData2 = "";
        }
    }

    public String getIssuingState() {
        return this.issuingState;
    }

    public void setIssuingState(String string) {
        this.issuingState = string;
        this.checkDigit();
    }

    public String getPrimaryIdentifier() {
        return this.primaryIdentifier;
    }

    public void setPrimaryIdentifier(String string) {
        this.primaryIdentifier = string.trim();
        this.checkDigit();
    }

    public String getSecondaryIdentifier() {
        return this.secondaryIdentifier;
    }

    public String[] getSecondaryIdentifierComponents() {
        return this.secondaryIdentifier.split(" |<");
    }

    public void setSecondaryIdentifierComponents(String[] stringArray) {
        if (stringArray == null) {
            this.secondaryIdentifier = null;
        } else {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringBuilder2.append(stringArray[i2]);
                if (i2 >= stringArray.length - 1) continue;
                stringBuilder2.append('<');
            }
        }
        this.checkDigit();
    }

    public void setSecondaryIdentifiers(String string) {
        MRZInfo mRZInfo = this;
        mRZInfo.readSecondaryIdentifiers(string.trim());
        mRZInfo.checkDigit();
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String string) {
        this.nationality = string;
        this.checkDigit();
    }

    public String getPersonalNumber() {
        return this.optionalData1.length() > 14 ? MRZInfo.trimFillerChars(this.optionalData1.substring(0, 14)) : MRZInfo.trimFillerChars(this.optionalData1);
    }

    public void setPersonalNumber(String string) {
        if (string != null && string.length() <= 14) {
            this.optionalData1 = MRZInfo.mrzFormat(string, 14) + MRZInfo.checkDigit(string, true);
            return;
        }
        throw new IllegalArgumentException("Wrong personal number");
    }

    public String getOptionalData1() {
        return this.optionalData1;
    }

    public String getOptionalData2() {
        return this.optionalData2;
    }

    public void setOptionalData2(String string) {
        this.optionalData2 = MRZInfo.trimFillerChars(string);
        this.checkDigit();
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.checkDigit();
    }

    public String toString() {
        String string;
        block6: {
            block7: {
                String string2;
                string = string2;
                try {
                    int n2 = new String(this.getEncoded(), "UTF-8").length();
                    if (n2 == 88) break block6;
                    if (n2 == 90) break block7;
                    return string;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException(unsupportedEncodingException);
                }
            }
            return string.substring(0, 30) + "\n" + string.substring(30, 60) + "\n" + string.substring(60, 90) + "\n";
        }
        return string.substring(0, 44) + "\n" + string.substring(44, 88) + "\n";
    }

    public int hashCode() {
        return this.toString().hashCode() * 2 + 53;
    }

    public boolean equals(Object object) {
        String string;
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(MRZInfo.class)) {
            return false;
        }
        object = (MRZInfo)object;
        return (((MRZInfo)this).documentCode == null && ((MRZInfo)object).documentCode == null || (string = ((MRZInfo)this).documentCode) != null && string.equals(((MRZInfo)object).documentCode)) && (((MRZInfo)this).issuingState == null && ((MRZInfo)object).issuingState == null || (string = ((MRZInfo)this).issuingState) != null && string.equals(((MRZInfo)object).issuingState)) && (((MRZInfo)this).primaryIdentifier == null && ((MRZInfo)object).primaryIdentifier == null || (string = ((MRZInfo)this).primaryIdentifier) != null && string.equals(((MRZInfo)object).primaryIdentifier)) && (((MRZInfo)this).secondaryIdentifier == null && ((MRZInfo)object).secondaryIdentifier == null || MRZInfo.equalsModuloFillerChars(((MRZInfo)this).secondaryIdentifier, ((MRZInfo)object).secondaryIdentifier)) && (((MRZInfo)this).nationality == null && ((MRZInfo)object).nationality == null || (string = ((MRZInfo)this).nationality) != null && string.equals(((MRZInfo)object).nationality)) && (((MRZInfo)this).documentNumber == null && ((MRZInfo)object).documentNumber == null || (string = ((MRZInfo)this).documentNumber) != null && string.equals(((MRZInfo)object).documentNumber)) && (((MRZInfo)this).optionalData1 == null && ((MRZInfo)object).optionalData1 == null || (string = ((MRZInfo)this).optionalData1) != null && string.equals(((MRZInfo)object).optionalData1) || ((MRZInfo)this).getPersonalNumber().equals(((MRZInfo)object).getPersonalNumber())) && (((MRZInfo)this).dateOfBirth == null && ((MRZInfo)object).dateOfBirth == null || (string = ((MRZInfo)this).dateOfBirth) != null && string.equals(((MRZInfo)object).dateOfBirth)) && (((MRZInfo)this).gender == null && ((MRZInfo)object).gender == null || (string = ((MRZInfo)this).gender) != null && string.equals((Object)((MRZInfo)object).gender)) && (((MRZInfo)this).dateOfExpiry == null && ((MRZInfo)object).dateOfExpiry == null || (string = ((MRZInfo)this).dateOfExpiry) != null && string.equals(((MRZInfo)object).dateOfExpiry)) && (((MRZInfo)this).optionalData2 == null && ((MRZInfo)object).optionalData2 == null || (this = ((MRZInfo)this).optionalData2) != null && MRZInfo.equalsModuloFillerChars((String)this, ((MRZInfo)object).optionalData2));
    }
}

