/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.dialog;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.dtf.face.nfc.NFCConst;
import com.dtf.face.nfc.R;
import com.dtf.face.nfc.ui.NfcReadActivity;
import com.dtf.face.nfc.ui.anim.NfcReadingStatusAnimView;

public class NfcReadStatusDialog
extends FrameLayout {
    private NfcReadActivity mActivity;
    private ImageView ivReadStatus;
    private NfcReadingStatusAnimView nfcReadingStatusAnimView;
    private Button btnCancel;
    private TextView txtResult;
    private TextView txtSecondCount;
    private TextView txtTitle;
    private int countDowntime;

    public NfcReadStatusDialog(Context context, AttributeSet animatorSet) {
        super(context, animatorSet);
        LayoutInflater.from((Context)context).inflate(R.layout.dtf_dialog_nfc_read, (ViewGroup)this);
    }

    public void init(NfcReadActivity nfcReadActivity, int countDowntime) {
        this.mActivity = nfcReadActivity;
        this.countDowntime = countDowntime;
        this.btnCancel = this.getCancelBtn();
        if (null != this.btnCancel) {
            this.btnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != NfcReadStatusDialog.this.mActivity) {
                        NfcReadStatusDialog.this.mActivity.readCancel();
                    }
                    NfcReadStatusDialog.this.setVisibility(4);
                }
            });
        }
    }

    private NfcReadingStatusAnimView getNfcReadingStatusAnimView() {
        if (null == this.nfcReadingStatusAnimView) {
            this.nfcReadingStatusAnimView = (NfcReadingStatusAnimView)this.findViewById(R.id.view_anim);
        }
        return this.nfcReadingStatusAnimView;
    }

    private void setReadStatusImg(int resourceId) {
        this.ivReadStatus = this.getReadStatusImg();
        if (null != this.ivReadStatus) {
            this.ivReadStatus.setImageDrawable(this.mActivity.getResources().getDrawable(resourceId));
        }
    }

    private ImageView getReadStatusImg() {
        if (null == this.ivReadStatus) {
            this.ivReadStatus = (ImageView)this.findViewById(R.id.iv_read_status);
        }
        return this.ivReadStatus;
    }

    private TextView getTitle() {
        if (null == this.txtTitle) {
            this.txtTitle = (TextView)this.findViewById(R.id.txt_title);
        }
        return this.txtTitle;
    }

    private Button getCancelBtn() {
        if (null == this.btnCancel) {
            this.btnCancel = (Button)this.findViewById(R.id.btn_cancel);
        }
        return this.btnCancel;
    }

    private TextView getSecondCount() {
        if (null == this.txtSecondCount) {
            this.txtSecondCount = (TextView)this.findViewById(R.id.txt_time_count);
        }
        return this.txtSecondCount;
    }

    private TextView getReadResult() {
        if (null == this.txtResult) {
            this.txtResult = (TextView)this.findViewById(R.id.txt_read_result);
        }
        return this.txtResult;
    }

    private void setTextViewText(TextView textView, String txt) {
        if (null != textView) {
            textView.setText((CharSequence)txt);
        }
    }

    public void setViewVisibility(View view, int visibility) {
        if (null != view) {
            view.setVisibility(visibility);
        }
    }

    public void setDialogStatus(int status) {
        this.setDialogStatus(status, "");
    }

    public void setDialogStatus(int status, String errMsg) {
        if (status < NFCConst.NFC_READ_STATUS_SUCCESS) {
            this.setTextViewText(this.getSecondCount(), status == NFCConst.NFC_READ_STATUS_START ? this.mActivity.getResources().getString(R.string.dtf_nfc_reading_do_not_move) : String.format(this.mActivity.getResources().getString(R.string.dtf_nfc_put_card_right_here), this.countDowntime));
        } else if (status == NFCConst.NFC_READ_STATUS_SUCCESS) {
            this.setReadStatusImg(R.mipmap.dtf_read_success);
            this.setTextViewText(this.getReadResult(), this.mActivity.getResources().getString(R.string.dtf_nfc_read_success));
        } else {
            this.setReadStatusImg(R.mipmap.dtf_read_error);
            this.setTextViewText(this.getReadResult(), errMsg);
        }
        boolean isWaitingResult = status < NFCConst.NFC_READ_STATUS_SUCCESS;
        this.setViewVisibility((View)this.getCancelBtn(), isWaitingResult ? 0 : 4);
        this.setViewVisibility((View)this.getSecondCount(), isWaitingResult ? 0 : 4);
        this.setViewVisibility((View)this.getReadResult(), isWaitingResult ? 4 : 0);
        this.setViewVisibility((View)this.getTitle(), isWaitingResult ? 0 : 4);
        this.setViewVisibility((View)this.getNfcReadingStatusAnimView(), isWaitingResult ? 0 : 4);
        this.setViewVisibility((View)this.getReadStatusImg(), isWaitingResult ? 4 : 0);
    }
}

