/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.ui.widget.wheelpiker;

import android.content.Context;
import android.util.AttributeSet;
import com.dtf.face.nfc.ui.widget.wheelpiker.IWheelYearPicker;
import com.dtf.face.nfc.ui.widget.wheelpiker.WheelPicker;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WheelYearPicker
extends WheelPicker
implements IWheelYearPicker {
    private int mYearStart = 1900;
    private int mYearEnd = 2100;
    private int mSelectedYear;

    public WheelYearPicker(Context context) {
        this(context, null);
    }

    public WheelYearPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.updateYears();
        this.mSelectedYear = Calendar.getInstance().get(1);
        this.updateSelectedYear();
    }

    private void updateYears() {
        ArrayList<Integer> data = new ArrayList<Integer>();
        for (int i = this.mYearStart; i <= this.mYearEnd; ++i) {
            data.add(i);
        }
        super.setData(data);
    }

    private void updateSelectedYear() {
        this.setSelectedItemPosition(this.mSelectedYear - this.mYearStart);
    }

    @Override
    public void setData(List data) {
        throw new UnsupportedOperationException("You can not invoke setData in WheelYearPicker");
    }

    @Override
    public void setYearFrame(int start, int end) {
        this.mYearStart = start;
        this.mYearEnd = end;
        this.mSelectedYear = this.getCurrentYear();
        this.updateYears();
        this.updateSelectedYear();
    }

    @Override
    public int getYearStart() {
        return this.mYearStart;
    }

    @Override
    public void setYearStart(int start) {
        this.mYearStart = start;
        this.mSelectedYear = this.getCurrentYear();
        this.updateYears();
        this.updateSelectedYear();
    }

    @Override
    public int getYearEnd() {
        return this.mYearEnd;
    }

    @Override
    public void setYearEnd(int end) {
        this.mYearEnd = end;
        this.updateYears();
    }

    @Override
    public int getSelectedYear() {
        return this.mSelectedYear;
    }

    @Override
    public void setSelectedYear(int year) {
        this.mSelectedYear = year;
        this.updateSelectedYear();
    }

    @Override
    public int getCurrentYear() {
        return Integer.parseInt(String.valueOf(this.getData().get(this.getCurrentItemPosition())));
    }
}

