/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.os.Parcel;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class LenovoImpl
implements IOAID {
    private final Context context;

    public LenovoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm != null) {
                PackageInfo pi = pm.getPackageInfo("com.zui.deviceidservice", 0);
                return pi != null;
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return false;
    }

    @Override
    public void doGet(final IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        Intent intent = new Intent();
        intent.setClassName("com.zui.deviceidservice", "com.zui.deviceidservice.DeviceidService");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    LogUtil.d("Lenovo DeviceidService connected");
                    try {
                        Parcel obtain = Parcel.obtain();
                        Parcel obtain2 = Parcel.obtain();
                        try {
                            String oaid = null;
                            obtain.writeInterfaceToken("com.zui.deviceidservice.IDeviceidInterface");
                            if (service.transact(4, obtain, obtain2, 0)) {
                                obtain2.readException();
                                oaid = obtain2.readString();
                            }
                            if (oaid == null || oaid.length() == 0) {
                                throw new RuntimeException("Lenovo deviceId get failed");
                            }
                            getter.onOAIDGetComplete(oaid);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            obtain2.recycle();
                            obtain.recycle();
                            LenovoImpl.this.context.unbindService((ServiceConnection)this);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.e(e.toString());
                        getter.onOAIDGetError(e);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    LogUtil.e("Lenovo DeviceidService disconnected");
                }
            }, 1);
            if (!isBinded) {
                getter.onOAIDGetError(new RuntimeException("Lenovo DeviceidService bind failed"));
            }
        }
        catch (Exception e) {
            getter.onOAIDGetError(e);
        }
    }
}

