/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cbeff;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.cbeff.BiometricDataBlockDecoder;
import org.jmrtd.cbeff.CBEFFInfo;
import org.jmrtd.cbeff.ComplexCBEFFInfo;
import org.jmrtd.cbeff.ISO781611;
import org.jmrtd.cbeff.SimpleCBEFFInfo;
import org.jmrtd.cbeff.StandardBiometricHeader;

public class ISO781611Decoder
implements ISO781611 {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public BiometricDataBlockDecoder<?> bdbDecoder;

    public ISO781611Decoder(BiometricDataBlockDecoder<?> biometricDataBlockDecoder) {
        this.bdbDecoder = biometricDataBlockDecoder;
    }

    private ComplexCBEFFInfo readBITGroup(InputStream inputStream) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n2 = tLVInputStream.readTag();
        if (n2 == 32609) {
            return this.readBITGroup(n2, tLVInputStream.readLength(), inputStream);
        }
        throw new IllegalArgumentException("Expected tag " + Integer.toHexString(32609) + ", found " + Integer.toHexString(n2));
    }

    private ComplexCBEFFInfo readBITGroup(int n2, int n3, InputStream inputStream) {
        ComplexCBEFFInfo complexCBEFFInfo;
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        ComplexCBEFFInfo complexCBEFFInfo2 = complexCBEFFInfo;
        complexCBEFFInfo = new ComplexCBEFFInfo();
        if (n2 == 32609) {
            n2 = tLVInputStream.readTag();
            if (n2 == 2) {
                n2 = tLVInputStream.readLength();
                if (n2 == 1) {
                    n2 = tLVInputStream.readValue()[0] & 0xFF;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        complexCBEFFInfo2.add(this.readBIT(inputStream, i2));
                    }
                    return complexCBEFFInfo2;
                }
                throw new IllegalArgumentException("BIOMETRIC_INFO_COUNT should have length 1, found length " + n2);
            }
            throw new IllegalArgumentException("Expected tag BIOMETRIC_INFO_COUNT_TAG (" + Integer.toHexString(2) + ") in CBEFF structure, found " + Integer.toHexString(n2));
        }
        throw new IllegalArgumentException("Expected tag " + Integer.toHexString(32609) + ", found " + Integer.toHexString(n2));
    }

    private CBEFFInfo readBIT(InputStream inputStream, int n2) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        return this.readBIT(tLVInputStream.readTag(), tLVInputStream.readLength(), inputStream, n2);
    }

    private CBEFFInfo readBIT(int n2, int n3, InputStream inputStream, int n4) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        if (n2 == 32608) {
            n2 = tLVInputStream.readTag();
            int n5 = tLVInputStream.readLength();
            if (n2 == 125) {
                ((ISO781611Decoder)((Object)biometricDataBlock)).readStaticallyProtectedBIT(inputStream, n2, n5, n4);
                return null;
            }
            if ((n2 & 0xA0) == 160) {
                BiometricDataBlock biometricDataBlock = ((ISO781611Decoder)((Object)biometricDataBlock)).readBiometricDataBlock(inputStream, ((ISO781611Decoder)((Object)biometricDataBlock)).readBHT(inputStream, n2, n5, n4), n4);
                return new SimpleCBEFFInfo<Object>(biometricDataBlock);
            }
            throw new IllegalArgumentException("Unsupported template tag: " + Integer.toHexString(n2));
        }
        throw new IllegalArgumentException("Expected tag BIOMETRIC_INFORMATION_TEMPLATE_TAG (" + Integer.toHexString(32608) + "), found " + Integer.toHexString(n2) + ", index is " + n4);
    }

    private StandardBiometricHeader readBHT(InputStream inputStream, int n2, int n3, int n4) {
        HashMap<Integer, byte[]> hashMap;
        ISO781611Decoder iSO781611Decoder;
        if (inputStream instanceof TLVInputStream) {
            iSO781611Decoder = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            iSO781611Decoder = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n5 = 161;
        if (n2 != 161) {
            LOGGER.warning("Expected tag " + Integer.toHexString(n5) + ", found " + Integer.toHexString(n2));
        }
        HashMap<Integer, byte[]> hashMap2 = hashMap;
        hashMap = new HashMap<Integer, byte[]>();
        n2 = 0;
        while (n2 < n3) {
            int n6 = iSO781611Decoder.readTag();
            byte[] byArray = iSO781611Decoder.readValue();
            n4 = n2 + TLVUtil.getTagLength((int)n6) + TLVUtil.getLengthLength((int)iSO781611Decoder.readLength()) + byArray.length;
            hashMap2.put(n6, byArray);
            n2 = n4;
        }
        return new StandardBiometricHeader(hashMap2);
    }

    private void readStaticallyProtectedBIT(InputStream inputStream, int n2, int n3, int n4) {
        ByteArrayInputStream byteArrayInputStream;
        StandardBiometricHeader standardBiometricHeader;
        TLVInputStream tLVInputStream;
        TLVInputStream tLVInputStream2 = tLVInputStream;
        ISO781611Decoder iSO781611Decoder = this;
        TLVInputStream tLVInputStream3 = tLVInputStream2;
        tLVInputStream3((InputStream)new ByteArrayInputStream(this.decodeSMTValue(inputStream)));
        try {
            standardBiometricHeader = iSO781611Decoder.readBHT((InputStream)tLVInputStream3, tLVInputStream3.readTag(), tLVInputStream2.readLength(), n4);
        }
        catch (Throwable throwable) {
            tLVInputStream2.close();
            throw throwable;
        }
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream2(this.decodeSMTValue(inputStream));
        iSO781611Decoder.readBiometricDataBlock(byteArrayInputStream, standardBiometricHeader, n4);
        tLVInputStream.close();
    }

    private byte[] decodeSMTValue(InputStream inputStream) {
        ISO781611Decoder iSO781611Decoder;
        if (inputStream instanceof TLVInputStream) {
            iSO781611Decoder = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream;
            iSO781611Decoder = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        int n2 = iSO781611Decoder.readTag();
        int n3 = iSO781611Decoder.readLength();
        if (n2 != 129) {
            if (n2 != 133) {
                long l2;
                if (n2 != 142) {
                    long l3;
                    if (n2 != 158) {
                        LOGGER.info("Unsupported data object tag " + Integer.toHexString(n2));
                        return null;
                    }
                    for (long i2 = 0L; i2 < (l3 = (long)n3); i2 += iSO781611Decoder.skip(l3)) {
                    }
                    return null;
                }
                for (long i3 = 0L; i3 < (l2 = (long)n3); i3 += iSO781611Decoder.skip(l2)) {
                }
                return null;
            }
            throw new AccessControlException("Access denied. Biometric Information Template is statically protected.");
        }
        return iSO781611Decoder.readValue();
    }

    private BiometricDataBlock readBiometricDataBlock(InputStream inputStream, StandardBiometricHeader standardBiometricHeader, int n2) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n3 = tLVInputStream.readTag();
        if (n3 != 24366 && n3 != 32558) {
            throw new IllegalArgumentException("Expected tag BIOMETRIC_DATA_BLOCK_TAG (" + Integer.toHexString(24366) + ") or BIOMETRIC_DATA_BLOCK_TAG_ALT (" + Integer.toHexString(32558) + "), found " + Integer.toHexString(n3));
        }
        int n4 = tLVInputStream.readLength();
        return this.bdbDecoder.decode(inputStream, standardBiometricHeader, n2, n4);
    }

    public ComplexCBEFFInfo decode(InputStream inputStream) {
        return this.readBITGroup(inputStream);
    }
}

