/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1InputStream;
import org.eid_bc.bouncycastle.asn1.ASN1Object;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1OctetString;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.ASN1Sequence;
import org.eid_bc.bouncycastle.asn1.ASN1Set;
import org.eid_bc.bouncycastle.asn1.ASN1TaggedObject;
import org.eid_bc.bouncycastle.asn1.DEROctetString;
import org.eid_bc.bouncycastle.asn1.DERTaggedObject;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.eid_bc.bouncycastle.asn1.DLSet;
import org.eid_bc.bouncycastle.asn1.cms.Attribute;
import org.eid_bc.bouncycastle.asn1.cms.ContentInfo;
import org.eid_bc.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.eid_bc.bouncycastle.asn1.cms.SignedData;
import org.eid_bc.bouncycastle.asn1.cms.SignerIdentifier;
import org.eid_bc.bouncycastle.asn1.cms.SignerInfo;
import org.eid_bc.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.eid_bc.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.eid_bc.bouncycastle.asn1.x500.X500Name;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.Certificate;
import org.eid_bc.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.jmrtd.Util;

public final class SignedDataUtil {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String RFC_3369_SIGNED_DATA_OID = "1.2.840.113549.1.7.2";
    public static final String RFC_3369_CONTENT_TYPE_OID = "1.2.840.113549.1.9.3";
    public static final String RFC_3369_MESSAGE_DIGEST_OID = "1.2.840.113549.1.9.4";
    public static final String PKCS1_RSA_OID = "1.2.840.113549.1.1.1";
    public static final String PKCS1_MD2_WITH_RSA_OID = "1.2.840.113549.1.1.2";
    public static final String PKCS1_MD4_WITH_RSA_OID = "1.2.840.113549.1.1.3";
    public static final String PKCS1_MD5_WITH_RSA_OID = "1.2.840.113549.1.1.4";
    public static final String PKCS1_SHA1_WITH_RSA_OID = "1.2.840.113549.1.1.5";
    public static final String PKCS1_MGF1 = "1.2.840.113549.1.1.8";
    public static final String PKCS1_RSASSA_PSS_OID = "1.2.840.113549.1.1.10";
    public static final String PKCS1_SHA256_WITH_RSA_OID = "1.2.840.113549.1.1.11";
    public static final String PKCS1_SHA384_WITH_RSA_OID = "1.2.840.113549.1.1.12";
    public static final String PKCS1_SHA512_WITH_RSA_OID = "1.2.840.113549.1.1.13";
    public static final String PKCS1_SHA224_WITH_RSA_OID = "1.2.840.113549.1.1.14";
    public static final String X9_SHA1_WITH_ECDSA_OID = "1.2.840.10045.4.1";
    public static final String X9_SHA224_WITH_ECDSA_OID = "1.2.840.10045.4.3.1";
    public static final String X9_SHA256_WITH_ECDSA_OID = "1.2.840.10045.4.3.2";
    public static final String X9_SHA384_WITH_ECDSA_OID = "1.2.840.10045.4.3.3";
    public static final String X9_SHA512_WITH_ECDSA_OID = "1.2.840.10045.4.3.4";
    public static final String IEEE_P1363_SHA1_OID = "1.3.14.3.2.26";

    public static SignedData readSignedData(InputStream inputStream) {
        if ((inputStream = (ASN1Sequence)new ASN1InputStream(inputStream).readObject()).size() == 2) {
            String string = ((ASN1ObjectIdentifier)inputStream.getObjectAt(0)).getId();
            if (RFC_3369_SIGNED_DATA_OID.equals(string)) {
                if ((inputStream = SignedDataUtil.getObjectFromTaggedObject(inputStream.getObjectAt(1))) instanceof ASN1Sequence) {
                    return SignedData.getInstance((Object)inputStream);
                }
                throw new IOException("Was expecting an ASN.1 sequence as content");
            }
            throw new IOException("Was expecting signed-data content type OID (1.2.840.113549.1.7.2), found " + string);
        }
        throw new IOException("Was expecting a DER sequence of length 2, found a DER sequence of length " + inputStream.size());
    }

    public static void writeData(SignedData signedData, OutputStream outputStream) {
        ASN1EncodableVector aSN1EncodableVector;
        OutputStream outputStream2 = outputStream;
        outputStream = aSN1EncodableVector;
        new ASN1EncodableVector().add((ASN1Encodable)new ASN1ObjectIdentifier(RFC_3369_SIGNED_DATA_OID));
        outputStream.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)signedData));
        outputStream2.write(new DLSequence((ASN1EncodableVector)outputStream).getEncoded("DER"));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static ASN1Primitive getContent(SignedData signedData) {
        void var0_6;
        ASN1InputStream aSN1InputStream;
        block16: {
            block17: {
                block15: {
                    ASN1InputStream aSN1InputStream2;
                    signedData = (DEROctetString)signedData.getEncapContentInfo().getContent();
                    Object var1_7 = null;
                    aSN1InputStream = aSN1InputStream2;
                    aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(signedData.getOctets()));
                    signedData = aSN1InputStream2.readObject();
                    try {
                        aSN1InputStream2.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.FINE, "Exception closing input stream", iOException);
                    }
                    return signedData;
                    catch (IOException iOException) {
                        break block15;
                    }
                    catch (Throwable throwable) {
                        aSN1InputStream = var1_7;
                        break block16;
                    }
                    catch (IOException iOException) {
                        aSN1InputStream = var1_7;
                    }
                }
                LOGGER.log(Level.WARNING, "Unexpected exception", (Throwable)signedData);
                if (aSN1InputStream == null) break block17;
                try {
                    aSN1InputStream.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, "Exception closing input stream", iOException);
                }
            }
            return null;
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (aSN1InputStream != null) {
            try {
                aSN1InputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Exception closing input stream", iOException);
            }
        }
        throw var0_6;
    }

    public static ASN1Primitive getObjectFromTaggedObject(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            int n2 = (aSN1Encodable = (ASN1TaggedObject)aSN1Encodable).getTagNo();
            if (n2 == 0) {
                return aSN1Encodable.getObject();
            }
            throw new IOException("Was expecting tag 0, found " + Integer.toHexString(n2));
        }
        throw new IOException("Was expecting an ASN1TaggedObject, found " + aSN1Encodable.getClass().getCanonicalName());
    }

    public static String getSignerInfoDigestAlgorithm(SignedData signedData) {
        try {
            return SignedDataUtil.lookupMnemonicByOID(SignedDataUtil.getSignerInfo(signedData).getDigestAlgorithm().getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "No such algorithm" + noSuchAlgorithmException);
            return null;
        }
    }

    public static AlgorithmParameterSpec getDigestEncryptionAlgorithmParams(SignedData signedData) {
        block4: {
            AlgorithmIdentifier algorithmIdentifier = SignedDataUtil.getSignerInfo(signedData).getDigestEncryptionAlgorithm();
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            signedData = algorithmIdentifier.getParameters();
            if (!PKCS1_RSASSA_PSS_OID.equals(algorithmIdentifier2.getAlgorithm().getId())) break block4;
            try {
                return SignedDataUtil.toAlgorithmParameterSpec(RSASSAPSSparams.getInstance((Object)signedData));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
            }
        }
        return null;
    }

    public static String getDigestEncryptionAlgorithm(SignedData object) {
        block4: {
            try {
                object = SignedDataUtil.getSignerInfo(object).getDigestEncryptionAlgorithm().getAlgorithm().getId();
                if (object != null) break block4;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.log(Level.WARNING, "No such algorithm", noSuchAlgorithmException);
                return null;
            }
            LOGGER.warning("Could not determine digest encryption algorithm OID");
            return null;
        }
        return SignedDataUtil.lookupMnemonicByOID((String)object);
    }

    public static byte[] getEContent(SignedData object) {
        Object object2 = SignedDataUtil.getSignerInfo(object);
        Object object3 = object2.getAuthenticatedAttributes();
        object = ((DEROctetString)object.getEncapContentInfo().getContent()).getOctets();
        if (object3.size() == 0) {
            return object;
        }
        ASN1Set aSN1Set = object3;
        SignerInfo signerInfo = object2;
        object2 = null;
        object3 = signerInfo.getDigestAlgorithm().getAlgorithm().getId();
        object2 = aSN1Set.getEncoded("DER");
        try {
            SignedDataUtil.checkEContent(SignedDataUtil.getAttributes(aSN1Set), (String)object3, (byte[])object);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Error getting signedAttributes", iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "Error checking signedAttributes in eContent! No such algorithm: \"" + (String)object3, noSuchAlgorithmException);
        }
        return object2;
    }

    public static byte[] getEncryptedDigest(SignedData signedData) {
        return SignedDataUtil.getSignerInfo(signedData).getEncryptedDigest().getOctets();
    }

    public static IssuerAndSerialNumber getIssuerAndSerialNumber(SignedData signedData) {
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)SignedDataUtil.getSignerInfo(signedData).getSID().getId());
        signedData = issuerAndSerialNumber.getName();
        BigInteger bigInteger = issuerAndSerialNumber.getSerialNumber().getValue();
        return new IssuerAndSerialNumber((X500Name)signedData, bigInteger);
    }

    public static X509Certificate getDocSigningCertificate(SignedData object) {
        if ((object = SignedDataUtil.getCertificates((SignedData)object)) != null && !object.isEmpty()) {
            int n2 = object.size();
            if (n2 != 1) {
                LOGGER.warning("Found " + n2 + " certificates, interpreting last one as document signer certificate");
            }
            return (X509Certificate)object.get(n2 - 1);
        }
        return null;
    }

    public static List<X509Certificate> getCertificates(SignedData signedData) {
        ArrayList<X509Certificate> arrayList;
        int n2 = (signedData = signedData.getCertificates()) == null ? 0 : signedData.size();
        ArrayList<X509Certificate> arrayList2 = arrayList;
        arrayList = new ArrayList<X509Certificate>(n2);
        if (n2 <= 0) {
            return arrayList2;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                arrayList2.add(SignedDataUtil.decodeCertificate(Certificate.getInstance((Object)signedData.getObjectAt(i2))));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception in decoding certificate", exception);
            }
            continue;
        }
        return arrayList2;
    }

    public static X509Certificate decodeCertificate(Certificate object) {
        object = object.getEncoded("DER");
        return (X509Certificate)CertificateFactory.getInstance("X.509", Util.getBouncyCastleProvider()).generateCertificate(new ByteArrayInputStream((byte[])object));
    }

    public static SignedData createSignedData(String string, String string2, String string3, ContentInfo contentInfo, byte[] byArray, X509Certificate x509Certificate) {
        String string4 = string;
        String string5 = string2;
        X509Certificate x509Certificate2 = x509Certificate;
        string = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createDigestAlgorithms(string));
        string2 = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createCertificate(x509Certificate2));
        string3 = SignedDataUtil.createSingletonSet((ASN1Object)SignedDataUtil.createSignerInfo(string4, string5, string3, contentInfo, byArray, x509Certificate2).toASN1Primitive());
        return new SignedData((ASN1Set)string, contentInfo, (ASN1Set)string2, null, (ASN1Set)string3);
    }

    public static SignerInfo createSignerInfo(String string, String string2, String object, ContentInfo contentInfo, byte[] byArray, X509Certificate x509Certificate) {
        DEROctetString dEROctetString;
        AlgorithmIdentifier algorithmIdentifier;
        AlgorithmIdentifier algorithmIdentifier2;
        SignerIdentifier signerIdentifier;
        X500Name x500Name;
        String string3 = string;
        String string4 = object;
        ContentInfo contentInfo2 = contentInfo;
        X509Certificate x509Certificate2 = x509Certificate;
        object = x509Certificate2.getIssuerX500Principal();
        contentInfo = x500Name;
        x500Name = new X500Name(((X500Principal)object).getName("RFC2253"));
        object = x509Certificate2.getSerialNumber();
        x509Certificate = signerIdentifier;
        signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber((X500Name)contentInfo, (BigInteger)object));
        object = algorithmIdentifier2;
        algorithmIdentifier2 = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(string)));
        string = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(string2)));
        string2 = SignedDataUtil.createAuthenticatedAttributes(string3, string4, contentInfo2);
        contentInfo = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        return new SignerInfo((SignerIdentifier)x509Certificate, (AlgorithmIdentifier)object, (ASN1Set)string2, (AlgorithmIdentifier)string, (ASN1OctetString)contentInfo, null);
    }

    public static ASN1Set createAuthenticatedAttributes(String object, String string, ContentInfo aSN1ObjectArray) {
        Attribute attribute;
        Attribute attribute2;
        DEROctetString dEROctetString;
        if ("SHA256".equals(object)) {
            object = "SHA-256";
        }
        object = Util.getMessageDigest((String)object).digest(((DEROctetString)aSN1ObjectArray.getContent()).getOctets());
        aSN1ObjectArray = dEROctetString;
        dEROctetString = new DEROctetString((byte[])object);
        object = attribute2;
        attribute2 = new Attribute(new ASN1ObjectIdentifier(RFC_3369_CONTENT_TYPE_OID), SignedDataUtil.createSingletonSet((ASN1Object)new ASN1ObjectIdentifier(string)));
        string = attribute;
        attribute = new Attribute(new ASN1ObjectIdentifier(RFC_3369_MESSAGE_DIGEST_OID), SignedDataUtil.createSingletonSet((ASN1Object)aSN1ObjectArray));
        ASN1Object[] aSN1ObjectArray2 = new ASN1Object[2];
        aSN1ObjectArray = aSN1ObjectArray2;
        aSN1ObjectArray[0] = object.toASN1Primitive();
        aSN1ObjectArray2[1] = string.toASN1Primitive();
        return new DLSet((ASN1Encodable[])aSN1ObjectArray);
    }

    public static ASN1Sequence createDigestAlgorithms(String string) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic(string));
        string = aSN1EncodableVector;
        string();
        aSN1EncodableVector.add((ASN1Encodable)aSN1ObjectIdentifier2);
        return new DLSequence((ASN1EncodableVector)string);
    }

    /*
     * Exception decompiling
     */
    public static ASN1Sequence createCertificate(X509Certificate var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] signData(String object, String object2, String string, ContentInfo contentInfo, PrivateKey privateKey, String string2) {
        try {
            object = SignedDataUtil.createAuthenticatedAttributes((String)object, string, contentInfo).getEncoded("DER");
            object2 = string2 != null ? Signature.getInstance((String)object2, string2) : Signature.getInstance((String)object2);
            Object object3 = object2;
            ((Signature)object2).initSign(privateKey);
            ((Signature)object3).update((byte[])object);
            return ((Signature)object3).sign();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Exception", exception);
            return null;
        }
    }

    public static String lookupMnemonicByOID(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(X509ObjectIdentifiers.organization.getId())) {
            return "O";
        }
        if (string.equals(X509ObjectIdentifiers.organizationalUnitName.getId())) {
            return "OU";
        }
        if (string.equals(X509ObjectIdentifiers.commonName.getId())) {
            return "CN";
        }
        if (string.equals(X509ObjectIdentifiers.countryName.getId())) {
            return "C";
        }
        if (string.equals(X509ObjectIdentifiers.stateOrProvinceName.getId())) {
            return "ST";
        }
        if (string.equals(X509ObjectIdentifiers.localityName.getId())) {
            return "L";
        }
        if (string.equals(X509ObjectIdentifiers.id_SHA1.getId())) {
            return "SHA-1";
        }
        if (string.equals(NISTObjectIdentifiers.id_sha224.getId())) {
            return "SHA-224";
        }
        if (string.equals(NISTObjectIdentifiers.id_sha256.getId())) {
            return "SHA-256";
        }
        if (string.equals(NISTObjectIdentifiers.id_sha384.getId())) {
            return "SHA-384";
        }
        if (string.equals(NISTObjectIdentifiers.id_sha512.getId())) {
            return "SHA-512";
        }
        if (string.equals(X9_SHA1_WITH_ECDSA_OID)) {
            return "SHA1withECDSA";
        }
        if (string.equals(X9_SHA224_WITH_ECDSA_OID)) {
            return "SHA224withECDSA";
        }
        if (string.equals(X9_SHA256_WITH_ECDSA_OID)) {
            return "SHA256withECDSA";
        }
        if (string.equals(X9_SHA384_WITH_ECDSA_OID)) {
            return "SHA384withECDSA";
        }
        if (string.equals(X9_SHA512_WITH_ECDSA_OID)) {
            return "SHA512withECDSA";
        }
        if (string.equals(PKCS1_RSA_OID)) {
            return "RSA";
        }
        if (string.equals(PKCS1_MD2_WITH_RSA_OID)) {
            return "MD2withRSA";
        }
        if (string.equals(PKCS1_MD4_WITH_RSA_OID)) {
            return "MD4withRSA";
        }
        if (string.equals(PKCS1_MD5_WITH_RSA_OID)) {
            return "MD5withRSA";
        }
        if (string.equals(PKCS1_SHA1_WITH_RSA_OID)) {
            return "SHA1withRSA";
        }
        if (string.equals(PKCS1_SHA256_WITH_RSA_OID)) {
            return "SHA256withRSA";
        }
        if (string.equals(PKCS1_SHA384_WITH_RSA_OID)) {
            return "SHA384withRSA";
        }
        if (string.equals(PKCS1_SHA512_WITH_RSA_OID)) {
            return "SHA512withRSA";
        }
        if (string.equals(PKCS1_SHA224_WITH_RSA_OID)) {
            return "SHA224withRSA";
        }
        if (string.equals(IEEE_P1363_SHA1_OID)) {
            return "SHA-1";
        }
        if (string.equals(PKCS1_RSASSA_PSS_OID)) {
            return "SSAwithRSA/PSS";
        }
        if (string.equals(PKCS1_MGF1)) {
            return "MGF1";
        }
        throw new NoSuchAlgorithmException("Unknown OID " + string);
    }

    public static String lookupOIDByMnemonic(String string) {
        if ("O".equals(string)) {
            return X509ObjectIdentifiers.organization.getId();
        }
        if ("OU".equals(string)) {
            return X509ObjectIdentifiers.organizationalUnitName.getId();
        }
        if ("CN".equals(string)) {
            return X509ObjectIdentifiers.commonName.getId();
        }
        if ("C".equals(string)) {
            return X509ObjectIdentifiers.countryName.getId();
        }
        if ("ST".equals(string)) {
            return X509ObjectIdentifiers.stateOrProvinceName.getId();
        }
        if ("L".equals(string)) {
            return X509ObjectIdentifiers.localityName.getId();
        }
        if (!"SHA-1".equalsIgnoreCase(string) && !"SHA1".equalsIgnoreCase(string)) {
            if (!"SHA-224".equalsIgnoreCase(string) && !"SHA224".equalsIgnoreCase(string)) {
                if (!"SHA-256".equalsIgnoreCase(string) && !"SHA256".equalsIgnoreCase(string)) {
                    if (!"SHA-384".equalsIgnoreCase(string) && !"SHA384".equalsIgnoreCase(string)) {
                        if (!"SHA-512".equalsIgnoreCase(string) && !"SHA512".equalsIgnoreCase(string)) {
                            if ("RSA".equalsIgnoreCase(string)) {
                                return PKCS1_RSA_OID;
                            }
                            if ("MD2withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_MD2_WITH_RSA_OID;
                            }
                            if ("MD4withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_MD4_WITH_RSA_OID;
                            }
                            if ("MD5withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_MD5_WITH_RSA_OID;
                            }
                            if ("SHA1withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_SHA1_WITH_RSA_OID;
                            }
                            if ("SHA256withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_SHA256_WITH_RSA_OID;
                            }
                            if ("SHA384withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_SHA384_WITH_RSA_OID;
                            }
                            if ("SHA512withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_SHA512_WITH_RSA_OID;
                            }
                            if ("SHA224withRSA".equalsIgnoreCase(string)) {
                                return PKCS1_SHA224_WITH_RSA_OID;
                            }
                            if ("SHA1withECDSA".equalsIgnoreCase(string)) {
                                return X9_SHA1_WITH_ECDSA_OID;
                            }
                            if ("SHA224withECDSA".equalsIgnoreCase(string)) {
                                return X9_SHA224_WITH_ECDSA_OID;
                            }
                            if ("SHA256withECDSA".equalsIgnoreCase(string)) {
                                return X9_SHA256_WITH_ECDSA_OID;
                            }
                            if ("SHA384withECDSA".equalsIgnoreCase(string)) {
                                return X9_SHA384_WITH_ECDSA_OID;
                            }
                            if ("SHA512withECDSA".equalsIgnoreCase(string)) {
                                return X9_SHA512_WITH_ECDSA_OID;
                            }
                            if ("SAwithRSA/PSS".equalsIgnoreCase(string)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("SSAwithRSA/PSS".equalsIgnoreCase(string)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("RSASSA-PSS".equalsIgnoreCase(string)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("MGF1".equalsIgnoreCase(string)) {
                                return PKCS1_MGF1;
                            }
                            if ("SHA256withRSAandMGF1".equalsIgnoreCase(string)) {
                                return PKCS1_MGF1;
                            }
                            if ("SHA512withRSAandMGF1".equalsIgnoreCase(string)) {
                                return PKCS1_MGF1;
                            }
                            throw new NoSuchAlgorithmException("Unknown name " + string);
                        }
                        return NISTObjectIdentifiers.id_sha512.getId();
                    }
                    return NISTObjectIdentifiers.id_sha384.getId();
                }
                return NISTObjectIdentifiers.id_sha256.getId();
            }
            return NISTObjectIdentifiers.id_sha224.getId();
        }
        return X509ObjectIdentifiers.id_SHA1.getId();
    }

    public static void checkEContent(Collection<Attribute> object, String string, byte[] byArray) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Attribute)object.next();
            if (!RFC_3369_MESSAGE_DIGEST_OID.equals(object2.getAttrType().getId())) continue;
            if ((object2 = object2.getAttrValues()).size() != 1) {
                LOGGER.warning("Expected only one attribute value in signedAttribute message digest in eContent!");
            }
            byte[] byArray2 = ((DEROctetString)object2.getObjectAt(0)).getOctets();
            object2 = byArray2;
            if (byArray2 == null) {
                LOGGER.warning("Error extracting signedAttribute message digest in eContent!");
            }
            if (Arrays.equals((byte[])object2, MessageDigest.getInstance(string).digest(byArray))) continue;
            throw new SignatureException("Error checking signedAttribute message digest in eContent!");
        }
    }

    public static List<Attribute> getAttributes(ASN1Set object) {
        ArrayList<Attribute> arrayList;
        object = Collections.list(object.getObjects());
        ArrayList<Attribute> arrayList2 = arrayList;
        arrayList = new ArrayList<Attribute>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(Attribute.getInstance((Object)((ASN1Sequence)object.next())));
        }
        return arrayList2;
    }

    public static AlgorithmParameterSpec toAlgorithmParameterSpec(RSASSAPSSparams object) {
        RSASSAPSSparams rSASSAPSSparams = object;
        object = rSASSAPSSparams.getHashAlgorithm().getAlgorithm().getId();
        AlgorithmIdentifier algorithmIdentifier = rSASSAPSSparams.getMaskGenAlgorithm();
        object = SignedDataUtil.lookupMnemonicByOID((String)object);
        String string = SignedDataUtil.lookupMnemonicByOID(algorithmIdentifier.getAlgorithm().getId());
        int n2 = rSASSAPSSparams.getSaltLength().intValue();
        int n3 = rSASSAPSSparams.getTrailerField().intValue();
        return new PSSParameterSpec((String)object, string, SignedDataUtil.toMaskGenAlgorithmParameterSpec(algorithmIdentifier), n2, n3);
    }

    public static AlgorithmParameterSpec toMaskGenAlgorithmParameterSpec(AlgorithmIdentifier object) {
        block4: {
            object = object.getParameters();
            if (object == null) break block4;
            object = SignedDataUtil.lookupMnemonicByOID(AlgorithmIdentifier.getInstance((Object)object).getAlgorithm().getId());
            try {
                return new MGF1ParameterSpec((String)object);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
            }
        }
        return new MGF1ParameterSpec("SHA-1");
    }

    public static SignerInfo getSignerInfo(SignedData signedData) {
        if ((signedData = signedData.getSignerInfos()) != null && signedData.size() > 0) {
            if (signedData.size() > 1) {
                LOGGER.warning("Found " + signedData.size() + " signerInfos");
            }
            return SignerInfo.getInstance((Object)signedData.getObjectAt(0));
        }
        throw new IllegalArgumentException("No signer info in signed data");
    }

    public static ASN1Set createSingletonSet(ASN1Object aSN1Object) {
        return new DLSet(new ASN1Encodable[]{aSN1Object});
    }
}

