/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import net.sf.scuba.smartcards.CommandAPDU;
import net.sf.scuba.smartcards.ResponseAPDU;
import net.sf.scuba.tlv.TLVUtil;
import org.jmrtd.Util;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class DESedeSecureMessagingWrapper
extends SecureMessagingWrapper
implements Serializable {
    public static final long serialVersionUID = -2859033943345961793L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final IvParameterSpec ZERO_IV_PARAM_SPEC = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
    public SecretKey ksEnc;
    public SecretKey ksMac;
    public transient Cipher cipher;
    public transient Mac mac;
    public long ssc;

    public DESedeSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2) {
        this(secretKey, secretKey2, true);
    }

    public DESedeSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, boolean bl) {
        this(secretKey, secretKey2, 256, bl, 0L);
    }

    public DESedeSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, long l2) {
        this(secretKey, secretKey2, "DESede/CBC/NoPadding", "ISO9797Alg3Mac", 256, true, l2);
    }

    public DESedeSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, int n2, boolean bl, long l2) {
        this(secretKey, secretKey2, "DESede/CBC/NoPadding", "ISO9797Alg3Mac", n2, bl, l2);
    }

    public DESedeSecureMessagingWrapper(SecretKey secretKey, SecretKey secretKey2, String string, String string2, int n2, boolean bl, long l2) {
        super(n2, bl);
        this.ksEnc = secretKey;
        this.ksMac = secretKey2;
        this.ssc = l2;
        this.cipher = Util.getCipher(string);
        this.mac = Util.getMac(string2);
    }

    private CommandAPDU wrapCommandAPDU(CommandAPDU object, long l2) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        CommandAPDU commandAPDU = object;
        int n2 = commandAPDU.getNc();
        int n3 = commandAPDU.getNe();
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(object.getCLA() | 0xC);
        byArray2[1] = (byte)object.getINS();
        byArray2[2] = (byte)object.getP1();
        byArray[3] = (byte)object.getP2();
        byte[] byArray3 = Util.pad(byArray, 8);
        int n4 = (byte)commandAPDU.getINS() == -79 ? 1 : 0;
        byte[] byArray4 = new byte[]{};
        byte[] byArray5 = new byte[]{};
        int n5 = object.getINS();
        if (n3 > 0 && n3 < this.getMaxTranceiveLength() || (byte)n5 == -120) {
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
            ByteArrayOutputStream byteArrayOutputStream4 = byteArrayOutputStream2;
            byteArrayOutputStream4.reset();
            byteArrayOutputStream4.write(-105);
            byteArrayOutputStream4.write(1);
            byteArrayOutputStream3.write((byte)n3);
            byArray5 = byteArrayOutputStream3.toByteArray();
        }
        IvParameterSpec ivParameterSpec = ZERO_IV_PARAM_SPEC;
        this.cipher.init(1, (Key)this.ksEnc, ivParameterSpec);
        if (n2 > 0) {
            object = Util.pad(object.getData(), 8);
            object = this.cipher.doFinal((byte[])object);
            byteArrayOutputStream2.reset();
            int n6 = n4 != 0 ? -123 : -121;
            byteArrayOutputStream2.write(n6);
            byteArrayOutputStream2.write(TLVUtil.getLengthAsBytes((int)(((Object)object).length + (n4 ^ 1))));
            if (n4 == 0) {
                byteArrayOutputStream2.write(1);
            }
            ByteArrayOutputStream byteArrayOutputStream5 = byteArrayOutputStream2;
            Object object2 = object;
            byteArrayOutputStream5.write((byte[])object2, 0, ((CommandAPDU)object2).length);
            byArray4 = byteArrayOutputStream5.toByteArray();
        }
        DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper = this;
        ByteArrayOutputStream byteArrayOutputStream6 = byteArrayOutputStream2;
        byteArrayOutputStream6.reset();
        object = dataOutputStream;
        object(byteArrayOutputStream2);
        object.writeLong(l2);
        object.write(byArray3);
        object.write(byArray4);
        dataOutputStream.write(byArray5);
        dataOutputStream.flush();
        object = Util.pad(byteArrayOutputStream6.toByteArray(), 8);
        dESedeSecureMessagingWrapper.mac.init(this.ksMac);
        byte[] byArray6 = dESedeSecureMessagingWrapper.mac.doFinal((byte[])object);
        object = byArray6;
        int n7 = byArray6.length;
        if (n7 != 8) {
            n7 = 8;
        }
        ByteArrayOutputStream byteArrayOutputStream7 = byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream8 = byteArrayOutputStream2;
        byteArrayOutputStream8.reset();
        byteArrayOutputStream8.write(-114);
        byteArrayOutputStream2.write(n7);
        byteArrayOutputStream7.write((byte[])object, 0, n7);
        byte[] byArray7 = byteArrayOutputStream7.toByteArray();
        byteArrayOutputStream2.reset();
        byteArrayOutputStream2.write(byArray4);
        byteArrayOutputStream2.write(byArray5);
        byteArrayOutputStream7.write(byArray7);
        object = byteArrayOutputStream7.toByteArray();
        return new CommandAPDU((int)byArray2[0], (int)byArray2[1], (int)byArray2[2], (int)byArray2[3], (byte[])object, this.getMaxTranceiveLength());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseAPDU unwrapResponseAPDU(ResponseAPDU object, long l2) {
        ByteArrayOutputStream byteArrayOutputStream;
        void var2_3;
        boolean bl;
        DataInputStream dataInputStream;
        short s2;
        byte[] byArray;
        Object object2;
        byte[] byArray2 = object.getBytes();
        if (byArray2 != null && byArray2.length >= 2) {
            DataInputStream dataInputStream2;
            object2 = ZERO_IV_PARAM_SPEC;
            ((DESedeSecureMessagingWrapper)((Object)byteArrayOutputStream2)).cipher.init(2, (Key)((DESedeSecureMessagingWrapper)((Object)byteArrayOutputStream2)).ksEnc, (AlgorithmParameterSpec)object2);
            object2 = new byte[0];
            byArray = null;
            s2 = 0;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray2));
            bl = false;
        } else {
            throw new IllegalArgumentException("Invalid response APDU");
        }
        while (!bl) {
            try {
                byte[] byArray3;
                byte by = dataInputStream.readByte();
                if (by != -123) {
                    if (by != -121) {
                        if (by != -114) {
                            if (by != -103) {
                                LOGGER.warning("Unexpected tag " + Integer.toHexString(by));
                                continue;
                            }
                            s2 = super.readDO99(dataInputStream);
                            continue;
                        }
                        byArray = super.readDO8E(dataInputStream);
                        bl = true;
                        continue;
                    }
                    byArray3 = super.readDO87(dataInputStream, false);
                } else {
                    byArray3 = ((DESedeSecureMessagingWrapper)((Object)byteArrayOutputStream2)).readDO87(dataInputStream, true);
                }
                object2 = byArray3;
            }
            catch (Throwable throwable) {
                dataInputStream.close();
                throw throwable;
            }
        }
        dataInputStream.close();
        if (((SecureMessagingWrapper)((Object)byteArrayOutputStream2)).shouldCheckMAC() && !((DESedeSecureMessagingWrapper)((Object)byteArrayOutputStream2)).checkMac(byArray2, byArray, (long)var2_3)) {
            throw new IllegalStateException("Invalid MAC");
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        Object object3 = object2;
        byteArrayOutputStream2();
        byteArrayOutputStream2.write((byte[])object3, 0, ((Object)object3).length);
        byteArrayOutputStream2.write((s2 & 0xFF00) >> 8);
        byteArrayOutputStream.write(s2 & 0xFF);
        return new ResponseAPDU(byteArrayOutputStream2.toByteArray());
    }

    private byte[] readDO87(DataInputStream dataInputStream, boolean bl) {
        Object object;
        int n2 = 0;
        int n3 = dataInputStream.readUnsignedByte();
        if ((n3 & 0x80) != 128) {
            n2 = n3;
        } else {
            n3 &= 0x7F;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 = n2 << 8 | dataInputStream.readUnsignedByte();
            }
        }
        if (!bl) {
            int n4 = dataInputStream.readUnsignedByte();
            if (n4 == 1) {
                --n2;
            } else {
                throw new IllegalStateException("DO'87 expected 0x01 marker, found " + Integer.toHexString(n4 & 0xFF));
            }
        }
        DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper = object;
        byte[] byArray = new byte[n2];
        object = byArray;
        dataInputStream.readFully(byArray);
        return Util.unpad(dESedeSecureMessagingWrapper.cipher.doFinal((byte[])object));
    }

    private short readDO99(DataInputStream dataInputStream) {
        if (dataInputStream.readUnsignedByte() == 2) {
            byte by = dataInputStream.readByte();
            return (short)((dataInputStream.readByte() & 0xFF) << 8 | by & 0xFF);
        }
        throw new IllegalStateException("DO'99 wrong length");
    }

    private byte[] readDO8E(DataInputStream dataInputStream) {
        if (dataInputStream.readUnsignedByte() == 8) {
            byte[] byArray = new byte[8];
            dataInputStream.readFully(byArray);
            return byArray;
        }
        throw new IllegalStateException("DO'8E wrong length");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkMac(byte[] byArray, byte[] byArray2, long l2) {
        DataOutputStream dataOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper;
        DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper2;
        try {
            DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper3 = object;
            dESedeSecureMessagingWrapper2 = dESedeSecureMessagingWrapper3;
            dESedeSecureMessagingWrapper = dESedeSecureMessagingWrapper3;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception checking MAC", iOException);
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = dataOutputStream;
        byte[] byArray3 = byArray;
        dataOutputStream2(byteArrayOutputStream2);
        dataOutputStream2.writeLong(l2);
        int n2 = byArray.length;
        byte[] byArray4 = Util.pad(byArray3, 0, n2 - 2 - 8 - 2, 8);
        dataOutputStream.write(byArray4, 0, byArray4.length);
        dataOutputStream.flush();
        dataOutputStream.close();
        dESedeSecureMessagingWrapper2.mac.init(((DESedeSecureMessagingWrapper)object).ksMac);
        byte[] byArray5 = dESedeSecureMessagingWrapper.mac.doFinal(byteArrayOutputStream2.toByteArray());
        Object object = byArray5;
        if (byArray5.length <= 8) return Arrays.equals(byArray2, (byte[])object);
        if (byArray2.length != 8) return Arrays.equals(byArray2, (byte[])object);
        Object object2 = object;
        object = new byte[8];
        System.arraycopy(object2, 0, object, 0, ((Object)object).length);
        return Arrays.equals(byArray2, (byte[])object);
    }

    public String getType() {
        return "DESede";
    }

    public CommandAPDU wrap(CommandAPDU commandAPDU) {
        DESedeSecureMessagingWrapper dESedeSecureMessagingWrapper = this;
        ++dESedeSecureMessagingWrapper.ssc;
        try {
            return this.wrapCommandAPDU(commandAPDU, dESedeSecureMessagingWrapper.ssc);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception", generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseAPDU unwrap(ResponseAPDU responseAPDU) {
        ++this.ssc;
        try {
            byte[] byArray = responseAPDU.getData();
            if (byArray != null && byArray.length > 0) {
                return this.unwrapResponseAPDU(responseAPDU, this.ssc);
            }
            throw new IllegalStateException("Card indicates SM error, SW = " + Integer.toHexString(responseAPDU.getSW() & 0xFFFF));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected exception", iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception", generalSecurityException);
        }
    }

    @Override
    public SecretKey getEncryptionKey() {
        return this.ksEnc;
    }

    @Override
    public SecretKey getMACKey() {
        return this.ksMac;
    }

    @Override
    public long getSendSequenceCounter() {
        return this.ssc;
    }

    public int hashCode() {
        int n2 = 31;
        SecretKey secretKey = this.ksEnc;
        int n3 = secretKey == null ? 0 : secretKey.hashCode();
        n2 = (n2 + n3) * 31;
        SecretKey secretKey2 = this.ksMac;
        int n4 = secretKey2 == null ? 0 : secretKey2.hashCode();
        long l2 = this.ssc;
        return (n2 + n4) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (DESedeSecureMessagingWrapper.class != object.getClass()) {
            return false;
        }
        object = (DESedeSecureMessagingWrapper)object;
        SecretKey secretKey = this.ksEnc;
        if (secretKey == null ? ((DESedeSecureMessagingWrapper)object).ksEnc != null : !secretKey.equals(((DESedeSecureMessagingWrapper)object).ksEnc)) {
            return false;
        }
        secretKey = this.ksMac;
        if (secretKey == null ? ((DESedeSecureMessagingWrapper)object).ksMac != null : !secretKey.equals(((DESedeSecureMessagingWrapper)object).ksMac)) {
            return false;
        }
        return this.ssc == ((DESedeSecureMessagingWrapper)object).ssc;
    }

    public String toString() {
        return "DESedeSecureMessagingWrapper [ " + this.ksEnc.toString() + ", " + this.ksMac.toString() + ", " + this.ssc + "]";
    }
}

