/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.PublicKey;
import org.jmrtd.AccessKeySpec;
import org.jmrtd.Util;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.protocol.PACEMappingResult;
import org.jmrtd.protocol.SecureMessagingWrapper;

public class PACEResult
implements Serializable {
    public static final long serialVersionUID = -6819675856205885052L;
    public PACEInfo.MappingType mappingType;
    public String agreementAlg;
    public String cipherAlg;
    public String digestAlg;
    public int keyLength;
    public AccessKeySpec paceKey;
    public PACEMappingResult mappingResult;
    public PublicKey piccPublicKey;
    public KeyPair pcdKeyPair;
    public SecureMessagingWrapper wrapper;

    public PACEResult(AccessKeySpec accessKeySpec, PACEInfo.MappingType mappingType, String string, String string2, String string3, int n2, PACEMappingResult pACEMappingResult, KeyPair keyPair, PublicKey publicKey, SecureMessagingWrapper secureMessagingWrapper) {
        this.paceKey = accessKeySpec;
        this.mappingType = mappingType;
        this.agreementAlg = string;
        this.cipherAlg = string2;
        this.digestAlg = string3;
        this.keyLength = n2;
        this.mappingResult = pACEMappingResult;
        this.pcdKeyPair = keyPair;
        this.piccPublicKey = publicKey;
        this.wrapper = secureMessagingWrapper;
    }

    public AccessKeySpec getPACEKey() {
        return this.paceKey;
    }

    public PACEMappingResult getMappingResult() {
        return this.mappingResult;
    }

    public SecureMessagingWrapper getWrapper() {
        return this.wrapper;
    }

    public PACEInfo.MappingType getMappingType() {
        return this.mappingType;
    }

    public String getAgreementAlg() {
        return this.agreementAlg;
    }

    public String getCipherAlg() {
        return this.cipherAlg;
    }

    public String getDigestAlg() {
        return this.digestAlg;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public KeyPair getPCDKeyPair() {
        return this.pcdKeyPair;
    }

    public PublicKey getPICCPublicKey() {
        return this.piccPublicKey;
    }

    public String toString() {
        return "PACEResult [paceKey: " + this.paceKey + ", mappingType: " + (Object)((Object)this.mappingType) + ", agreementAlg: " + this.agreementAlg + ", cipherAlg: " + this.cipherAlg + ", digestAlg: " + this.digestAlg + ", keyLength: " + this.keyLength + ", mappingResult: " + this.mappingResult + ", piccPublicKey: " + Util.getDetailedPublicKeyAlgorithm(this.piccPublicKey) + ", pcdPrivateKey: " + Util.getDetailedPrivateKeyAlgorithm(this.pcdKeyPair.getPrivate()) + ", pcdPublicKey: " + Util.getDetailedPublicKeyAlgorithm(this.pcdKeyPair.getPublic());
    }

    public int hashCode() {
        int n2 = 21901;
        AccessKeySpec accessKeySpec = this.paceKey;
        int n3 = accessKeySpec == null ? 0 : accessKeySpec.hashCode();
        n2 = (n2 + n3) * 1991;
        String string = this.agreementAlg;
        int n4 = string == null ? 0 : string.hashCode();
        n2 = (n2 + n4) * 1991;
        String string2 = this.cipherAlg;
        int n5 = string2 == null ? 0 : string2.hashCode();
        n2 = (n2 + n5) * 1991;
        String string3 = this.digestAlg;
        int n6 = string3 == null ? 0 : string3.hashCode();
        n2 = (n2 + n6) * 1991;
        PACEMappingResult pACEMappingResult = this.mappingResult;
        int n7 = pACEMappingResult == null ? 0 : pACEMappingResult.hashCode();
        n2 = ((n2 + n7) * 1991 + this.keyLength) * 1991;
        PACEInfo.MappingType mappingType = this.mappingType;
        int n8 = mappingType == null ? 0 : mappingType.hashCode();
        n2 = (n2 + n8) * 1991;
        KeyPair keyPair = this.pcdKeyPair;
        int n9 = keyPair == null ? 0 : keyPair.hashCode();
        n2 = (n2 + n9) * 1991;
        PublicKey publicKey = this.piccPublicKey;
        int n10 = publicKey == null ? 0 : publicKey.hashCode();
        int n11 = (n2 + n10) * 1991;
        SecureMessagingWrapper secureMessagingWrapper = this.wrapper;
        int n12 = secureMessagingWrapper == null ? 0 : secureMessagingWrapper.hashCode();
        return n11 + n12;
    }

    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (serializable.getClass() != object.getClass()) {
            return false;
        }
        object = (PACEResult)object;
        Object object2 = ((PACEResult)serializable).paceKey;
        if (object2 == null ? ((PACEResult)object).paceKey != null : !object2.equals(((PACEResult)object).paceKey)) {
            return false;
        }
        object2 = ((PACEResult)serializable).agreementAlg;
        if (object2 == null ? ((PACEResult)object).agreementAlg != null : !((String)object2).equals(((PACEResult)object).agreementAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).cipherAlg;
        if (object2 == null ? ((PACEResult)object).cipherAlg != null : !((String)object2).equals(((PACEResult)object).cipherAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).digestAlg;
        if (object2 == null ? ((PACEResult)object).digestAlg != null : !((String)object2).equals(((PACEResult)object).digestAlg)) {
            return false;
        }
        object2 = ((PACEResult)serializable).mappingResult;
        if (object2 == null ? ((PACEResult)object).mappingResult != null : !((PACEMappingResult)object2).equals(((PACEResult)object).mappingResult)) {
            return false;
        }
        if (((PACEResult)serializable).keyLength != ((PACEResult)object).keyLength) {
            return false;
        }
        if (((PACEResult)serializable).mappingType != ((PACEResult)object).mappingType) {
            return false;
        }
        object2 = ((PACEResult)serializable).pcdKeyPair;
        if (object2 == null ? ((PACEResult)object).pcdKeyPair != null : !object2.equals(((PACEResult)object).pcdKeyPair)) {
            return false;
        }
        object2 = ((PACEResult)serializable).piccPublicKey;
        if (object2 == null ? ((PACEResult)object).piccPublicKey != null : !object2.equals(((PACEResult)object).piccPublicKey)) {
            return false;
        }
        Serializable serializable = ((PACEResult)serializable).wrapper;
        return !(serializable == null ? ((PACEResult)object).wrapper != null : !serializable.equals(((PACEResult)object).wrapper));
    }
}

