/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.nfc.factory;

import android.os.Build;
import android.os.IBinder;
import android.os.Parcel;
import android.util.Log;
import com.dtf.face.log.RecordService;
import java.lang.reflect.Method;

public class VIVO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReaderModeEnabled() {
        boolean isVivo = Build.MANUFACTURER.equalsIgnoreCase("vivo");
        if (!isVivo) {
            return true;
        }
        boolean isReadEnabled = true;
        try {
            Class<?> serviceManagerClass = Class.forName("android.os.ServiceManager");
            Method getServiceMethod = serviceManagerClass.getDeclaredMethod("getService", String.class);
            IBinder binder = (IBinder)getServiceMethod.invoke(null, "nfc");
            Parcel nfcData = Parcel.obtain();
            Parcel nfcReply = Parcel.obtain();
            try {
                nfcData.writeInterfaceToken("android.nfc.INfcAdapter");
                nfcData.writeString("vivo");
                binder.transact(6, nfcData, nfcReply, 0);
                nfcReply.readException();
                IBinder vivoBinder = nfcReply.readStrongBinder();
                Parcel vivoData = Parcel.obtain();
                Parcel vivoReply = Parcel.obtain();
                try {
                    vivoData.writeInterfaceToken("com.vivo.nfc.IVivoNfcAdapter");
                    vivoBinder.transact(3, vivoData, vivoReply, 0);
                    vivoReply.readException();
                    isReadEnabled = vivoReply.readInt() != 0;
                    Log.i((String)"AntTest", (String)("No exception end with result: " + isReadEnabled));
                }
                finally {
                    vivoReply.recycle();
                    vivoData.recycle();
                }
            }
            finally {
                nfcReply.recycle();
                nfcData.recycle();
            }
        }
        catch (Throwable e) {
            RecordService.getInstance().recordException(e);
            Log.i((String)"AntTest", (String)("isReaderModeEnabled params: :" + Log.getStackTraceString((Throwable)e)));
        }
        return isReadEnabled;
    }
}

