/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Set;
import org.eid_bc.bouncycastle.asn1.DEROctetString;
import org.eid_bc.bouncycastle.asn1.DLSet;
import org.eid_bc.bouncycastle.asn1.cms.ContentInfo;
import org.eid_bc.bouncycastle.asn1.cms.SignedData;
import org.jmrtd.lds.ChipAuthenticationInfo;
import org.jmrtd.lds.ChipAuthenticationPublicKeyInfo;
import org.jmrtd.lds.PACEInfo;
import org.jmrtd.lds.SecurityInfo;
import org.jmrtd.lds.SignedDataUtil;

public class CardSecurityFile
implements Serializable {
    public static final long serialVersionUID = -3535507558193769952L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final String CONTENT_TYPE_OID = "0.4.0.127.0.7.3.2.1";
    public String digestAlgorithm;
    public String digestEncryptionAlgorithm;
    public Set<SecurityInfo> securityInfos;
    public byte[] encryptedDigest;
    public X509Certificate certificate;

    public CardSecurityFile(String string, String string2, Collection<SecurityInfo> collection, PrivateKey privateKey, X509Certificate x509Certificate) {
        this(string, string2, collection, privateKey, x509Certificate, null);
    }

    public CardSecurityFile(String string, String string2, Collection<SecurityInfo> collection, PrivateKey privateKey, X509Certificate x509Certificate, String string3) {
        this(string, string2, collection, (byte[])null, x509Certificate);
        this.encryptedDigest = SignedDataUtil.signData(string, string2, CONTENT_TYPE_OID, CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, collection), privateKey, string3);
    }

    public CardSecurityFile(String string, String string2, Collection<SecurityInfo> collection, byte[] byArray, X509Certificate x509Certificate) {
        if (collection != null) {
            if (x509Certificate != null) {
                CardSecurityFile cardSecurityFile = this;
                this.digestAlgorithm = string;
                cardSecurityFile.digestEncryptionAlgorithm = string2;
                cardSecurityFile.securityInfos = new HashSet<SecurityInfo>(collection);
                this.encryptedDigest = byArray;
                this.certificate = x509Certificate;
                return;
            }
            throw new IllegalArgumentException("Null certificate");
        }
        throw new IllegalArgumentException("Null securityInfos");
    }

    public CardSecurityFile(InputStream inputStream) {
        this.readContent(inputStream);
    }

    public static ContentInfo toContentInfo(String string, Collection<SecurityInfo> aSN1EncodableVector) {
        DLSet dLSet;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector;
        aSN1EncodableVector = aSN1EncodableVector2;
        aSN1EncodableVector2 = new ASN1EncodableVector();
        DLSet dLSet2 = aSN1EncodableVector3.iterator();
        while (true) {
            if (!dLSet2.hasNext()) break;
            aSN1EncodableVector.add((ASN1Encodable)((SecurityInfo)dLSet2.next()).getDERObject());
            continue;
            break;
        }
        dLSet2 = dLSet;
        try {
            dLSet = new DLSet(aSN1EncodableVector);
            return new ContentInfo(new ASN1ObjectIdentifier(string), (ASN1Encodable)new DEROctetString((ASN1Encodable)dLSet2));
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Error creating signedData", iOException);
            throw new IllegalArgumentException("Error DER encoding the security infos");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<SecurityInfo> getSecurityInfos(SignedData signedData) {
        HashSet<SecurityInfo> hashSet;
        if (!((signedData = SignedDataUtil.getContent(signedData)) instanceof ASN1Set)) {
            throw new IOException("Was expecting an ASN1Set, found " + signedData.getClass());
        }
        signedData = (ASN1Set)signedData;
        HashSet<SecurityInfo> hashSet2 = hashSet;
        hashSet = new HashSet<SecurityInfo>();
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 >= signedData.size()) {
                    return hashSet2;
                }
                try {
                    SecurityInfo securityInfo = SecurityInfo.getInstance(signedData.getObjectAt(n2).toASN1Primitive());
                    if (securityInfo == null) {
                        LOGGER.log(Level.WARNING, "Could not parse, skipping security info");
                        break block7;
                    }
                    hashSet2.add(securityInfo);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Exception while parsing, skipping security info", exception);
                }
            }
            ++n2;
        }
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public void readContent(InputStream inputStream) {
        CardSecurityFile cardSecurityFile = cardSecurityFile2;
        CardSecurityFile cardSecurityFile2 = SignedDataUtil.readSignedData(inputStream);
        cardSecurityFile.digestAlgorithm = SignedDataUtil.getSignerInfoDigestAlgorithm((SignedData)cardSecurityFile2);
        cardSecurityFile.digestEncryptionAlgorithm = SignedDataUtil.getDigestEncryptionAlgorithm((SignedData)cardSecurityFile2);
        cardSecurityFile.certificate = SignedDataUtil.getDocSigningCertificate((SignedData)cardSecurityFile2);
        cardSecurityFile.securityInfos = CardSecurityFile.getSecurityInfos((SignedData)cardSecurityFile2);
        cardSecurityFile.encryptedDigest = SignedDataUtil.getEncryptedDigest((SignedData)cardSecurityFile2);
    }

    public void writeContent(OutputStream outputStream) {
        ContentInfo contentInfo = CardSecurityFile.toContentInfo(CONTENT_TYPE_OID, this.securityInfos);
        String string = this.digestAlgorithm;
        String string2 = this.digestEncryptionAlgorithm;
        try {
            SignedDataUtil.writeData(SignedDataUtil.createSignedData(string, string2, CONTENT_TYPE_OID, contentInfo, this.encryptedDigest, this.certificate), outputStream);
            return;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException("General security exception", generalSecurityException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("Unsupported algorithm", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new IOException("Certificate exception during SignedData creation", certificateException);
        }
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeContent(byteArrayOutputStream);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception while encoding CardSecurityFile", iOException);
            return null;
        }
    }

    public Collection<SecurityInfo> getSecurityInfos() {
        return this.securityInfos;
    }

    public Collection<PACEInfo> getPACEInfos() {
        ArrayList<PACEInfo> arrayList;
        ArrayList<PACEInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<PACEInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof PACEInfo)) continue;
            arrayList2.add((PACEInfo)securityInfo);
        }
        return arrayList2;
    }

    public Collection<ChipAuthenticationInfo> getChipAuthenticationInfos() {
        ArrayList<ChipAuthenticationInfo> arrayList;
        ArrayList<ChipAuthenticationInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ChipAuthenticationInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationInfo)) continue;
            arrayList2.add((ChipAuthenticationInfo)securityInfo);
        }
        return arrayList2;
    }

    public Collection<ChipAuthenticationPublicKeyInfo> getChipAuthenticationPublicKeyInfos() {
        ArrayList<ChipAuthenticationPublicKeyInfo> arrayList;
        ArrayList<ChipAuthenticationPublicKeyInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<ChipAuthenticationPublicKeyInfo>(((CardSecurityFile)this).securityInfos.size());
        for (SecurityInfo securityInfo : ((CardSecurityFile)this).securityInfos) {
            if (!(securityInfo instanceof ChipAuthenticationPublicKeyInfo)) continue;
            arrayList2.add((ChipAuthenticationPublicKeyInfo)securityInfo);
        }
        return arrayList2;
    }

    public String toString() {
        return "CardSecurityFile [" + this.securityInfos.toString() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object set) {
        if (set == null) {
            return false;
        }
        if (!set.getClass().equals(CardSecurityFile.class)) {
            return false;
        }
        CardSecurityFile cardSecurityFile = set2;
        Set<SecurityInfo> set2 = (CardSecurityFile)((Object)set);
        set = cardSecurityFile.securityInfos;
        if (set == null) {
            if (((CardSecurityFile)((Object)set2)).securityInfos != null) return false;
            return true;
        }
        set2 = ((CardSecurityFile)((Object)set2)).securityInfos;
        if (set2 == null) {
            if (set != null) return false;
            return true;
        }
        boolean bl = set.equals(set2);
        return bl;
    }

    public int hashCode() {
        return this.securityInfos.hashCode() * 3 + 63;
    }
}

