/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.iso19794;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.jmrtd.lds.AbstractListInfo;
import org.jmrtd.lds.iso19794.IrisImageInfo;

public class IrisBiometricSubtypeInfo
extends AbstractListInfo<IrisImageInfo> {
    public static final long serialVersionUID = -6588640634764878039L;
    public static final int EYE_UNDEF = 0;
    public static final int EYE_RIGHT = 1;
    public static final int EYE_LEFT = 2;
    public int imageFormat;
    public int biometricSubtype;

    public IrisBiometricSubtypeInfo(int n2, int n3, List<IrisImageInfo> list) {
        this.biometricSubtype = n2;
        this.imageFormat = n3;
        this.addAll(list);
    }

    public IrisBiometricSubtypeInfo(InputStream inputStream, int n2) {
        this.imageFormat = n2;
        this.readObject(inputStream);
    }

    public static String biometricSubtypeToString(int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    return "Left eye";
                }
                throw new NumberFormatException("Unknown biometric subtype: " + Integer.toHexString(n2));
            }
            return "Right eye";
        }
        return "Undefined";
    }

    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        if (inputStream instanceof DataInputStream) {
            dataInputStream = (DataInputStream)inputStream;
        } else {
            DataInputStream dataInputStream2;
            dataInputStream = dataInputStream2;
            dataInputStream2 = new DataInputStream(inputStream);
        }
        this.biometricSubtype = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedShort();
        for (int i2 = 0; i2 < n2; ++i2) {
            IrisImageInfo irisImageInfo = new IrisImageInfo(inputStream, this.imageFormat);
            irisImageInfo.getRecordLength();
            this.add(irisImageInfo);
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        OutputStream outputStream2;
        if (outputStream instanceof DataOutputStream) {
            outputStream2 = outputStream = (DataOutputStream)outputStream;
        } else {
            DataOutputStream dataOutputStream;
            outputStream2 = dataOutputStream;
            dataOutputStream = new DataOutputStream(outputStream);
        }
        ((DataOutputStream)outputStream2).writeByte(((IrisBiometricSubtypeInfo)((Object)iterator)).biometricSubtype & 0xFF);
        List list = ((AbstractListInfo)((Object)iterator)).getSubRecords();
        ((DataOutputStream)outputStream2).writeShort(list.size() & 0xFFFF);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((IrisImageInfo)iterator.next()).writeObject(outputStream2);
        }
    }

    public long getRecordLength() {
        long l2 = 3L;
        Iterator iterator = ((AbstractListInfo)((Object)iterator)).getSubRecords().iterator();
        while (iterator.hasNext()) {
            l2 += ((IrisImageInfo)iterator.next()).getRecordLength();
        }
        return l2;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.biometricSubtype) * 31 + this.imageFormat;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (IrisBiometricSubtypeInfo.class != object.getClass()) {
            return false;
        }
        object = (IrisBiometricSubtypeInfo)object;
        return this.biometricSubtype == ((IrisBiometricSubtypeInfo)object).biometricSubtype && this.imageFormat == ((IrisBiometricSubtypeInfo)object).imageFormat;
    }

    public String toString() {
        return "IrisBiometricSubtypeInfo [biometric subtype: " + IrisBiometricSubtypeInfo.biometricSubtypeToString(this.biometricSubtype) + ", imageCount = " + this.getSubRecords().size() + "]";
    }

    public int getBiometricSubtype() {
        return this.biometricSubtype;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public List<IrisImageInfo> getIrisImageInfos() {
        return this.getSubRecords();
    }

    public void addIrisImageInfo(IrisImageInfo irisImageInfo) {
        this.add(irisImageInfo);
    }

    public void removeIrisImageInfo(int n2) {
        this.remove(n2);
    }
}

