/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class NubiaImpl
implements IOAID {
    private final Context context;

    public NubiaImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supportOAID() {
        return true;
    }

    @Override
    public void doGet(IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        try {
            String oaid = null;
            Bundle bundle = null;
            Uri uri = Uri.parse((String)"content://cn.nubia.identity/identity");
            if (uri != null) {
                ContentResolver cr = this.context.getContentResolver();
                if (cr != null) {
                    ContentProviderClient client;
                    if (Build.VERSION.SDK_INT > 17 && (client = cr.acquireContentProviderClient(uri)) != null) {
                        bundle = client.call("getOAID", null, null);
                        if (Build.VERSION.SDK_INT >= 24) {
                            client.close();
                        } else {
                            client.release();
                        }
                    }
                } else {
                    bundle = cr.call(uri, "getOAID", null, null);
                }
                if (bundle == null) {
                    throw new RuntimeException("getOAID call failed");
                }
                if (bundle.getInt("code", -1) == 0) {
                    oaid = bundle.getString("id");
                }
            }
            if (oaid == null || oaid.length() <= 0) {
                String failedMsg = "OAID unsupported";
                if (bundle != null) {
                    failedMsg = bundle.getString("message");
                }
                throw new RuntimeException(failedMsg);
            }
            getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            LogUtil.d(e.toString());
            getter.onOAIDGetError(e);
        }
    }
}

