/*
 * Decompiled with CFR 0.152.
 */
package net.security.device.api.id.oaid;

import android.annotation.SuppressLint;
import android.content.Context;
import java.lang.reflect.Method;
import net.security.device.api.LogUtil;
import net.security.device.api.id.IOAID;
import net.security.device.api.id.IOAIDGetter;

public class XiaomiImpl
implements IOAID {
    private final Context context;
    private Class<?> idProvider;

    @SuppressLint(value={"PrivateApi"})
    public XiaomiImpl(Context context) {
        this.context = context;
        try {
            this.idProvider = Class.forName("com.android.id.impl.IdProviderImpl");
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
    }

    @Override
    public boolean supportOAID() {
        return this.idProvider != null;
    }

    @Override
    public void doGet(IOAIDGetter getter) {
        if (this.context == null) {
            getter.onOAIDGetError(new NullPointerException("OAID context is null"));
            return;
        }
        if (this.idProvider == null) {
            getter.onOAIDGetError(new NullPointerException("Xiaomi IdProvider not exists"));
            return;
        }
        try {
            String did = this.invokeMethod("getDefaultUDID");
            if (did != null && did.length() > 0) {
                getter.onOAIDGetComplete(did);
                return;
            }
            did = this.invokeMethod("getOAID");
            if (did == null || did.length() <= 0) {
                throw new RuntimeException("Xiaomi OAID get failed");
            }
            getter.onOAIDGetComplete(did);
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
            getter.onOAIDGetError(e);
        }
    }

    private String invokeMethod(String func) {
        String ret = null;
        if (func == null || func.isEmpty() || this.idProvider == null) {
            return ret;
        }
        try {
            Method method = this.idProvider.getMethod(func, Context.class);
            if (method != null) {
                ret = (String)method.invoke(this.idProvider.newInstance(), this.context);
            }
        }
        catch (Exception e) {
            LogUtil.e(e.toString());
        }
        return ret;
    }
}

