/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import org.jmrtd.io.SplittableInputStream;
import org.jmrtd.lds.AbstractLDSFile;

public abstract class AbstractTaggedLDSFile
extends AbstractLDSFile {
    public static final long serialVersionUID = -4761360877353069639L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public int tag;
    public int length;

    public AbstractTaggedLDSFile(int n2) {
        this.tag = n2;
    }

    public AbstractTaggedLDSFile(int n2, InputStream inputStream) {
        this.tag = n2;
        this.readObject(inputStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getContent() {
        Throwable throwable2222222;
        ByteArrayOutputStream byteArrayOutputStream2;
        block8: {
            ByteArrayOutputStream byteArrayOutputStream2;
            ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2 = byteArrayOutputStream2;
            byteArrayOutputStream3();
            ((AbstractTaggedLDSFile)object).writeContent(byteArrayOutputStream3);
            byteArrayOutputStream2.flush();
            Object object = byteArrayOutputStream2.toByteArray();
            {
                catch (Throwable throwable2222222) {
                    break block8;
                }
                catch (IOException iOException) {}
                {
                    throw new IllegalStateException("Could not get DG content", iOException);
                }
            }
            try {
                byteArrayOutputStream2.close();
                return object;
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, "Error closing stream", iOException);
            }
            return object;
        }
        try {
            byteArrayOutputStream2.close();
            throw throwable2222222;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.FINE, "Error closing stream", iOException);
        }
        throw throwable2222222;
    }

    @Override
    public void readObject(InputStream inputStream) {
        TLVInputStream tLVInputStream;
        if (inputStream instanceof TLVInputStream) {
            tLVInputStream = (TLVInputStream)inputStream;
        } else {
            TLVInputStream tLVInputStream2;
            tLVInputStream = tLVInputStream2;
            tLVInputStream2 = new TLVInputStream(inputStream);
        }
        int n2 = tLVInputStream.readTag();
        if (n2 == this.tag) {
            this.length = tLVInputStream.readLength();
            this.readContent(new SplittableInputStream(inputStream, this.length));
            return;
        }
        throw new IllegalArgumentException("Was expecting tag " + Integer.toHexString(this.tag) + ", found " + Integer.toHexString(n2));
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
            object = outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
        }
        AbstractTaggedLDSFile abstractTaggedLDSFile = this;
        int n2 = abstractTaggedLDSFile.getTag();
        if (abstractTaggedLDSFile.tag != n2) {
            this.tag = n2;
        }
        object.writeTag(n2);
        byte[] byArray = this.getContent();
        int n3 = byArray == null ? 0 : byArray.length;
        if (this.length != n3) {
            this.length = n3;
        }
        object.writeValue(byArray);
    }

    public abstract void readContent(InputStream var1);

    public abstract void writeContent(OutputStream var1);

    public String toString() {
        return "TaggedLDSFile [" + Integer.toHexString(this.getTag()) + " (" + this.getLength() + ")]";
    }

    public int getTag() {
        return this.tag;
    }

    @Override
    public int getLength() {
        if (this.length <= 0) {
            this.length = this.getContent().length;
        }
        return this.length;
    }
}

