/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import java.util.Locale;

public class MobileUtil {
    public static final String NETWORK_NONE = "None";
    public static final String NETWORK_WIFI = "WIFI";
    public static final String NETWORK_2G = "2G";
    public static final String NETWORK_3G = "3G";
    public static final String NETWORK_4G = "4G";
    public static final String NETWORK_MOBILE = "Mobile";

    public static String getOperatorName(Context context) {
        if ((context = (TelephonyManager)context.getSystemService("phone")) != null) {
            try {
                return context.getSimOperatorName();
            }
            catch (Exception exception) {}
        }
        return "";
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return NETWORK_NONE;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            if ((connectivityManager = connectivityManager.getNetworkInfo(1)) != null && (connectivityManager = connectivityManager.getState()) != null && (connectivityManager == NetworkInfo.State.CONNECTED || connectivityManager == NetworkInfo.State.CONNECTING)) {
                return NETWORK_WIFI;
            }
            context = (TelephonyManager)context.getSystemService("phone");
            int n = 0;
            if (context != null) {
                try {
                    n = context.getNetworkType();
                }
                catch (Throwable throwable) {}
            }
            switch (n) {
                default: {
                    return NETWORK_MOBILE;
                }
                case 13: {
                    return NETWORK_4G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return NETWORK_3G;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
            }
            return NETWORK_2G;
        }
        return NETWORK_NONE;
    }

    public static String getMobileLan() {
        Locale locale = Locale.getDefault();
        if (locale != null) {
            return locale.getDisplayLanguage();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSystemLanguage() {
        String string2 = "";
        try {
            return Build.VERSION.SDK_INT >= 21 ? Locale.getDefault().toLanguageTag() : Locale.getDefault().toString();
        }
        catch (Throwable throwable) {}
        return string2;
    }

    public static String getDisplayMetrix(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n = displayMetrics.widthPixels;
        return n + "*" + displayMetrics.heightPixels;
    }

    public static int dp2px(Context context, float f2) {
        if (context != null) {
            float f3;
            try {
                f3 = context.getResources().getDisplayMetrics().densityDpi;
            }
            catch (Throwable throwable) {}
            return Math.round(f3 / 160.0f * f2);
        }
        return (int)f2;
    }

    public static boolean isTalkBackOn(Context object) {
        TextUtils.SimpleStringSplitter simpleStringSplitter;
        Context context = object;
        object = "TalkBackService";
        String string = "ScreenReaderService";
        TextUtils.SimpleStringSplitter simpleStringSplitter2 = simpleStringSplitter;
        simpleStringSplitter = new TextUtils.SimpleStringSplitter(':');
        String string2 = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"enabled_accessibility_services");
        if (string2 != null) {
            simpleStringSplitter2.setString(string2);
            while (simpleStringSplitter2.hasNext()) {
                string2 = simpleStringSplitter2.next();
                if (!string2.contains((CharSequence)object) && !string2.contains(string)) continue;
                return true;
            }
        }
        return false;
    }
}

