/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cert;

import java.io.Serializable;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.data.Country;

public class CVCPrincipal
implements Principal,
Serializable {
    public static final long serialVersionUID = -4905647207367309688L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public Country country;
    public String mnemonic;
    public String seqNumber;

    public CVCPrincipal(String string) {
        if (string != null) {
            if (string.length() >= 7 && string.length() <= 16) {
                final String string2 = string.substring(0, 2).toUpperCase();
                try {
                    this.country = Country.getInstance((String)string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.FINE, "Could not find country for " + string2, illegalArgumentException);
                    this.country = new Country(){
                        public static final long serialVersionUID = 345841304964161797L;

                        public int valueOf() {
                            return -1;
                        }

                        public String getName() {
                            return "Unknown";
                        }

                        public String getNationality() {
                            return "Unknown";
                        }

                        public String toAlpha2Code() {
                            return string2;
                        }

                        public String toAlpha3Code() {
                            return "XXX";
                        }
                    };
                }
                String string3 = string;
                String string4 = string;
                this.mnemonic = string4.substring(2, string4.length() - 5);
                this.seqNumber = string3.substring(string3.length() - 5, string.length());
                return;
            }
            throw new IllegalArgumentException("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found \"" + string + "\"");
        }
        throw new IllegalArgumentException("Name should be <Country (2F)><Mnemonic (9V)><SeqNum (5F)> formatted, found null");
    }

    public CVCPrincipal(Country country, String string, String string2) {
        if (string != null && string.length() <= 9) {
            if (string2 != null && string2.length() == 5) {
                this.country = country;
                this.mnemonic = string;
                this.seqNumber = string2;
                return;
            }
            throw new IllegalArgumentException("Wrong length seqNumber");
        }
        throw new IllegalArgumentException("Wrong length mnemonic");
    }

    @Override
    public String getName() {
        return this.country.toAlpha2Code() + this.mnemonic + this.seqNumber;
    }

    @Override
    public String toString() {
        return this.country.toAlpha2Code() + "/" + this.mnemonic + "/" + this.seqNumber;
    }

    public Country getCountry() {
        return this.country;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getSeqNumber() {
        return this.seqNumber;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!object.getClass().equals(CVCPrincipal.class)) {
            return false;
        }
        object = (CVCPrincipal)object;
        return ((CVCPrincipal)object).country.equals(this.country) && ((CVCPrincipal)object).mnemonic.equals(this.mnemonic) && ((CVCPrincipal)object).seqNumber.equals(this.seqNumber);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() * 2 + 1231211;
    }
}

