/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.io;

import java.io.InputStream;
import java.util.logging.Logger;

public class PositionInputStream
extends InputStream {
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public static final long MARK_NOT_SET = -1L;
    public InputStream carrier;
    public long position;
    public long markedPosition;

    public PositionInputStream(InputStream inputStream) {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier = inputStream;
        positionInputStream.position = 0L;
        positionInputStream.markedPosition = -1L;
    }

    @Override
    public int read() {
        int n2 = this.carrier.read();
        if (n2 >= 0) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.carrier.read(byArray, n2, n3);
        this.position += (long)n4;
        return n4;
    }

    @Override
    public long skip(long l2) {
        long l3 = this.carrier.skip(l2);
        if (l3 <= 0L) {
            LOGGER.warning("Carrier (" + this.carrier.getClass().getCanonicalName() + ")'s skip(" + l2 + ") only skipped " + l3 + ", position = " + this.position);
        }
        this.position += l3;
        return l3;
    }

    @Override
    public void mark(int n2) {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.mark(n2);
        positionInputStream.markedPosition = positionInputStream.position;
    }

    @Override
    public void reset() {
        PositionInputStream positionInputStream = this;
        positionInputStream.carrier.reset();
        positionInputStream.position = positionInputStream.markedPosition;
    }

    @Override
    public boolean markSupported() {
        return this.carrier.markSupported();
    }

    public long getPosition() {
        return this.position;
    }
}

