/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.lds.AbstractLDSFile;

public class CVCAFile
extends AbstractLDSFile {
    public static final long serialVersionUID = -1100904058684365703L;
    public static final byte CAR_TAG = 66;
    public static final int LENGTH = 36;
    public short fid;
    public String caReference = null;
    public String altCaReference = null;

    public CVCAFile(InputStream inputStream) {
        this(284, inputStream);
    }

    public CVCAFile(short s2, InputStream inputStream) {
        this.fid = s2;
        this.readObject(inputStream);
    }

    public CVCAFile(String string, String string2) {
        this(284, string, string2);
    }

    public CVCAFile(short s2, String string, String string2) {
        if (string != null && string.length() <= 16 && (string2 == null || string2.length() <= 16)) {
            this.fid = s2;
            this.caReference = string;
            this.altCaReference = string2;
            return;
        }
        throw new IllegalArgumentException();
    }

    public CVCAFile(short s2, String string) {
        this(s2, string, null);
    }

    public short getFID() {
        return this.fid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readObject(InputStream inputStream) {
        DataInputStream dataInputStream;
        DataInputStream dataInputStream2 = dataInputStream;
        int n2 = new DataInputStream(inputStream).read();
        if (n2 != 66) throw new IllegalArgumentException("Wrong tag, expected " + Integer.toHexString(66) + ", found " + Integer.toHexString(n2));
        n2 = dataInputStream2.read();
        if (n2 > 16) throw new IllegalArgumentException("Wrong length");
        byte[] byArray = new byte[n2];
        dataInputStream2.readFully(byArray);
        ((CVCAFile)object).caReference = new String(byArray);
        int n3 = dataInputStream2.read();
        if (n3 != 0 && n3 != -1) {
            if (n3 != 66) throw new IllegalArgumentException("Wrong tag");
            n3 = dataInputStream2.read();
            if (n3 > 16) throw new IllegalArgumentException("Wrong length");
            CVCAFile cVCAFile = object;
            byte[] byArray2 = new byte[n3];
            Object object = byArray2;
            dataInputStream2.readFully(byArray2);
            cVCAFile.altCaReference = new String((byte[])object);
            n3 = dataInputStream2.read();
        }
        while (n3 != -1) {
            if (n3 != 0) throw new IllegalArgumentException("Bad file padding");
            n3 = dataInputStream2.read();
        }
    }

    @Override
    public void writeObject(OutputStream outputStream) {
        CVCAFile cVCAFile = this;
        byte[] byArray = new byte[36];
        byte[] byArray2 = byArray;
        byArray2[0] = 66;
        byArray[1] = (byte)this.caReference.length();
        byte by = byArray2[1];
        System.arraycopy(cVCAFile.caReference.getBytes(), 0, byArray2, 2, by);
        String string = cVCAFile.altCaReference;
        if (string != null) {
            byte[] byArray3 = byArray2;
            int n2 = byArray3[1] + 2;
            byArray3[n2] = 66;
            int n3 = n2 + 1;
            byArray2[n3] = (byte)string.length();
            byte by2 = byArray2[n3];
            System.arraycopy(this.altCaReference.getBytes(), 0, byArray2, n2 += 2, by2);
        }
        outputStream.write(byArray2);
    }

    public CVCPrincipal getCAReference() {
        Object object;
        Object object2 = ((CVCAFile)object2).caReference;
        if (object2 == null) {
            object = object2 = null;
        } else {
            CVCPrincipal cVCPrincipal;
            object = cVCPrincipal;
            cVCPrincipal = new CVCPrincipal((String)object2);
        }
        return object;
    }

    public CVCPrincipal getAltCAReference() {
        Object object;
        Object object2 = ((CVCAFile)object2).altCaReference;
        if (object2 == null) {
            object = object2 = null;
        } else {
            CVCPrincipal cVCPrincipal;
            object = cVCPrincipal;
            cVCPrincipal = new CVCPrincipal((String)object2);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("CA reference: \"").append(((CVCAFile)((Object)string)).caReference).append("\"");
        String string = ((CVCAFile)((Object)string)).altCaReference != null ? ", Alternative CA reference: " + ((CVCAFile)((Object)string)).altCaReference : "";
        return stringBuilder.append(string).toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!CVCAFile.class.equals(object.getClass())) {
            return false;
        }
        object = (CVCAFile)object;
        return ((CVCAFile)this).caReference.equals(((CVCAFile)object).caReference) && (((CVCAFile)this).altCaReference == null && ((CVCAFile)object).altCaReference == null || (this = ((CVCAFile)this).altCaReference) != null && ((String)this).equals(((CVCAFile)object).altCaReference));
    }

    public int hashCode() {
        CVCAFile cVCAFile = this;
        int n2 = cVCAFile.caReference.hashCode() * 11;
        String string = cVCAFile.altCaReference;
        int n3 = string != null ? string.hashCode() * 13 : 0;
        return n2 + n3 + 5;
    }

    @Override
    public int getLength() {
        return 36;
    }
}

