/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds.icao;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.tlv.TLVInputStream;
import net.sf.scuba.tlv.TLVOutputStream;
import net.sf.scuba.tlv.TLVUtil;
import net.sf.scuba.util.Hex;
import org.jmrtd.lds.DataGroup;

public class DG11File
extends DataGroup {
    public static final long serialVersionUID = 8566312538928662937L;
    public static final int TAG_LIST_TAG = 92;
    public static final int FULL_NAME_TAG = 24334;
    public static final int OTHER_NAME_TAG = 24335;
    public static final int PERSONAL_NUMBER_TAG = 24336;
    public static final int FULL_DATE_OF_BIRTH_TAG = 24363;
    public static final int PLACE_OF_BIRTH_TAG = 24337;
    public static final int PERMANENT_ADDRESS_TAG = 24386;
    public static final int TELEPHONE_TAG = 24338;
    public static final int PROFESSION_TAG = 24339;
    public static final int TITLE_TAG = 24340;
    public static final int PERSONAL_SUMMARY_TAG = 24341;
    public static final int PROOF_OF_CITIZENSHIP_TAG = 24342;
    public static final int OTHER_VALID_TD_NUMBERS_TAG = 24343;
    public static final int CUSTODY_INFORMATION_TAG = 24344;
    public static final int CONTENT_SPECIFIC_CONSTRUCTED_TAG = 160;
    public static final int COUNT_TAG = 2;
    public static final String SDF = "yyyyMMdd";
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public String nameOfHolder;
    public List<String> otherNames;
    public String personalNumber;
    public String fullDateOfBirth;
    public List<String> placeOfBirth;
    public List<String> permanentAddress;
    public String telephone;
    public String profession;
    public String title;
    public String personalSummary;
    public byte[] proofOfCitizenship;
    public List<String> otherValidTDNumbers;
    public String custodyInformation;
    public List<Integer> tagPresenceList;

    public DG11File(InputStream inputStream) {
        super(107, inputStream);
    }

    public DG11File(String string, List<String> list, String string2, Date date, List<String> list2, List<String> list3, String string3, String string4, String string5, String string6, byte[] byArray, List<String> list4, String string7) {
        this(string, list, string2, new SimpleDateFormat(SDF).format(date), list2, list3, string3, string4, string5, string6, byArray, list4, string7);
    }

    public DG11File(String object, List<String> list, String string, String string2, List<String> list2, List<String> list3, String string3, String string4, String string5, String string6, byte[] byArray, List<String> list4, String string7) {
        super(107);
        this.nameOfHolder = object;
        if (list == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list);
        }
        this.otherNames = object;
        this.personalNumber = string;
        this.fullDateOfBirth = string2;
        if (list2 == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list2);
        }
        this.placeOfBirth = object;
        this.permanentAddress = list3;
        this.telephone = string3;
        this.profession = string4;
        this.title = string5;
        this.personalSummary = string6;
        this.proofOfCitizenship = byArray;
        if (list4 == null) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            ArrayList<String> arrayList;
            object = arrayList;
            arrayList = new ArrayList<String>(list4);
        }
        this.otherValidTDNumbers = object;
        this.custodyInformation = string7;
    }

    private void parseCustodyInformation(byte[] byArray) {
        try {
            this.custodyInformation = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.custodyInformation = new String(byArray).trim();
        }
    }

    private void parseOtherValidTDNumbers(byte[] object) {
        StringTokenizer stringTokenizer;
        String string;
        String string2 = new String((byte[])object).trim();
        String string3 = string;
        try {
            string = new String((byte[])object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string3 = string2;
        }
        this.otherValidTDNumbers = new ArrayList<String>();
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer(string3, "<");
        while (((StringTokenizer)object).hasMoreTokens()) {
            string2 = ((StringTokenizer)object).nextToken().trim();
            this.otherValidTDNumbers.add(string2);
        }
    }

    private void parseProofOfCitizenShip(byte[] byArray) {
        this.proofOfCitizenship = byArray;
    }

    private void parsePersonalSummary(byte[] byArray) {
        try {
            this.personalSummary = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.personalSummary = new String(byArray).trim();
        }
    }

    private void parseTitle(byte[] byArray) {
        try {
            this.title = new String(byArray, "UTF-8").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.title = new String(byArray).trim();
        }
    }

    private void parseProfession(byte[] byArray) {
        String string;
        String string2;
        String string3 = string2;
        string2 = new String(byArray);
        String string4 = string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        this.profession = string4.trim();
    }

    private void parseTelephone(byte[] byArray) {
        String string;
        String string2;
        String string3 = string2;
        string2 = new String(byArray);
        String string4 = string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        this.telephone = string4.replace("<", " ").trim();
    }

    private void parsePermanentAddress(byte[] object) {
        StringTokenizer stringTokenizer;
        String string;
        String string2;
        String string3 = string2;
        string2 = new String((byte[])object);
        String string4 = string;
        try {
            string = new String((byte[])object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer(string4, "<");
        this.permanentAddress = new ArrayList<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            string3 = ((StringTokenizer)object).nextToken().trim();
            this.permanentAddress.add(string3);
        }
    }

    private void parsePlaceOfBirth(byte[] object) {
        StringTokenizer stringTokenizer;
        String string;
        String string2;
        String string3 = string2;
        string2 = new String((byte[])object);
        String string4 = string;
        try {
            string = new String((byte[])object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        object = stringTokenizer;
        stringTokenizer = new StringTokenizer(string4, "<");
        this.placeOfBirth = new ArrayList<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            string3 = ((StringTokenizer)object).nextToken().trim();
            this.placeOfBirth.add(string3);
        }
    }

    private void parseFullDateOfBirth(byte[] object) {
        Object object2;
        if (((byte[])object).length == 4) {
            object2 = object = (Object)Hex.bytesToHexString((byte[])object);
        } else {
            String string;
            String string2;
            String string3 = string2;
            string2 = new String((byte[])object);
            object2 = string;
            try {
                string = new String((byte[])object, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
                object2 = string3;
            }
        }
        this.fullDateOfBirth = object2;
    }

    private synchronized void parseOtherName(byte[] byArray) {
        String string;
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }
        DG11File dG11File = this;
        String string2 = string;
        try {
            string = new String(byArray, "UTF-8");
            dG11File.otherNames.add(string2.trim());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            this.otherNames.add(new String(byArray).trim());
        }
    }

    private void parsePersonalNumber(byte[] byArray) {
        String string;
        String string2;
        String string3 = string2;
        string2 = new String(byArray);
        String string4 = string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        this.personalNumber = string4.trim();
    }

    private void parseNameOfHolder(byte[] byArray) {
        String string;
        String string2;
        String string3 = string2;
        string2 = new String(byArray);
        String string4 = string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.log(Level.WARNING, "Exception", unsupportedEncodingException);
            string4 = string3;
        }
        this.nameOfHolder = string4.trim();
    }

    private void readField(int n2, TLVInputStream tLVInputStream) {
        int n3;
        block27: {
            block26: {
                block22: {
                    block23: {
                        block24: {
                            byte[] byArray;
                            block25: {
                                n3 = tLVInputStream.readTag();
                                if (n3 != 160) break block22;
                                TLVInputStream tLVInputStream2 = tLVInputStream;
                                tLVInputStream2.readLength();
                                n2 = tLVInputStream2.readTag();
                                if (n2 != 2) break block23;
                                n2 = tLVInputStream.readLength();
                                if (n2 != 1) break block24;
                                byArray = tLVInputStream.readValue();
                                if (byArray == null || byArray.length != 1) break block25;
                                int n4 = byArray[0] & 0xFF;
                                for (n3 = 0; n3 < n4; ++n3) {
                                    int n5 = tLVInputStream.readTag();
                                    if (n5 == 24335) {
                                        TLVInputStream tLVInputStream3 = tLVInputStream;
                                        tLVInputStream3.readLength();
                                        this.parseOtherName(tLVInputStream3.readValue());
                                        continue;
                                    }
                                    throw new IllegalArgumentException("Expected " + Integer.toHexString(24335) + ", found " + Integer.toHexString(n5));
                                }
                                break block26;
                            }
                            throw new IllegalArgumentException("Number of content specific fields should be encoded in single byte, found " + Arrays.toString(byArray));
                        }
                        throw new IllegalArgumentException("Expected length 1 count length, found " + n2);
                    }
                    throw new IllegalArgumentException("Expected " + Integer.toHexString(2) + ", found " + Integer.toHexString(n2));
                }
                if (n3 != n2) break block27;
                TLVInputStream tLVInputStream4 = tLVInputStream;
                tLVInputStream4.readLength();
                byte[] byArray = tLVInputStream4.readValue();
                if (n3 != 24363) {
                    if (n3 != 24386) {
                        switch (n3) {
                            default: {
                                throw new IllegalArgumentException("Unknown field tag in DG11: " + Integer.toHexString(n3));
                            }
                            case 24344: {
                                this.parseCustodyInformation(byArray);
                                break;
                            }
                            case 24343: {
                                this.parseOtherValidTDNumbers(byArray);
                                break;
                            }
                            case 24342: {
                                this.parseProofOfCitizenShip(byArray);
                                break;
                            }
                            case 24341: {
                                this.parsePersonalSummary(byArray);
                                break;
                            }
                            case 24340: {
                                this.parseTitle(byArray);
                                break;
                            }
                            case 24339: {
                                this.parseProfession(byArray);
                                break;
                            }
                            case 24338: {
                                this.parseTelephone(byArray);
                                break;
                            }
                            case 24337: {
                                this.parsePlaceOfBirth(byArray);
                                break;
                            }
                            case 24336: {
                                this.parsePersonalNumber(byArray);
                                break;
                            }
                            case 24335: {
                                this.parseOtherName(byArray);
                                break;
                            }
                            case 24334: {
                                this.parseNameOfHolder(byArray);
                                break;
                            }
                        }
                    } else {
                        this.parsePermanentAddress(byArray);
                    }
                } else {
                    this.parseFullDateOfBirth(byArray);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Expected " + Integer.toHexString(n2) + ", but found " + Integer.toHexString(n3));
    }

    @Override
    public int getTag() {
        return 107;
    }

    public List<Integer> getTagPresenceList() {
        List<Object> list = this.tagPresenceList;
        if (list != null) {
            return list;
        }
        this.tagPresenceList = new ArrayList<Integer>(12);
        if (this.nameOfHolder != null) {
            this.tagPresenceList.add(24334);
        }
        if ((list = this.otherNames) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24335);
        }
        if (this.personalNumber != null) {
            this.tagPresenceList.add(24336);
        }
        if (this.fullDateOfBirth != null) {
            this.tagPresenceList.add(24363);
        }
        if ((list = this.placeOfBirth) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24337);
        }
        if ((list = this.permanentAddress) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24386);
        }
        if (this.telephone != null) {
            this.tagPresenceList.add(24338);
        }
        if (this.profession != null) {
            this.tagPresenceList.add(24339);
        }
        if (this.title != null) {
            this.tagPresenceList.add(24340);
        }
        if (this.personalSummary != null) {
            this.tagPresenceList.add(24341);
        }
        if (this.proofOfCitizenship != null) {
            this.tagPresenceList.add(24342);
        }
        if ((list = this.otherValidTDNumbers) != null && !list.isEmpty()) {
            this.tagPresenceList.add(24343);
        }
        if (this.custodyInformation != null) {
            this.tagPresenceList.add(24344);
        }
        return this.tagPresenceList;
    }

    public String getNameOfHolder() {
        return this.nameOfHolder;
    }

    public List<String> getOtherNames() {
        Object object;
        List<String> list = ((DG11File)((Object)list)).otherNames;
        if (list == null) {
            ArrayList arrayList;
            list = arrayList;
            arrayList = new ArrayList();
            object = list;
        } else {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList(list);
        }
        return object;
    }

    public String getPersonalNumber() {
        return this.personalNumber;
    }

    public String getFullDateOfBirth() {
        return this.fullDateOfBirth;
    }

    public List<String> getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public List<String> getPermanentAddress() {
        return this.permanentAddress;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getProfession() {
        return this.profession;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPersonalSummary() {
        return this.personalSummary;
    }

    public byte[] getProofOfCitizenship() {
        return this.proofOfCitizenship;
    }

    public List<String> getOtherValidTDNumbers() {
        return this.otherValidTDNumbers;
    }

    public String getCustodyInformation() {
        return this.custodyInformation;
    }

    @Override
    public String toString() {
        CharSequence charSequence = new StringBuilder().append("DG11File [");
        Object object = ((DG11File)serializable).nameOfHolder;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).otherNames;
        object = object != null && !object.isEmpty() ? ((DG11File)serializable).otherNames : "[]";
        charSequence = charSequence.append(object).append(", ");
        object = ((DG11File)serializable).personalNumber;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).fullDateOfBirth;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).placeOfBirth;
        object = object != null && !object.isEmpty() ? ((DG11File)serializable).placeOfBirth.toString() : "[]";
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).permanentAddress;
        object = object != null && !object.isEmpty() ? ((DG11File)serializable).permanentAddress.toString() : "[]";
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).telephone;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).profession;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).title;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).personalSummary;
        if (object == null) {
            object = "";
        }
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).proofOfCitizenship == null ? "" : "image (" + ((DG11File)serializable).proofOfCitizenship.length + ")";
        charSequence = charSequence.append((String)object).append(", ");
        object = ((DG11File)serializable).otherValidTDNumbers;
        object = object != null && !object.isEmpty() ? ((DG11File)serializable).otherValidTDNumbers.toString() : "[]";
        DG11File dG11File = serializable;
        Serializable serializable = charSequence.append((String)object).append(", ");
        charSequence = dG11File.custodyInformation;
        if (charSequence == null) {
            charSequence = "";
        }
        return ((StringBuilder)serializable).append((String)charSequence).append("]").toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == dG11File2) {
            return true;
        }
        if (!object.getClass().equals(DG11File.class)) {
            return false;
        }
        DG11File dG11File = dG11File2;
        DG11File dG11File2 = (DG11File)object;
        return dG11File.toString().equals(dG11File2.toString());
    }

    public int hashCode() {
        return this.toString().hashCode() * 13 + 111;
    }

    @Override
    public void readContent(InputStream inputStream) {
        Object object;
        if (inputStream instanceof TLVInputStream) {
            inputStream = (TLVInputStream)inputStream;
            object = inputStream;
        } else {
            TLVInputStream tLVInputStream;
            object = tLVInputStream;
            tLVInputStream = new TLVInputStream(inputStream);
        }
        if (object.readTag() == 92) {
            ArrayList<Integer> arrayList;
            ByteArrayInputStream byteArrayInputStream;
            int n2 = object.readLength();
            int n3 = 0;
            int n4 = n2 / 2;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream(object.readValue());
            ArrayList<Integer> arrayList2 = arrayList;
            arrayList = new ArrayList<Integer>(n4 + 1);
            while (n3 < n2) {
                int n5 = n3;
                n3 = new TLVInputStream((InputStream)byteArrayInputStream2).readTag();
                n4 = n5 + TLVUtil.getTagLength((int)n3);
                arrayList2.add(n3);
                n3 = n4;
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                this.readField((Integer)iterator.next(), (TLVInputStream)object);
            }
            return;
        }
        throw new IllegalArgumentException("Expected tag list in DG11");
    }

    @Override
    public void writeContent(OutputStream object) {
        DataOutputStream dataOutputStream;
        Object object2;
        if (object instanceof TLVOutputStream) {
            object = (TLVOutputStream)object;
            object2 = object;
        } else {
            TLVOutputStream tLVOutputStream;
            object2 = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream((OutputStream)object);
        }
        object2.writeTag(92);
        object = dataOutputStream;
        dataOutputStream = new DataOutputStream((OutputStream)object2);
        List<Integer> list = this.getTagPresenceList();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            ((DataOutputStream)object).writeShort(object3.next());
        }
        ((DataOutputStream)object).flush();
        object2.writeValueEnd();
        object = list.iterator();
        block14: while (object.hasNext()) {
            int n2 = (Integer)object.next();
            if (n2 != 24363) {
                if (n2 != 24386) {
                    switch (n2) {
                        default: {
                            throw new IllegalStateException("Unknown tag in DG11: " + Integer.toHexString(n2));
                        }
                        case 24344: {
                            object2.writeTag(n2);
                            object2.writeValue(this.custodyInformation.trim().replace(' ', '<').getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24343: {
                            object2.writeTag(n2);
                            n2 = 1;
                            for (String string : this.otherValidTDNumbers) {
                                if (string == null) continue;
                                if (n2 != 0) {
                                    n2 = 0;
                                } else {
                                    object2.write(60);
                                }
                                object2.write(string.trim().replace(' ', '<').getBytes("UTF-8"));
                            }
                            object2.writeValueEnd();
                            continue block14;
                        }
                        case 24342: {
                            object2.writeTag(n2);
                            object2.writeValue(this.proofOfCitizenship);
                            continue block14;
                        }
                        case 24341: {
                            object2.writeTag(n2);
                            object2.writeValue(this.personalSummary.trim().replace(' ', '<').getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24340: {
                            object2.writeTag(n2);
                            object2.writeValue(this.title.trim().replace(' ', '<').getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24339: {
                            object2.writeTag(n2);
                            object2.writeValue(this.profession.trim().replace(' ', '<').getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24338: {
                            object2.writeTag(n2);
                            object2.writeValue(this.telephone.trim().replace(' ', '<').getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24337: {
                            object2.writeTag(n2);
                            n2 = 1;
                            for (String string : this.placeOfBirth) {
                                if (string == null) continue;
                                if (n2 != 0) {
                                    n2 = 0;
                                } else {
                                    object2.write(60);
                                }
                                object2.write(string.trim().getBytes("UTF-8"));
                            }
                            object2.writeValueEnd();
                            continue block14;
                        }
                        case 24336: {
                            object2.writeTag(n2);
                            object2.writeValue(this.personalNumber.trim().getBytes("UTF-8"));
                            continue block14;
                        }
                        case 24335: {
                            if (this.otherNames == null) {
                                this.otherNames = new ArrayList<String>();
                            }
                            Object object4 = object2;
                            Object object5 = object2;
                            object5.writeTag(160);
                            object5.writeTag(2);
                            object4.write(this.otherNames.size());
                            object4.writeValueEnd();
                            Iterator<String> iterator = this.otherNames.iterator();
                            while (iterator.hasNext()) {
                                Object object6 = object2;
                                object3 = iterator.next();
                                object6.writeTag(24335);
                                object6.writeValue(((String)object3).trim().getBytes("UTF-8"));
                            }
                            object2.writeValueEnd();
                            continue block14;
                        }
                        case 24334: 
                    }
                    object2.writeTag(n2);
                    object2.writeValue(this.nameOfHolder.trim().getBytes("UTF-8"));
                    continue;
                }
                object2.writeTag(n2);
                n2 = 1;
                for (String string : this.permanentAddress) {
                    if (string == null) continue;
                    if (n2 != 0) {
                        n2 = 0;
                    } else {
                        object2.write(60);
                    }
                    object2.write(string.trim().getBytes("UTF-8"));
                }
                object2.writeValueEnd();
                continue;
            }
            object2.writeTag(n2);
            object2.writeValue(this.fullDateOfBirth.getBytes("UTF-8"));
        }
    }
}

