/*
 * Decompiled with CFR 0.152.
 */
package org.eid_bc.bouncycastle.pqc.jcajce.provider.xmss;

import java.io.IOException;
import java.security.PublicKey;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eid_bc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.eid_bc.bouncycastle.crypto.CipherParameters;
import org.eid_bc.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.eid_bc.bouncycastle.pqc.asn1.XMSSKeyParams;
import org.eid_bc.bouncycastle.pqc.asn1.XMSSPublicKey;
import org.eid_bc.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import org.eid_bc.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import org.eid_bc.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import org.eid_bc.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import org.eid_bc.bouncycastle.util.Arrays;

public class BCXMSSPublicKey
implements PublicKey,
XMSSKey {
    private final XMSSPublicKeyParameters keyParams;
    private final ASN1ObjectIdentifier treeDigest;

    public BCXMSSPublicKey(ASN1ObjectIdentifier treeDigest, XMSSPublicKeyParameters keyParams) {
        this.treeDigest = treeDigest;
        this.keyParams = keyParams;
    }

    public BCXMSSPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        XMSSKeyParams keyParams = XMSSKeyParams.getInstance(keyInfo.getAlgorithm().getParameters());
        this.treeDigest = keyParams.getTreeDigest().getAlgorithm();
        XMSSPublicKey xmssPublicKey = XMSSPublicKey.getInstance(keyInfo.parsePublicKey());
        this.keyParams = new XMSSPublicKeyParameters.Builder(new XMSSParameters(keyParams.getHeight(), DigestUtil.getDigest(this.treeDigest))).withPublicSeed(xmssPublicKey.getPublicSeed()).withRoot(xmssPublicKey.getRoot()).build();
    }

    @Override
    public final String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(this.keyParams.getParameters().getHeight(), new AlgorithmIdentifier(this.treeDigest)));
            SubjectPublicKeyInfo pki = new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(this.keyParams.getPublicSeed(), this.keyParams.getRoot()));
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCXMSSPublicKey) {
            BCXMSSPublicKey otherKey = (BCXMSSPublicKey)o;
            return this.treeDigest.equals(otherKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), otherKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }
}

