/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.CVCAuthenticatedRequest;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CVCertificateBody;
import org.ejbca.cvc.GenericPublicKeyField;

public class SequenceFactory {
    public static AbstractSequence createSequence(CVCTagEnum cVCTagEnum) {
        if (cVCTagEnum.isSequence()) {
            switch (cVCTagEnum) {
                default: {
                    throw new IllegalArgumentException("Unsupported type " + (Object)((Object)cVCTagEnum));
                }
                case REQ_AUTHENTICATION: {
                    return new CVCAuthenticatedRequest();
                }
                case HOLDER_AUTH_TEMPLATE: {
                    return new CVCAuthorizationTemplate();
                }
                case PUBLIC_KEY: {
                    return new GenericPublicKeyField();
                }
                case CERTIFICATE_BODY: {
                    return new CVCertificateBody();
                }
                case CV_CERTIFICATE: 
            }
            return new CVCertificate();
        }
        throw new IllegalArgumentException("Tag " + (Object)((Object)cVCTagEnum) + " is not a sequence");
    }
}

