/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.lds;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.PublicKey;
import org.eid_bc.bouncycastle.asn1.ASN1Encodable;
import org.eid_bc.bouncycastle.asn1.ASN1EncodableVector;
import org.eid_bc.bouncycastle.asn1.ASN1Integer;
import org.eid_bc.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.eid_bc.bouncycastle.asn1.ASN1Primitive;
import org.eid_bc.bouncycastle.asn1.DLSequence;
import org.jmrtd.Util;
import org.jmrtd.lds.SecurityInfo;

public class ChipAuthenticationPublicKeyInfo
extends SecurityInfo {
    public static final long serialVersionUID = 5687291829854501771L;
    public String oid;
    public BigInteger keyId;
    public PublicKey publicKey;

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey) {
        this(publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(PublicKey publicKey, BigInteger bigInteger) {
        this(Util.inferProtocolIdentifier(publicKey), publicKey, bigInteger);
    }

    public ChipAuthenticationPublicKeyInfo(String string, PublicKey publicKey) {
        this(string, publicKey, null);
    }

    public ChipAuthenticationPublicKeyInfo(String string, PublicKey publicKey, BigInteger bigInteger) {
        this.oid = string;
        this.publicKey = Util.reconstructPublicKey(publicKey);
        this.keyId = bigInteger;
        this.checkFields();
    }

    public static boolean checkRequiredIdentifier(String string) {
        return SecurityInfo.ID_PK_DH.equals(string) || SecurityInfo.ID_PK_ECDH.equals(string);
    }

    public static String toProtocolOIDString(String string) {
        if (SecurityInfo.ID_PK_DH.equals(string)) {
            string = "id-PK-DH";
        } else if (SecurityInfo.ID_PK_ECDH.equals(string)) {
            string = "id-PK-ECDH";
        }
        return string;
    }

    @Override
    @Deprecated
    public ASN1Primitive getDERObject() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3();
        aSN1EncodableVector3.add((ASN1Encodable)new ASN1ObjectIdentifier(serializable.oid));
        aSN1EncodableVector.add((ASN1Encodable)Util.toSubjectPublicKeyInfo(serializable.publicKey).toASN1Primitive());
        Serializable serializable = serializable.keyId;
        if (serializable != null) {
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1Integer((BigInteger)serializable));
        }
        return new DLSequence(aSN1EncodableVector2);
    }

    @Override
    public String getObjectIdentifier() {
        return this.oid;
    }

    @Override
    public String getProtocolOIDString() {
        return ChipAuthenticationPublicKeyInfo.toProtocolOIDString(this.oid);
    }

    public BigInteger getKeyId() {
        return this.keyId;
    }

    public PublicKey getSubjectPublicKey() {
        return this.publicKey;
    }

    public void checkFields() {
        block3: {
            try {
                if (!ChipAuthenticationPublicKeyInfo.checkRequiredIdentifier(this.oid)) break block3;
                return;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Malformed ChipAuthenticationInfo", exception);
            }
        }
        throw new IllegalArgumentException("Wrong identifier: " + this.oid);
    }

    public String toString() {
        ChipAuthenticationPublicKeyInfo chipAuthenticationPublicKeyInfo = serializable;
        Serializable serializable = new StringBuilder().append("ChipAuthenticationPublicKeyInfo [protocol: ").append(ChipAuthenticationPublicKeyInfo.toProtocolOIDString(((ChipAuthenticationPublicKeyInfo)serializable).oid)).append(", chipAuthenticationPublicKey: ").append(Util.getDetailedPublicKeyAlgorithm(((ChipAuthenticationPublicKeyInfo)serializable).getSubjectPublicKey())).append(", keyId: ");
        Object object = chipAuthenticationPublicKeyInfo.keyId;
        object = object == null ? "-" : ((BigInteger)object).toString();
        return ((StringBuilder)serializable).append((String)object).append("]").toString();
    }

    public int hashCode() {
        ChipAuthenticationPublicKeyInfo chipAuthenticationPublicKeyInfo = this;
        int n2 = 123;
        int n3 = 1337;
        int n4 = chipAuthenticationPublicKeyInfo.oid.hashCode();
        BigInteger bigInteger = chipAuthenticationPublicKeyInfo.keyId;
        int n5 = bigInteger == null ? 111 : bigInteger.hashCode();
        int n6 = n4 + n5;
        PublicKey publicKey = this.publicKey;
        int n7 = publicKey == null ? 111 : publicKey.hashCode();
        return (n6 + n7) * n3 + n2;
    }

    public boolean equals(Object object) {
        BigInteger bigInteger;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!ChipAuthenticationPublicKeyInfo.class.equals(object.getClass())) {
            return false;
        }
        object = (ChipAuthenticationPublicKeyInfo)object;
        return this.oid.equals(((ChipAuthenticationPublicKeyInfo)object).oid) && (this.keyId == null && ((ChipAuthenticationPublicKeyInfo)object).keyId == null || (bigInteger = this.keyId) != null && bigInteger.equals(((ChipAuthenticationPublicKeyInfo)object).keyId)) && this.publicKey.equals(((ChipAuthenticationPublicKeyInfo)object).publicKey);
    }
}

