/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.cbeff;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.scuba.tlv.TLVOutputStream;
import org.jmrtd.cbeff.BiometricDataBlock;
import org.jmrtd.cbeff.BiometricDataBlockEncoder;
import org.jmrtd.cbeff.CBEFFInfo;
import org.jmrtd.cbeff.ComplexCBEFFInfo;
import org.jmrtd.cbeff.ISO781611;
import org.jmrtd.cbeff.SimpleCBEFFInfo;

public class ISO781611Encoder<B extends BiometricDataBlock>
implements ISO781611 {
    public BiometricDataBlockEncoder<B> bdbEncoder;

    public ISO781611Encoder(BiometricDataBlockEncoder<B> biometricDataBlockEncoder) {
        this.bdbEncoder = biometricDataBlockEncoder;
    }

    private void writeBITGroup(List<CBEFFInfo> list, OutputStream outputStream) {
        Object object;
        if (outputStream instanceof TLVOutputStream) {
            outputStream = (TLVOutputStream)outputStream;
            object = outputStream;
        } else {
            TLVOutputStream tLVOutputStream;
            object = tLVOutputStream;
            tLVOutputStream = new TLVOutputStream(outputStream);
        }
        Object object2 = object;
        object2.writeTag(32609);
        object2.writeTag(2);
        int n2 = list.size();
        object.writeValue(new byte[]{(byte)n2});
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeBIT((TLVOutputStream)object, i2, (SimpleCBEFFInfo)list.get(i2));
        }
        object.writeValueEnd();
    }

    private void writeBIT(TLVOutputStream tLVOutputStream, int n2, SimpleCBEFFInfo<B> simpleCBEFFInfo) {
        tLVOutputStream.writeTag(32608);
        this.writeBHT(tLVOutputStream, n2, simpleCBEFFInfo);
        this.writeBiometricDataBlock(tLVOutputStream, simpleCBEFFInfo.getBiometricDataBlock());
        tLVOutputStream.writeValueEnd();
    }

    private void writeBHT(TLVOutputStream tLVOutputStream, int n2, SimpleCBEFFInfo<B> simpleCBEFFInfo) {
        tLVOutputStream.writeTag(161);
        Iterator<Map.Entry<Integer, byte[]>> iterator = simpleCBEFFInfo.getBiometricDataBlock().getStandardBiometricHeader().getElements().entrySet().iterator();
        while (iterator.hasNext()) {
            TLVOutputStream tLVOutputStream2 = tLVOutputStream;
            Map.Entry entry = (Map.Entry)iterator.next();
            tLVOutputStream2.writeTag(((Integer)entry.getKey()).intValue());
            tLVOutputStream2.writeValue((byte[])entry.getValue());
        }
        tLVOutputStream.writeValueEnd();
    }

    private void writeBiometricDataBlock(TLVOutputStream tLVOutputStream, B b2) {
        tLVOutputStream.writeTag(24366);
        this.bdbEncoder.encode(b2, (OutputStream)tLVOutputStream);
        tLVOutputStream.writeValueEnd();
    }

    public void encode(CBEFFInfo cBEFFInfo, OutputStream outputStream) {
        if (cBEFFInfo instanceof SimpleCBEFFInfo) {
            this.writeBITGroup(Arrays.asList(cBEFFInfo), outputStream);
        } else if (cBEFFInfo instanceof ComplexCBEFFInfo) {
            this.writeBITGroup(((ComplexCBEFFInfo)cBEFFInfo).getSubRecords(), outputStream);
        }
    }
}

