/*
 * Decompiled with CFR 0.152.
 */
package org.jmrtd.protocol;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.scuba.util.Hex;
import org.jmrtd.Util;
import org.jmrtd.cert.CVCPrincipal;
import org.jmrtd.cert.CardVerifiableCertificate;
import org.jmrtd.protocol.EACCAResult;

public class EACTAResult
implements Serializable {
    public static final long serialVersionUID = -2926063872890928748L;
    public static final Logger LOGGER = Logger.getLogger("org.jmrtd");
    public EACCAResult chipAuthenticationResult;
    public CVCPrincipal caReference;
    public List<CardVerifiableCertificate> terminalCertificates = new ArrayList<CardVerifiableCertificate>();
    public PrivateKey terminalKey;
    public String documentNumber;
    public byte[] cardChallenge;

    /*
     * WARNING - void declaration
     */
    public EACTAResult(EACCAResult object, CVCPrincipal serializable2, List<CardVerifiableCertificate> list, PrivateKey privateKey, String string, byte[] byArray) {
        void var6_8;
        void var5_7;
        void var4_6;
        void var3_5;
        this.chipAuthenticationResult = object;
        this.caReference = serializable2;
        for (CardVerifiableCertificate cardVerifiableCertificate : var3_5) {
            this.terminalCertificates.add(cardVerifiableCertificate);
        }
        this.terminalKey = var4_6;
        this.documentNumber = var5_7;
        this.cardChallenge = var6_8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object toString(CardVerifiableCertificate serializable) {
        block2: {
            StringBuilder stringBuilder;
            EACTAResult eACTAResult = serializable2;
            Serializable serializable2 = stringBuilder;
            new StringBuilder().append("CardVerifiableCertificate [");
            try {
                CVCPrincipal cVCPrincipal = ((CardVerifiableCertificate)serializable).getHolderReference();
                if (eACTAResult.caReference.equals(cVCPrincipal)) break block2;
                ((StringBuilder)serializable2).append("holderReference: " + cVCPrincipal);
            }
            catch (CertificateException certificateException) {
                ((StringBuilder)serializable2).append("holderReference = ???");
                LOGGER.log(Level.WARNING, "Exception", certificateException);
            }
        }
        Serializable serializable3 = serializable2;
        ((StringBuilder)serializable3).append("]");
        return ((StringBuilder)serializable3).toString();
    }

    public EACCAResult getChipAuthenticationResult() {
        return this.chipAuthenticationResult;
    }

    public CVCPrincipal getCAReference() {
        return this.caReference;
    }

    public List<CardVerifiableCertificate> getCVCertificates() {
        return this.terminalCertificates;
    }

    public PrivateKey getTerminalKey() {
        return this.terminalKey;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public byte[] getCardChallenge() {
        return this.cardChallenge;
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("TAResult [chipAuthenticationResult: " + this.chipAuthenticationResult).append(", ");
        stringBuilder2.append("caReference: " + this.caReference).append(", ");
        stringBuilder2.append("terminalCertificates: [");
        boolean bl = true;
        for (CardVerifiableCertificate cardVerifiableCertificate : this.terminalCertificates) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(this.toString(cardVerifiableCertificate));
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append("terminalKey = ").append(Util.getDetailedPrivateKeyAlgorithm(this.terminalKey)).append(", ");
        stringBuilder3.append("documentNumber = ").append(this.documentNumber).append(", ");
        stringBuilder3.append("cardChallenge = ").append(Hex.bytesToHexString((byte[])this.cardChallenge)).append(", ");
        stringBuilder3.append("]");
        return stringBuilder3.toString();
    }

    public int hashCode() {
        int n2 = 31;
        CVCPrincipal cVCPrincipal = this.caReference;
        int n3 = cVCPrincipal == null ? 0 : cVCPrincipal.hashCode();
        n2 = ((n2 + n3) * 31 + Arrays.hashCode(this.cardChallenge)) * 31;
        EACCAResult eACCAResult = this.chipAuthenticationResult;
        int n4 = eACCAResult == null ? 0 : eACCAResult.hashCode();
        n2 = (n2 + n4) * 31;
        String string = this.documentNumber;
        int n5 = string == null ? 0 : string.hashCode();
        n2 = (n2 + n5) * 31;
        List<CardVerifiableCertificate> list = this.terminalCertificates;
        int n6 = list == null ? 0 : list.hashCode();
        int n7 = (n2 + n6) * 31;
        PrivateKey privateKey = this.terminalKey;
        int n8 = privateKey == null ? 0 : privateKey.hashCode();
        return n7 + n8;
    }

    public boolean equals(Object object) {
        if (serializable == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (EACTAResult.class != object.getClass()) {
            return false;
        }
        object = (EACTAResult)object;
        List<CardVerifiableCertificate> list = ((EACTAResult)serializable).caReference;
        if (list == null ? ((EACTAResult)object).caReference != null : !((CVCPrincipal)((Object)list)).equals(((EACTAResult)object).caReference)) {
            return false;
        }
        if (!Arrays.equals(((EACTAResult)serializable).cardChallenge, ((EACTAResult)object).cardChallenge)) {
            return false;
        }
        list = ((EACTAResult)serializable).chipAuthenticationResult;
        if (list == null ? ((EACTAResult)object).chipAuthenticationResult != null : !((EACCAResult)((Object)list)).equals(((EACTAResult)object).chipAuthenticationResult)) {
            return false;
        }
        list = ((EACTAResult)serializable).documentNumber;
        if (list == null ? ((EACTAResult)object).documentNumber != null : !((String)((Object)list)).equals(((EACTAResult)object).documentNumber)) {
            return false;
        }
        list = ((EACTAResult)serializable).terminalCertificates;
        if (list == null ? ((EACTAResult)object).terminalCertificates != null : !list.equals(((EACTAResult)object).terminalCertificates)) {
            return false;
        }
        Serializable serializable = ((EACTAResult)serializable).terminalKey;
        return serializable == null ? ((EACTAResult)object).terminalKey == null : serializable.equals(((EACTAResult)object).terminalKey);
    }
}

