/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.camera.utils;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Window;

public class DisplayUtil {
    public static int STATUS_BAR_HEIGHT = 0;

    public static Point getScreenMetrics(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        return new Point(n, n2);
    }

    public static float getScreenRate(Context context) {
        context = DisplayUtil.getScreenMetrics(context);
        return (float)context.y / (float)context.x;
    }

    public static int dip2px(Context context, float f2) {
        return (int)(f2 * context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static int px2dip(Context context, float f2) {
        return (int)(f2 / context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public static void immersiveStatusBar(Window window) {
        if (window != null) {
            if (Build.VERSION.SDK_INT >= 28) {
                Window window2 = window;
                window2.getAttributes().layoutInDisplayCutoutMode = 1;
                window2.setAttributes(window2.getAttributes());
            }
            if (Build.VERSION.SDK_INT >= 21) {
                Window window3 = window;
                window3.clearFlags(0x4000000);
                window3.getDecorView().setSystemUiVisibility(1280);
                window3.addFlags(Integer.MIN_VALUE);
            }
        }
    }

    public static int getStatusBarHeight(Context context) {
        if (context != null && STATUS_BAR_HEIGHT == 0) {
            Context context2 = context;
            int n = context2.getResources().getIdentifier("status_bar_height", "dimen", "android");
            STATUS_BAR_HEIGHT = DisplayUtil.px2dip(context2, context2.getResources().getDimensionPixelSize(n));
        }
        return STATUS_BAR_HEIGHT;
    }
}

