/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import com.dtf.face.baseverify.R;
import com.dtf.face.ui.widget.RoundProgressCallback;
import com.dtf.face.utils.MobileUtil;

public class RoundProgressBar
extends View {
    public static final int STROKE = 0;
    public static final int FILL = 1;
    public boolean isPausing = false;
    public Context ctx;
    public Paint paint;
    public int roundColor;
    public float backColorWidth;
    public int roundProgressColor;
    public int secondProgressColor;
    public boolean roundShader;
    public int roundShaderStartColor;
    public int roundShaderEndColor;
    public int textColor;
    public int startAngle;
    public int endAngle;
    public float textSize;
    public float roundWidth;
    public int max;
    public int progress;
    public boolean textIsDisplayable;
    public RoundProgressCallback roundProgressCallback;
    public int style = 0;
    public int radius = 0;
    public SweepGradient mRoundShader;
    public int mWidth;
    public int backgroundColor;
    public Handler mMainHandle;
    public int maxMiliSeconds = -1;
    public Runnable processRunnable = new Runnable(){

        @Override
        public void run() {
            if (RoundProgressBar.this.isPausing) {
                1 v0 = this;
                RoundProgressBar.this.mMainHandle.postDelayed((Runnable)v0, (long)(v0.RoundProgressBar.this.maxMiliSeconds / RoundProgressBar.this.getMax()));
                return;
            }
            1 v1 = this;
            int n = v1.RoundProgressBar.this.getProgress() + 1;
            if (v1.RoundProgressBar.this.roundProgressCallback != null) {
                RoundProgressBar.this.roundProgressCallback.onProgress(RoundProgressBar.this.progress);
            }
            if (n >= RoundProgressBar.this.getMax()) {
                n = RoundProgressBar.this.getMax();
            }
            1 v2 = this;
            v2.RoundProgressBar.this.setProgress(n);
            if (n >= v2.RoundProgressBar.this.getMax()) {
                if (RoundProgressBar.this.roundProgressCallback != null) {
                    1 v3 = this;
                    v3.RoundProgressBar.this.roundProgressCallback.onFinish();
                    v3.RoundProgressBar.this.stopProcess();
                }
            } else {
                1 v4 = this;
                RoundProgressBar.this.mMainHandle.postDelayed((Runnable)v4, (long)(v4.RoundProgressBar.this.maxMiliSeconds / RoundProgressBar.this.getMax()));
            }
        }
    };
    public int mProgressAngle = 0;

    public RoundProgressBar(Context context) {
        this(context, null);
        this.ctx = context;
    }

    public RoundProgressBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.ctx = context;
    }

    public RoundProgressBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.paint = new Paint();
        this.mMainHandle = new Handler(Looper.getMainLooper());
        context = context.obtainStyledAttributes(attributeSet, R.styleable.dtf_face_round_progressBar);
        this.roundColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_round_color, -65536);
        this.roundProgressColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_round_progress_color, -16711936);
        this.secondProgressColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_round_progress_color, -16711936);
        this.textColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_text_color, -16711936);
        this.textSize = context.getDimension(R.styleable.dtf_face_round_progressBar_dtf_face_text_size, 15.0f);
        this.roundWidth = context.getDimension(R.styleable.dtf_face_round_progressBar_dtf_face_round_width, 5.0f);
        this.max = context.getInteger(R.styleable.dtf_face_round_progressBar_dtf_face_max, 100);
        this.textIsDisplayable = context.getBoolean(R.styleable.dtf_face_round_progressBar_dtf_face_text_is_displayable, true);
        this.style = context.getInt(R.styleable.dtf_face_round_progressBar_dtf_face_style, 0);
        this.roundShader = context.getBoolean(R.styleable.dtf_face_round_progressBar_dtf_face_progress_shader, false);
        this.backColorWidth = context.getDimension(R.styleable.dtf_face_round_progressBar_dtf_face_color_bg_width, 0.0f);
        this.roundShaderStartColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_gradient_color_start, 0);
        this.roundShaderEndColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_gradient_color_end, 0);
        this.startAngle = context.getInt(R.styleable.dtf_face_round_progressBar_dtf_face_start_angle, 0);
        this.endAngle = context.getInt(R.styleable.dtf_face_round_progressBar_dtf_face_end_angle, 360);
        this.backgroundColor = context.getColor(R.styleable.dtf_face_round_progressBar_dtf_face_background_color, -1);
        if (this.roundColor == -65536) {
            this.roundColor = Color.parseColor((String)"#dfe6eb");
            this.roundProgressColor = Color.parseColor((String)"#FF6A00");
            this.secondProgressColor = Color.parseColor((String)"#FF6A00");
            this.textColor = -16777216;
            this.roundWidth = MobileUtil.dp2px(this.getContext(), 5.0f);
            this.max = 100;
            this.textIsDisplayable = false;
            this.style = 0;
            this.roundShader = true;
            this.backColorWidth = 0.0f;
            this.roundShaderStartColor = Color.parseColor((String)"#dfe6eb");
            this.roundShaderEndColor = Color.parseColor((String)"#FF6A00");
            this.startAngle = -240;
            this.endAngle = 60;
            this.backgroundColor = -1;
        }
        context.recycle();
    }

    private void paintStroke(Canvas canvas, RectF rectF) {
        SweepGradient sweepGradient;
        RoundProgressBar roundProgressBar = this;
        roundProgressBar.paint.setStyle(Paint.Style.STROKE);
        roundProgressBar.paint.setColor(this.roundColor);
        int n = roundProgressBar.startAngle;
        canvas.drawArc(rectF, (float)n, (float)(this.endAngle - n), false, this.paint);
        if (this.roundShader && this.roundShaderStartColor != 0 && this.roundShaderEndColor != 0 && this.mRoundShader == null) {
            Matrix matrix;
            RectF rectF2 = rectF;
            float f2 = rectF2.centerX();
            float f3 = rectF2.centerY();
            this.mRoundShader = new SweepGradient(f2, f3, new int[]{this.roundShaderStartColor, this.roundShaderEndColor}, null);
            Matrix matrix2 = matrix;
            new Matrix().setRotate(90.0f, f2, f3);
            this.mRoundShader.setLocalMatrix(matrix2);
        }
        if ((sweepGradient = this.mRoundShader) != null) {
            this.paint.setShader((Shader)sweepGradient);
        }
        RoundProgressBar roundProgressBar2 = this;
        roundProgressBar2.paint.setColor(this.roundProgressColor);
        int n2 = roundProgressBar2.progress;
        n2 = (roundProgressBar2.endAngle - this.startAngle) * n2 / this.getMax();
        canvas.drawArc(rectF, (float)roundProgressBar2.startAngle, (float)n2, false, this.paint);
        this.paint.setShader(null);
    }

    public int getRadius() {
        return this.radius;
    }

    public void startProcess(int n, RoundProgressCallback roundProgressCallback) {
        this.roundProgressCallback = roundProgressCallback;
        this.setProgress(0);
        this.maxMiliSeconds = n;
        this.mMainHandle.post(this.processRunnable);
    }

    public void setGradientColor(int n) {
        this.roundShaderEndColor = n;
    }

    public void pauseProcess(boolean bl) {
        this.isPausing = bl;
    }

    public void stopProcess() {
        this.mMainHandle.removeCallbacks(this.processRunnable);
    }

    public void onDraw(Canvas canvas) {
        RectF rectF;
        RoundProgressBar roundProgressBar = this;
        super.onDraw(canvas);
        int n = roundProgressBar.getWidth() / 2;
        float f2 = n;
        roundProgressBar.radius = (int)(f2 - this.roundWidth / 2.0f);
        roundProgressBar.paint.setColor(this.roundColor);
        roundProgressBar.paint.setStyle(Paint.Style.STROKE);
        roundProgressBar.paint.setStrokeWidth(this.roundWidth);
        roundProgressBar.paint.setAntiAlias(true);
        roundProgressBar.paint.setStrokeCap(Paint.Cap.ROUND);
        roundProgressBar.paint.setColor(this.backgroundColor);
        roundProgressBar.paint.setStrokeWidth(0.0f);
        roundProgressBar.paint.setColor(this.textColor);
        roundProgressBar.paint.setTextSize(this.textSize);
        roundProgressBar.paint.setTypeface(Typeface.DEFAULT_BOLD);
        int n2 = (int)((float)roundProgressBar.progress / (float)this.max * 100.0f);
        float f3 = roundProgressBar.paint.measureText(n2 + "%");
        roundProgressBar.paint.setShader(null);
        if (roundProgressBar.textIsDisplayable && n2 != 0 && this.style == 0) {
            canvas.drawText(n2 + "%", f2 - f3 / 2.0f, this.textSize / 2.0f + f2, this.paint);
        }
        RoundProgressBar roundProgressBar2 = this;
        roundProgressBar2.paint.setStrokeWidth(this.roundWidth);
        RectF rectF2 = rectF;
        n2 = this.radius;
        rectF = new RectF((float)(n - n2), (float)(n - n2), (float)(n + n2), (float)(n + n2));
        roundProgressBar2.paint.setColor(this.roundColor);
        n = roundProgressBar2.style;
        if (n != 0) {
            if (n == 1) {
                RoundProgressBar roundProgressBar3 = this;
                roundProgressBar3.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                n = roundProgressBar3.progress;
                if (n != 0) {
                    int n3 = this.startAngle;
                    canvas.drawArc(rectF2, (float)(n3 + 90), (float)((this.endAngle - n3) * n / this.max), true, this.paint);
                }
            }
        } else {
            this.paintStroke(canvas, rectF2);
        }
    }

    public void setBackgroundColor(int n) {
        this.backgroundColor = n;
        this.postInvalidate();
    }

    public void setRoundColor(int n) {
        this.roundColor = n;
        this.postInvalidate();
    }

    public synchronized int getMax() {
        return this.max;
    }

    public synchronized void setMax(int n) {
        if (n >= 0) {
            this.max = n;
            return;
        }
        throw new IllegalArgumentException("max not less than 0");
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int n) {
        if (n >= 0) {
            int n2 = this.max;
            if (n <= n2) {
                n2 = n;
            }
            if (n2 <= this.max) {
                this.progress = n2;
                this.postInvalidate();
            }
            return;
        }
        throw new IllegalArgumentException("progress not less than 0");
    }

    public synchronized void setProgressAngle(int n) {
        this.mProgressAngle = n;
        this.postInvalidate();
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int n) {
        this.roundColor = n;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int n) {
        this.roundProgressColor = n;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int n) {
        this.textColor = n;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float f2) {
        this.textSize = f2;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float f2) {
        this.roundWidth = f2;
    }

    public void setRoundProgressColor(int n) {
        this.roundProgressColor = n;
    }
}

