/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.dtf.face.camera.CameraData;
import com.dtf.face.utils.MiscUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CameraUtil {
    public static byte[] cameraDataToByte(CameraData object) {
        block8: {
            CameraData cameraData = object;
            object = null;
            ByteBuffer byteBuffer = cameraData.getColorData();
            byte[] byArray = byteBuffer.array();
            object = new byte[byArray.length];
            try {
                System.arraycopy(byArray, 0, object, 0, byArray.length);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.get(new byte[byteBuffer2.remaining()]);
                }
                throw throwable;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                if (object == null) {
                    ByteBuffer byteBuffer3 = byteBuffer;
                    byte[] byArray2 = new byte[byteBuffer3.remaining()];
                    object = byArray2;
                    byteBuffer3.get(byArray2);
                }
            }
            catch (ReadOnlyBufferException readOnlyBufferException) {
                if (object != null) break block8;
                ByteBuffer byteBuffer4 = byteBuffer;
                byte[] byArray3 = new byte[byteBuffer4.remaining()];
                object = byArray3;
                byteBuffer4.get(byArray3);
            }
        }
        return object;
    }

    public static ArrayList<ByteBuffer> toBufferList(List<CameraData> arrayList) {
        ArrayList<ByteBuffer> arrayList2;
        if (arrayList == null) {
            return new ArrayList<ByteBuffer>();
        }
        ArrayList<ByteBuffer> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<ByteBuffer>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            arrayList.add(ByteBuffer.wrap(CameraUtil.cameraDataToByte((CameraData)iterator.next())));
        }
        return arrayList;
    }

    public static Bitmap toBitmap(CameraData cameraData) {
        ByteArrayOutputStream byteArrayOutputStream;
        block15: {
            Matrix matrix;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream2;
            if (cameraData == null) {
                return null;
            }
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream();
            try {
                object = cameraData.getColorData().array();
            }
            catch (Throwable throwable) {
                MiscUtil.safeClose(byteArrayOutputStream);
                return null;
            }
            YuvImage yuvImage = new YuvImage(object, 17, cameraData.getPreviewWidth(), cameraData.getPreviewHeight(), null);
            yuvImage.compressToJpeg(new Rect(0, 0, cameraData.getPreviewWidth(), cameraData.getPreviewHeight()), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            object = bitmap;
            if (bitmap == null) {
                MiscUtil.safeClose(byteArrayOutputStream);
                return null;
            }
            Object object2 = object;
            Object object3 = object;
            Matrix matrix2 = matrix;
            matrix2();
            float f2 = cameraData.getRotateAngle();
            matrix.setRotate(f2);
            cameraData = Bitmap.createBitmap((Bitmap)object2, (int)0, (int)0, (int)object.getWidth(), (int)object.getHeight(), (Matrix)matrix2, (boolean)false);
            if (object3.isRecycled()) break block15;
            object.recycle();
        }
        MiscUtil.safeClose(byteArrayOutputStream);
        return cameraData;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6 = n4;
            n4 = n3 / 2;
            n3 = n6 / 2;
            while (n4 / n5 >= n2 && n3 / n5 >= n) {
                n5 *= 2;
            }
        }
        return n5;
    }
}

