/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.log;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import baseverify.d;
import baseverify.e;
import com.alibaba.fastjson.JSONObject;
import com.dtf.face.api.IDTCrashCallback;
import com.dtf.face.config.RecordBase;
import com.dtf.face.log.EventRecord;
import com.dtf.face.log.RecordLevel;
import com.dtf.face.network.APICallback;
import com.dtf.face.network.BizRequestProxy;
import com.dtf.face.network.utils.NetworkPackUtil;
import com.dtf.face.thread.ThreadControl;
import com.dtf.face.utils.FileUtil;
import com.dtf.face.utils.MiscUtil;
import com.dtf.face.utils.MobileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RecordService
implements e {
    public static RecordService s_instance = new RecordService();
    public static final int MAX_RECORD_COUNT = 10;
    public static boolean NEED_FILE_LOG = false;
    public static String FILE_LOG_SUBPATH = "/dtf_log/";
    public static String FILE_LOG_SUBPATH_CLOSE = "/dtf_log_close/";
    public static String LOG_UPLOAD_COUNT_PATH = "/dtf_log_count/";
    public Context ctx;
    public String zimId;
    public String sessionId;
    public String phoneType;
    public String osVersion;
    public String netType;
    public String phoneLanguage;
    public String screenMetrix;
    public String publicParam = "JTdCJTdE";
    public String initUUID;
    public String verifyUUID;
    public String ocrUUID;
    public boolean isZimEnd = true;
    public String logFilePath;
    public Map<String, List<String>> logsMap = new ConcurrentHashMap<String, List<String>>();
    public String currentLogFileName = "";
    public boolean isInited = false;

    public static RecordService getInstance() {
        return s_instance;
    }

    private void logUploadCountIncrement() {
        File file;
        File file2 = file;
        if (!new File(this.ctx.getCacheDir(), LOG_UPLOAD_COUNT_PATH).exists()) {
            file2.mkdir();
        }
        new File(file2.getAbsolutePath() + "/count_" + System.currentTimeMillis()).mkdir();
    }

    private int getLogUploadTryCount() {
        File[] fileArray = new File(fileArray.ctx.getCacheDir(), LOG_UPLOAD_COUNT_PATH).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.startsWith("count");
            }
        });
        return fileArray == null ? 0 : fileArray.length;
    }

    private void limitLogFileSize() {
        if (!TextUtils.isEmpty((CharSequence)this.logFilePath)) {
            File file;
            File file2 = file;
            if (new File(this.logFilePath).exists()) {
                ArrayList<String> arrayList;
                int n = 0;
                ArrayList<String> arrayList2 = arrayList;
                arrayList = new ArrayList<String>();
                for (String string2 : file2.list()) {
                    long l = n;
                    n = (int)(new File(this.logFilePath, string2).length() + l);
                    arrayList2.add(string2);
                }
                if (n >= 0x100000) {
                    ArrayList<String> arrayList3 = arrayList2;
                    Collections.sort(arrayList3);
                    for (String string3 : arrayList3) {
                        File file3;
                        File file4 = file3;
                        if (new File(this.logFilePath, string3).exists()) {
                            n = (int)((long)n - file4.length());
                            FileUtil.deleteFile(file4);
                        }
                        if (n >= 524288) continue;
                    }
                }
            }
        }
    }

    private void initPublicParam(String string2) {
        if (string2 != null) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("packageName", (Object)string2);
            this.publicParam = MiscUtil.base64Encode(jSONObject.toJSONString());
        } else {
            this.publicParam = "JTdCJTdE";
        }
        this.phoneType = Build.FINGERPRINT;
        this.osVersion = String.valueOf(Build.VERSION.SDK_INT);
        this.screenMetrix = MobileUtil.getDisplayMetrix(this.ctx);
        this.phoneLanguage = MobileUtil.getMobileLan();
    }

    private void recordEventEx(RecordLevel object, String charSequence, String iterator, String ... object2) {
        StringBuilder stringBuilder;
        HashMap hashMap;
        EventRecord eventRecord;
        Object object3 = object = eventRecord;
        ((EventRecord)object3)();
        ((RecordBase)object3).setLogLevel("1");
        ((RecordBase)object).setActionName((String)((Object)iterator));
        ((RecordBase)object).setSessionId(this.sessionId);
        ((RecordBase)object).setPhoneType(this.phoneType);
        ((RecordBase)object).setOsVersion(this.osVersion);
        ((RecordBase)object).setNetType(this.netType);
        ((RecordBase)object).setLanguage(this.phoneLanguage);
        eventRecord.setScreenMetrix(this.screenMetrix);
        if (charSequence == null) {
            charSequence = this.zimId;
        }
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            charSequence = this.sessionId;
        }
        Object object4 = object;
        ((RecordBase)object4).setExtParam1((String)charSequence);
        ((RecordBase)object4).setExtParma2("0");
        ((RecordBase)object4).setExtParam3("0");
        iterator = hashMap;
        hashMap = new HashMap();
        if (object2 != null && ((String[])object2).length % 2 == 0) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            for (int i = 0; i < ((String[])object2).length - 1; i += 2) {
                jSONObject2.put(object2[i], (Object)object2[i + 1]);
            }
            object2 = this.initUUID;
            if (object2 != null) {
                jSONObject2.put("initTraceID", object2);
            }
            if ((object2 = this.ocrUUID) != null) {
                jSONObject2.put("ocrTraceID", object2);
            }
            if ((object2 = this.verifyUUID) != null) {
                jSONObject2.put("verifyTraceID", object2);
            }
            iterator.put("extParam", MiscUtil.base64Encode(jSONObject2.toJSONString()));
        }
        Iterator<Map.Entry<String, String>> iterator2 = iterator;
        iterator.put("logType", "BI_C_V1");
        iterator2.put("publicParam", this.publicParam);
        iterator2.put("zimId", charSequence);
        iterator2.put("uiVersion", "992");
        iterator2.put("uploadLog", "true");
        iterator2.put("productName", "faceverfy");
        iterator2.put("logPlanId", "DTF_FACE_LOGPLAN_V1");
        iterator2.put("logModelVersion", "V1.0");
        iterator2.put("zid", "NONE");
        iterator2.put("bistoken", "1234");
        iterator2.put("bioType", "facedetect");
        iterator2.put("keepUploadPage", "1");
        iterator2.put("sceneId", "DtfID+Dtf+certify+face");
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        iterator = iterator2.entrySet().iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence2 = charSequence;
            Map.Entry entry = iterator.next();
            object2 = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            CharSequence charSequence3 = charSequence;
            ((StringBuilder)charSequence3).append((String)object2);
            ((StringBuilder)charSequence3).append("=");
            ((StringBuilder)charSequence2).append(string2);
            ((StringBuilder)charSequence2).append("^");
        }
        if (((String)(charSequence = ((StringBuilder)charSequence).toString())).endsWith("^")) {
            CharSequence charSequence4 = charSequence;
            charSequence = ((String)charSequence4).substring(0, ((String)charSequence4).length() - 1);
        }
        RecordService recordService = this;
        Object object5 = object;
        ((RecordBase)object5).setExtParam4((String)charSequence);
        recordService.saveLog(((RecordBase)object5).toString());
        recordService.tryUpload(recordService.logsMap.get(this.currentLogFileName), this.currentLogFileName, this.isZimEnd, false, null);
    }

    private void tryUpload(List<String> list, String string2, boolean bl, boolean bl2, final IDTCrashCallback iDTCrashCallback) {
        if (list != null && (list.size() >= 10 || bl)) {
            if (list.size() <= 0) {
                return;
            }
            Map<String, Object> map = NetworkPackUtil.packageLogs(list, string2, new APICallback<String>(){

                @Override
                public void onSuccess(String string2) {
                    FileUtil.deleteFile(iDTCrashCallback2.RecordService.this.logFilePath + File.separator + string2);
                    IDTCrashCallback iDTCrashCallback2 = iDTCrashCallback2.iDTCrashCallback;
                    if (iDTCrashCallback2 != null) {
                        iDTCrashCallback2.onSuccess();
                    }
                }

                @Override
                public void onError(String string2, String string3, String string4) {
                    IDTCrashCallback iDTCrashCallback2 = iDTCrashCallback2.iDTCrashCallback;
                    if (iDTCrashCallback2 != null) {
                        iDTCrashCallback2.onError();
                    }
                }
            });
            BizRequestProxy.getInstance().zimUploadLog(map, (APICallback)map.get("callback"));
            if (!bl2) {
                this.currentLogFileName = Long.toString(System.currentTimeMillis());
            }
            this.logsMap.remove(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(String string2) {
        List<String> list;
        if (this.logsMap.containsKey(this.currentLogFileName)) {
            list = this.logsMap.get(this.currentLogFileName);
            if (list != null) {
                list.add(string2);
            }
        } else {
            CopyOnWriteArrayList<String> copyOnWriteArrayList;
            list = copyOnWriteArrayList;
            ((CopyOnWriteArrayList)list)();
            copyOnWriteArrayList.add(string2);
            this.logsMap.put(this.currentLogFileName, list);
        }
        if (NEED_FILE_LOG) {
            File file;
            list = file;
            file = new File(this.logFilePath, this.currentLogFileName);
            Class<RecordService> clazz = RecordService.class;
            synchronized (RecordService.class) {
                ThreadControl.sSingleExecutorService.submit(new Runnable((File)((Object)list), string2){
                    public final /* synthetic */ File val$logFile;
                    public final /* synthetic */ String val$log;
                    {
                        this.val$logFile = file;
                        this.val$log = string2;
                    }

                    @Override
                    public void run() {
                        FileUtil.writeLine(this.val$logFile, this.val$log);
                    }
                });
            }
        }
    }

    private void uploadFileLogs(String string2) {
        List<String> list = FileUtil.fileToList(new File(this.logFilePath, string2));
        int n = 0;
        while (n < list.size()) {
            int n2 = n + 10;
            List<String> list2 = n2 < list.size() ? list.subList(n, n2) : list.subList(n, list.size());
            this.tryUpload(list2, string2, true, true, null);
            n = n2;
        }
    }

    public static /* synthetic */ String access$102(RecordService recordService, String string2) {
        recordService.logFilePath = string2;
        return string2;
    }

    public void initSDK(Context context, String string2) {
        RecordService recordService = this;
        d.a = this;
        e e2 = d.a;
        this.ctx = context;
        e2.initPublicParam(string2);
        e2.initNeedFileLog();
        e2.currentLogFileName = Long.toString(System.currentTimeMillis());
        recordService.init(context, null);
        if (!recordService.isInited && this.getLogUploadTryCount() < 3) {
            this.uploadHistoryFileLog();
        }
        this.isInited = true;
    }

    public void initNeedFileLog() {
        ThreadControl.sSingleExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                File file;
                NEED_FILE_LOG = new File(RecordService.this.ctx.getCacheDir(), FILE_LOG_SUBPATH).exists();
                File file2 = file;
                file = new File(RecordService.this.ctx.getCacheDir(), FILE_LOG_SUBPATH);
                RecordService.access$102(RecordService.this, file2.getAbsolutePath());
                if (NEED_FILE_LOG) {
                    if (!file2.exists()) {
                        file2.mkdir();
                    } else {
                        RecordService.this.limitLogFileSize();
                    }
                }
            }
        });
    }

    public void initLogEnv() {
        File file;
        File file2;
        final File file3 = file2;
        file2 = new File(this.ctx.getCacheDir(), FILE_LOG_SUBPATH_CLOSE);
        final File file4 = file;
        file = new File(this.ctx.getCacheDir(), FILE_LOG_SUBPATH);
        if (NEED_FILE_LOG) {
            File file5;
            if (!file4.exists() || file3.exists()) {
                ThreadControl.sSingleExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        3 v0 = this;
                        FileUtil.deleteDir(v0.file3);
                        FileUtil.mkDir(v0.file4);
                    }
                });
            }
            file3 = file5;
            if (new File(this.ctx.getCacheDir(), LOG_UPLOAD_COUNT_PATH).exists() && file3.isDirectory()) {
                ThreadControl.sSingleExecutorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        FileUtil.deleteDirChildren(file3.getAbsolutePath());
                    }
                });
            }
        } else if (!file3.exists() || file4.exists()) {
            ThreadControl.sSingleExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    5 v0 = this;
                    FileUtil.deleteDir(v0.file4);
                    FileUtil.mkDir(v0.file3);
                }
            });
        }
    }

    public void init(Context context, String string2) {
        this.ctx = context;
        this.zimId = string2;
        if (TextUtils.isEmpty((CharSequence)this.sessionId)) {
            this.sessionId = UUID.randomUUID().toString().replace("-", "");
        }
        this.netType = MobileUtil.getNetworkType(context) + "|" + MobileUtil.getOperatorName(context);
        if (string2 != null) {
            this.isZimEnd = false;
        }
        this.resetUUID();
        if (string2 == null) {
            RecordService recordService = this;
            recordService.tryUpload(recordService.logsMap.get(this.currentLogFileName), this.currentLogFileName, NEED_FILE_LOG ^ true, false, null);
        }
    }

    public void recordException(Throwable throwable) {
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        stringArray2[0] = "exception";
        stringArray[1] = Log.getStackTraceString((Throwable)throwable);
        RecordService.getInstance().recordEvent(RecordLevel.LOG_ERROR, "FaceVerify", stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEvent(RecordLevel recordLevel, String string2, String ... stringArray) {
        Class<RecordService> clazz = RecordService.class;
        synchronized (clazz) {
            this.recordEventEx(recordLevel, null, string2, stringArray);
            // ** MonitorExit[com.dtf.face.log.RecordService.class] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void recordDTEvent(String string2, String ... stringArray) {
        this.recordEvent(RecordLevel.LOG_ERROR, string2, stringArray);
    }

    public void recordEventCustomZimId(String string2) {
        this.recordEventEx(RecordLevel.LOG_ERROR, string2, "customZimId", new String[0]);
    }

    public void uploadHistoryFileLog() {
        ThreadControl.sSingleExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                RecordService.this.logUploadCountIncrement();
                String[] stringArray = new File(RecordService.this.logFilePath).list();
                if (stringArray != null) {
                    for (String string2 : stringArray) {
                        if (string2.compareTo(RecordService.this.currentLogFileName) >= 0 || RecordService.this.logsMap.containsKey(string2)) continue;
                        RecordService.this.uploadFileLogs(string2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Class<RecordService> clazz = RecordService.class;
        RecordService recordService = this;
        synchronized (clazz) {
            recordService.resetUUID();
            recordService.tryUpload(recordService.logsMap.get(this.currentLogFileName), this.currentLogFileName, true, false, null);
            // ** MonitorExit[com.dtf.face.log.RecordService.class] (shouldn't be in output)
            return;
        }
    }

    public void zimEnd() {
        this.flush();
        this.isZimEnd = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCrash(IDTCrashCallback iDTCrashCallback) {
        Class<RecordService> clazz = RecordService.class;
        RecordService recordService = this;
        synchronized (clazz) {
            recordService.tryUpload(recordService.logsMap.get(this.currentLogFileName), this.currentLogFileName, true, false, iDTCrashCallback);
            // ** MonitorExit[com.dtf.face.log.RecordService.class] (shouldn't be in output)
            return;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void resetUUID() {
        RecordService recordService = this;
        recordService.initUUID = null;
        recordService.verifyUUID = null;
        recordService.ocrUUID = null;
    }

    public void setInitUUID(String string2) {
        this.initUUID = string2;
    }

    public void setVerifyUUID(String string2) {
        this.verifyUUID = string2;
    }

    public void setOcrUUID(String string2) {
        if (this.ocrUUID == null) {
            this.ocrUUID = string2;
        } else {
            RecordService recordService = this;
            recordService.ocrUUID = this.ocrUUID + "#";
            recordService.ocrUUID = this.ocrUUID + string2;
        }
    }
}

