/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.face.photinus;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.net.Uri;
import com.dtf.face.photinus.OnVideoWriteListener;
import com.dtf.face.photinus.VideoFormatConfig;
import com.dtf.face.photinus.VideoWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class VideoEncoderHelper {
    public static final boolean VERBOSE = false;
    public static final String MIME_TYPE = "video/avc";
    public static final int IFRAME_INTERVAL = 10;
    public static final String TAG = "VideoEncoderHelper";

    /*
     * Unable to fully structure code
     */
    public static void encode(Context var0, List<ByteBuffer> var1_1, int var2_4, int var3_5, int var4_6, String var5_7, VideoFormatConfig var6_8, OnVideoWriteListener var7_9) {
        block10: {
            v0 = var0;
            var0 = null;
            try {
                var0 = VideoEncoderHelper.prepareEncoder(v0, var3_5, var4_6, (String)var5_7, var6_8, var2_4);
            }
            catch (Exception v1) {
                var7_9.onVideoWriteError(v1.getMessage());
            }
            if (var0 == null || !var0.isValid()) break block10;
            var1_2 = 0;
            var5_7 = var1_1.iterator();
            while (true) {
                if (!var5_7.hasNext()) break;
                VideoEncoderHelper.encodeNextFrame(var1_2, VideoWriter.rotateYUV420Degree(((ByteBuffer)var5_7.next()).array(), var3_5, var4_6, var2_4), (MediaWrapper)var0);
                ++var1_2;
                continue;
                break;
            }
            VideoEncoderHelper.encodeNextFrame(var1_2, null, (MediaWrapper)var0);
            var1_3 = var0._encoder;
            if (var1_3 == null) ** GOTO lbl27
            var1_3.stop();
            var0._encoder.release();
            var0._encoder = null;
lbl27:
            // 2 sources

            if ((var1_3 = var0._muxer) == null) ** GOTO lbl33
            try {
                var1_3.stop();
                var0._muxer.release();
                var0._muxer = null;
                var0._muxerStarted = false;
lbl33:
                // 2 sources

                var7_9.onVideoWriteSuccess(Uri.fromFile((File)var0._outputFile));
            }
            catch (Exception v2) {
                var7_9.onVideoWriteError(v2.getMessage());
            }
        }
    }

    public static void encodeNextFrame(int n2, byte[] byArray, MediaWrapper mediaWrapper) {
        MediaCodec.BufferInfo bufferInfo;
        MediaWrapper mediaWrapper2 = mediaWrapper;
        ByteBuffer[] byteBufferArray = mediaWrapper2._encoder.getInputBuffers();
        MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        int n3 = mediaWrapper2._encoder.dequeueInputBuffer(10000L);
        if (n3 >= 0) {
            long l2 = VideoWriter.computePresentationTime(n2);
            if (byArray == null) {
                mediaWrapper._encoder.queueInputBuffer(n3, 0, 0, l2, 4);
                VideoEncoderHelper.drainEncoder(true, bufferInfo2, mediaWrapper);
            } else {
                ByteBuffer byteBuffer = byteBufferArray[n3];
                byteBuffer.clear();
                byteBuffer.put(byArray);
                mediaWrapper._encoder.queueInputBuffer(n3, 0, byArray.length, l2, 0);
                VideoEncoderHelper.drainEncoder(false, bufferInfo2, mediaWrapper);
            }
        }
    }

    public static void drainEncoder(boolean bl, MediaCodec.BufferInfo bufferInfo, MediaWrapper mediaWrapper) {
        int n2;
        block15: {
            if (bl) {
                try {
                    mediaWrapper._encoder.signalEndOfInputStream();
                }
                catch (Exception exception) {}
            }
            ByteBuffer[] byteBufferArray = mediaWrapper._encoder.getOutputBuffers();
            while (true) {
                if ((n2 = mediaWrapper._encoder.dequeueOutputBuffer(bufferInfo, 10000L)) == -1) {
                    if (bl) continue;
                    break;
                }
                if (n2 == -3) {
                    byteBufferArray = mediaWrapper._encoder.getOutputBuffers();
                    continue;
                }
                if (n2 == -2) {
                    if (!mediaWrapper._muxerStarted) {
                        MediaWrapper mediaWrapper2 = mediaWrapper;
                        MediaFormat mediaFormat = mediaWrapper2._encoder.getOutputFormat();
                        mediaWrapper2._trackIndex = mediaWrapper2._muxer.addTrack(mediaFormat);
                        mediaWrapper2._muxer.start();
                        mediaWrapper2._muxerStarted = true;
                        continue;
                    }
                    throw new Exception("format changed twice");
                }
                if (n2 < 0) continue;
                ByteBuffer byteBuffer = byteBufferArray[n2];
                if (byteBuffer != null) {
                    if ((bufferInfo.flags & 2) != 0) {
                        bufferInfo.size = 0;
                    }
                    if (bufferInfo.size != 0) {
                        if (mediaWrapper._muxerStarted) {
                            byteBuffer.position(bufferInfo.offset);
                            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                            try {
                                mediaWrapper._muxer.writeSampleData(mediaWrapper._trackIndex, byteBuffer, bufferInfo);
                            }
                            catch (Exception exception) {}
                        } else {
                            throw new Exception("muxer hasn't started");
                        }
                    }
                    mediaWrapper._encoder.releaseOutputBuffer(n2, false);
                    if ((bufferInfo.flags & 4) != 0) break;
                    continue;
                }
                break block15;
                break;
            }
            return;
        }
        throw new Exception("encoderOutputBuffer " + n2 + " was null");
    }

    public static MediaWrapper prepareEncoder(Context object, int n2, int n3, String string, VideoFormatConfig videoFormatConfig, int n4) {
        File file;
        MediaWrapper mediaWrapper;
        Context context = object;
        object = VideoEncoderHelper.selectCodec(MIME_TYPE);
        MediaWrapper mediaWrapper2 = mediaWrapper;
        mediaWrapper = new MediaWrapper();
        Uri uri = Uri.withAppendedPath((Uri)Uri.fromFile((File)context.getCacheDir()), (String)"Phontinus");
        File file2 = file;
        if (!new File(uri.getPath()).exists()) {
            file2.mkdir();
        }
        string = Uri.withAppendedPath((Uri)uri, (String)(string + ".mp4"));
        mediaWrapper2._outputFile = new File(string.getPath());
        if (mediaWrapper2._outputFile.exists()) {
            mediaWrapper2._outputFile.delete();
        }
        int n5 = 21;
        MediaFormat mediaFormat = n4 != 90 && n4 != 270 ? MediaFormat.createVideoFormat((String)MIME_TYPE, (int)n2, (int)n3) : MediaFormat.createVideoFormat((String)MIME_TYPE, (int)n3, (int)n2);
        MediaWrapper mediaWrapper3 = mediaWrapper2;
        MediaFormat mediaFormat2 = mediaFormat;
        mediaFormat.setInteger("color-format", n5);
        mediaFormat.setInteger("bitrate", videoFormatConfig.getBitRate());
        mediaFormat2.setInteger("frame-rate", videoFormatConfig.getFrameRate());
        mediaFormat2.setInteger("i-frame-interval", 10);
        try {
            mediaWrapper3._encoder = MediaCodec.createByCodecName((String)object.getName());
        }
        catch (IOException iOException) {
            throw new Exception("create codec by name error, msg = " + iOException.getMessage());
        }
        mediaWrapper3._encoder.configure(mediaFormat, null, null, 1);
        mediaWrapper3._encoder.start();
        object = mediaWrapper3._outputFile.getAbsolutePath();
        try {
            mediaWrapper3._muxer = new MediaMuxer((String)object, 0);
            return mediaWrapper3;
        }
        catch (IOException iOException) {
            throw new Exception("create muxer error, msg = " + iOException.getMessage());
        }
    }

    public static MediaCodecInfo selectCodec(String string) {
        MediaCodecInfo mediaCodecInfo = VideoEncoderHelper.selectGoogleCodec(string);
        if (mediaCodecInfo != null) {
            return mediaCodecInfo;
        }
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo2 = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo2.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo2.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo2;
            }
        }
        throw new Exception("not support mimeType");
    }

    public static MediaCodecInfo selectGoogleCodec(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String string2 = mediaCodecInfo.getName();
            if (string2 == null) {
                string2 = "";
            }
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string) || !string2.contains("google")) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    public static class MediaWrapper {
        public MediaCodec _encoder;
        public MediaMuxer _muxer;
        public File _outputFile;
        public boolean _muxerStarted;
        public int _trackIndex;

        public boolean isValid() {
            return this._encoder != null && this._muxer != null && this._outputFile != null;
        }
    }
}

