/*
 * Decompiled with CFR 0.152.
 */
package com.dtf.toyger.base.face;

import android.graphics.Rect;
import android.graphics.RectF;
import com.dtf.toyger.base.algorithm.TGFrame;
import com.dtf.toyger.base.face.ToygerDepthInfo;
import com.dtf.toyger.base.face.ToygerFaceAttr;
import com.dtf.toyger.base.face.ToygerFaceBlobConfig;
import com.dtf.toyger.base.face.ToygerFaceInfo;
import faceverify.m;
import faceverify.o;
import java.util.List;
import java.util.Map;

public abstract class FaceBlobManager
extends m<ToygerFaceInfo> {
    public static final int MONITOR_IMAGE_WIDTH = 160;
    public static final int MONITOR_COMPRESS_RATE = 30;
    public boolean isMirror;
    public String compressFormat;
    public float compressRate;
    public ToygerDepthInfo depthInfo;
    public TGFrame irFrame;
    public byte[] bestLightImage;
    public byte[] bestIRImage;
    public byte[] bestDepthImage;
    public int desireWidth;
    public boolean isNano;

    public FaceBlobManager() {
    }

    public FaceBlobManager(ToygerFaceBlobConfig toygerFaceBlobConfig, boolean bl) {
        FaceBlobManager faceBlobManager = this;
        this.config = toygerFaceBlobConfig;
        faceBlobManager.desireWidth = toygerFaceBlobConfig.desiredWidth;
        faceBlobManager.crypto = new o(toygerFaceBlobConfig.pubkey, bl);
    }

    public static Rect convertFaceRegion(RectF rectF, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            float f2 = n2;
            float f3 = n3;
            return new Rect((int)((1.0f - rectF.right) * f2), (int)(rectF.top * f3), (int)((1.0f - rectF.left) * f2), (int)(rectF.bottom * f3));
        }
        float f4 = n2;
        float f5 = n3;
        return new Rect((int)(rectF.left * f4), (int)(rectF.top * f5), (int)(rectF.right * f4), (int)(rectF.bottom * f5));
    }

    @Override
    public abstract byte[] generateBlob(List<ToygerFaceInfo> var1, Map<String, Object> var2);

    @Override
    public abstract boolean isUTF8();

    @Override
    public byte[] getKey() {
        return this.crypto.b;
    }

    public abstract void addMonitorImage(TGFrame var1);

    public abstract byte[] getMonitorBlob();

    public abstract byte[] generateFaceBlob(TGFrame var1, ToygerFaceAttr var2);

    public abstract Map<String, Object> generateBlob(Map<String, Object> var1);

    public abstract byte[] getFileIdBlob(String var1);

    public abstract byte[] generateLocalMatchingBlob(String var1, byte[] var2, byte[] var3, String var4);

    public String getBlobElemType(ToygerFaceInfo toygerFaceInfo) {
        switch (toygerFaceInfo.frame.frameType) {
            default: {
                return "";
            }
            case 4: {
                return "Nano";
            }
            case 3: {
                return "SLIR";
            }
            case 2: {
                return "Depth";
            }
            case 1: {
                return "Dark";
            }
            case 0: 
        }
        return "Pano";
    }
}

