/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import org.ejbca.cvc.AuthorizationRole;

public enum AuthorizationRoleEnum implements AuthorizationRole
{
    CVCA(192),
    DV_D(128),
    DV_F(64),
    IS(0);

    public byte value;

    public AuthorizationRoleEnum(int n3) {
        this.value = (byte)n3;
    }

    @Override
    public byte getValue() {
        return this.value;
    }

    @Override
    public boolean isCVCA() {
        return this == CVCA;
    }

    public boolean isDV() {
        return this == DV_D || this == DV_F;
    }

    public boolean isDomesticDV() {
        return this == DV_D;
    }

    public boolean isForeignDV() {
        return this == DV_F;
    }

    public boolean isAccreditationBodyDV() {
        return false;
    }

    public boolean isCertificationServiceProviderDV() {
        return false;
    }

    public boolean isIS() {
        return this == IS;
    }

    public boolean isAuthenticationTerminal() {
        return false;
    }

    public boolean isSignatureTerminal() {
        return false;
    }

    public String toString() {
        switch (this) {
            default: {
                throw new IllegalStateException("Enum case not handled");
            }
            case IS: {
                return "IS";
            }
            case DV_F: {
                return "DV-foreign";
            }
            case DV_D: {
                return "DV-domestic";
            }
            case CVCA: 
        }
        return "CVCA";
    }
}

