/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.util.Date;
import org.ejbca.cvc.AbstractSequence;
import org.ejbca.cvc.AccessRightEnum;
import org.ejbca.cvc.AccessRights;
import org.ejbca.cvc.AuthorizationRole;
import org.ejbca.cvc.AuthorizationRoleEnum;
import org.ejbca.cvc.CAReferenceField;
import org.ejbca.cvc.CVCAuthorizationTemplate;
import org.ejbca.cvc.CVCPublicKey;
import org.ejbca.cvc.CVCTagEnum;
import org.ejbca.cvc.DateField;
import org.ejbca.cvc.HolderReferenceField;
import org.ejbca.cvc.IntegerField;

public class CVCertificateBody
extends AbstractSequence {
    public static final long serialVersionUID = 1L;
    public static CVCTagEnum[] allowedFields = new CVCTagEnum[]{CVCTagEnum.PROFILE_IDENTIFIER, CVCTagEnum.CA_REFERENCE, CVCTagEnum.PUBLIC_KEY, CVCTagEnum.HOLDER_REFERENCE, CVCTagEnum.HOLDER_AUTH_TEMPLATE, CVCTagEnum.EFFECTIVE_DATE, CVCTagEnum.EXPIRATION_DATE};

    public CVCertificateBody() {
        super(CVCTagEnum.CERTIFICATE_BODY);
    }

    public CVCertificateBody(CAReferenceField cAReferenceField, CVCPublicKey cVCPublicKey, HolderReferenceField holderReferenceField) {
        this();
        if (cVCPublicKey != null) {
            if (holderReferenceField != null) {
                this.addSubfield(new IntegerField(CVCTagEnum.PROFILE_IDENTIFIER, 0));
                this.addSubfield(cAReferenceField);
                this.addSubfield(cVCPublicKey);
                this.addSubfield(holderReferenceField);
                return;
            }
            throw new IllegalArgumentException("holderReference is null");
        }
        throw new IllegalArgumentException("publicKey is null");
    }

    public CVCertificateBody(CAReferenceField cAReferenceField, CVCPublicKey cVCPublicKey, HolderReferenceField holderReferenceField, AuthorizationRole authorizationRole, AccessRights accessRights, Date date, Date date2) {
        this(cAReferenceField, cVCPublicKey, holderReferenceField);
        if (authorizationRole != null) {
            if (accessRights != null) {
                if (date != null) {
                    if (date2 != null) {
                        CVCertificateBody cVCertificateBody = this;
                        cVCertificateBody.addSubfield(new CVCAuthorizationTemplate(authorizationRole, accessRights));
                        cVCertificateBody.addSubfield(new DateField(CVCTagEnum.EFFECTIVE_DATE, date));
                        cVCertificateBody.addSubfield(new DateField(CVCTagEnum.EXPIRATION_DATE, date2));
                        return;
                    }
                    throw new IllegalArgumentException("validTo is null");
                }
                throw new IllegalArgumentException("validFrom is null");
            }
            throw new IllegalArgumentException("accessRight is null");
        }
        throw new IllegalArgumentException("authRole is null");
    }

    public CVCertificateBody(CAReferenceField cAReferenceField, CVCPublicKey cVCPublicKey, HolderReferenceField holderReferenceField, AuthorizationRoleEnum authorizationRoleEnum, AccessRightEnum accessRightEnum, Date date, Date date2) {
        this(cAReferenceField, cVCPublicKey, holderReferenceField, (AuthorizationRole)authorizationRoleEnum, (AccessRights)accessRightEnum, date, date2);
    }

    @Override
    public CVCTagEnum[] getAllowedFields() {
        return allowedFields;
    }

    public CVCAuthorizationTemplate getAuthorizationTemplate() {
        return (CVCAuthorizationTemplate)this.getSubfield(CVCTagEnum.HOLDER_AUTH_TEMPLATE);
    }

    public Date getValidFrom() {
        return ((DateField)this.getSubfield(CVCTagEnum.EFFECTIVE_DATE)).getDate();
    }

    public Date getValidTo() {
        return ((DateField)this.getSubfield(CVCTagEnum.EXPIRATION_DATE)).getDate();
    }

    public CAReferenceField getAuthorityReference() {
        return (CAReferenceField)this.getOptionalSubfield(CVCTagEnum.CA_REFERENCE);
    }

    public CVCPublicKey getPublicKey() {
        return (CVCPublicKey)this.getSubfield(CVCTagEnum.PUBLIC_KEY);
    }

    public HolderReferenceField getHolderReference() {
        return (HolderReferenceField)this.getSubfield(CVCTagEnum.HOLDER_REFERENCE);
    }
}

