/*
 * Decompiled with CFR 0.152.
 */
package org.ejbca.cvc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.ArrayList;
import java.util.Collection;
import org.ejbca.cvc.CVCertificate;
import org.ejbca.cvc.CardVerifiableCertificate;
import org.ejbca.cvc.CertificateParser;
import org.ejbca.cvc.exception.ConstructionException;
import org.ejbca.cvc.exception.ParseException;

public class JDKCVCertificateFactory
extends CertificateFactorySpi {
    private byte[] readBytes(InputStream inputStream) {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream2.write(byArray, 0, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2;
        inputStream.close();
        byteArrayOutputStream3.close();
        return byteArrayOutputStream3.toByteArray();
    }

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) {
        CVCertificate cVCertificate = CertificateParser.parseCertificate(((JDKCVCertificateFactory)((Object)cVCertificate)).readBytes(inputStream));
        try {
            return new CardVerifiableCertificate(cVCertificate);
        }
        catch (ConstructionException constructionException) {
            throw new CertificateException(constructionException.toString());
        }
        catch (ParseException parseException) {
            throw new CertificateException(parseException.toString());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) {
        Certificate certificate = ((JDKCVCertificateFactory)((Object)certificate)).engineGenerateCertificate(inputStream);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(certificate);
        return arrayList;
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }

    public Collection engineGenerateCRLs(InputStream inputStream) {
        throw new CRLException("CVC CertificateFactory can not create CRLs");
    }
}

