/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.content.Context;
import android.text.TextUtils;
import com.html5app.uni_tencent_call.R;
import com.html5app.uni_tencent_call.TRTCHttpHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TRTCGetUserIDAndUserSig {
    private int mSdkAppId = 0;
    private ArrayList<String> mUserIdArray = new ArrayList();
    private ArrayList<String> mUserSigArray = new ArrayList();
    private TRTCHttpHelper httpHelper;

    public TRTCGetUserIDAndUserSig(Context context) {
        this.loadFromConfig(context);
    }

    public int getSdkAppIdFromConfig() {
        return this.mSdkAppId;
    }

    public ArrayList<String> getUserIdFromConfig() {
        return this.mUserIdArray;
    }

    public ArrayList<String> getUserSigFromConfig() {
        return this.mUserSigArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromConfig(Context context) {
        InputStream is = null;
        try {
            is = context.getResources().openRawResource(R.raw.config);
            String jsonData = this.readTextFromInputStream(is);
            this.loadJsonData(jsonData);
        }
        catch (Exception e) {
            this.mUserIdArray = new ArrayList();
            this.mUserSigArray = new ArrayList();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void getUserSigFromServer(int sdkAppId, int roomId, String userId, String password, IGetUserSigListener listener) {
        if (this.httpHelper == null) {
            this.httpHelper = new TRTCHttpHelper();
        }
        this.httpHelper.post(sdkAppId, roomId, userId, password, listener);
    }

    private String readTextFromInputStream(InputStream is) throws Exception {
        String str;
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer buffer = new StringBuffer("");
        while (null != (str = bufferedReader.readLine())) {
            buffer.append(str);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private void loadJsonData(String jsonData) {
        if (TextUtils.isEmpty((CharSequence)jsonData)) {
            return;
        }
        try {
            JSONTokener jsonTokener = new JSONTokener(jsonData);
            JSONObject msgJson = (JSONObject)jsonTokener.nextValue();
            this.mSdkAppId = msgJson.getInt("sdkappid");
            JSONArray jsonUsersArr = msgJson.getJSONArray("users");
            if (null != jsonUsersArr) {
                for (int i = 0; i < jsonUsersArr.length(); ++i) {
                    JSONObject jsonUser = jsonUsersArr.getJSONObject(i);
                    this.mUserIdArray.add(jsonUser.getString("userId"));
                    this.mUserSigArray.add(jsonUser.getString("userToken"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mSdkAppId = -1;
        }
    }

    public static interface IGetUserSigListener {
        public void onComplete(String var1, String var2);
    }
}

