/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.text.TextUtils;
import android.util.Log;
import com.html5app.uni_tencent_call.TRTCGetUserIDAndUserSig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TRTCHttpHelper {
    private static final int CONNECT_TIMEOUT = 10;
    private static final int READ_TIMEOUT = 8;
    private static final int WRITE_TIMEOUT = 8;
    private static final String JSON_ERRORCODE = "errorCode";
    private static final String JSON_ERRORINFO = "errorInfo";
    private static final String JSON_DATA = "data";
    private static final String JSON_APPID = "appid";
    private static final String JSON_ROOMNUM = "roomnum";
    private static final String JSON_IDENTIFIER = "identifier";
    private static final String JSON_USERSIG = "userSig";
    private static final String JSON_PWD = "pwd";
    private static final String JSON_PRIVMAP = "privMap";
    private static final String JSON_ACCTYPE = "accounttype";
    private static final String SERVER_URL = "";
    private static final String TAG = TRTCHttpHelper.class.getSimpleName();
    private OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetryInterceptor(3)).readTimeout(8L, TimeUnit.SECONDS).writeTimeout(8L, TimeUnit.SECONDS).connectTimeout(10L, TimeUnit.SECONDS).build();

    public void post(int sdkAppId, int roomId, String userId, String password, final TRTCGetUserIDAndUserSig.IGetUserSigListener listener) {
        block4: {
            if (TextUtils.isEmpty((CharSequence)SERVER_URL)) {
                if (listener != null) {
                    listener.onComplete(null, "url is empty");
                }
                return;
            }
            try {
                JSONObject jsonReq = new JSONObject();
                jsonReq.put(JSON_APPID, sdkAppId);
                jsonReq.put(JSON_ROOMNUM, roomId);
                jsonReq.put(JSON_IDENTIFIER, (Object)userId);
                jsonReq.put(JSON_PWD, (Object)password);
                jsonReq.put(JSON_PRIVMAP, 255);
                jsonReq.put(JSON_ACCTYPE, 14418);
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonReq.toString());
                Request req = new Request.Builder().url(SERVER_URL).post(body).build();
                Log.i((String)TAG, (String)("loadUserSig->url: " + req.url().toString()));
                Log.i((String)TAG, (String)("loadUserSig->post: " + jsonReq.toString()));
                this.okHttpClient.newCall(req).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Log.w((String)TAG, (String)("loadUserSig->fail: " + e.toString()));
                        if (listener != null) {
                            listener.onComplete(null, "http request failed");
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        block9: {
                            if (!response.isSuccessful()) {
                                Log.w((String)TAG, (String)("loadUserSig->fail: " + response.message()));
                                if (listener != null) {
                                    listener.onComplete(null, response.message());
                                }
                            } else {
                                try {
                                    JSONTokener jsonTokener = new JSONTokener(response.body().string());
                                    JSONObject msgJson = (JSONObject)jsonTokener.nextValue();
                                    int code = msgJson.getInt(TRTCHttpHelper.JSON_ERRORCODE);
                                    if (0 != code) {
                                        if (listener != null) {
                                            listener.onComplete(null, msgJson.getString(TRTCHttpHelper.JSON_ERRORINFO));
                                        }
                                    } else {
                                        JSONObject dataJson = msgJson.getJSONObject(TRTCHttpHelper.JSON_DATA);
                                        String userSig = dataJson.getString(TRTCHttpHelper.JSON_USERSIG);
                                        if (listener != null) {
                                            listener.onComplete(userSig, msgJson.getString(TRTCHttpHelper.JSON_ERRORINFO));
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    Log.i((String)TAG, (String)("loadUserSig->exception: " + e.toString()));
                                    if (listener == null) break block9;
                                    listener.onComplete(null, e.toString());
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                if (listener == null) break block4;
                listener.onComplete(null, e.toString());
            }
        }
    }

    static class RetryInterceptor
    implements Interceptor {
        public int maxRetry;
        private int retryNum = 0;

        public RetryInterceptor(int maxRetry) {
            this.maxRetry = maxRetry;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Log.i((String)"ServerUserSig", (String)("retryNum=" + this.retryNum + "/" + this.maxRetry));
            Response response = chain.proceed(request);
            while (!response.isSuccessful() && this.retryNum < this.maxRetry) {
                ++this.retryNum;
                Log.i((String)"ServerUserSig", (String)("retryNum=" + this.retryNum + "/" + this.maxRetry));
                response = chain.proceed(request);
            }
            return response;
        }
    }
}

